;;;
;;;  cmail-edit.el - editing mails
;;;
;;;  $Author: tmp $
;;;  created at: Mon Jul 12 10:23:10 JST 1993
;;;
;;;  Copyright (C) 1992-1996 Yukihiro Matsumoto.

;; cmail editing mail and index
;; This file is not part of GNU Emacs but obeys its copyright notice.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU Emacs General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; GNU Emacs, but only under the conditions described in the
;; GNU Emacs General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU Emacs so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.

(provide 'cmail-edit)
(require 'cmail)

(defvar *cmail-edit-buffer " *cmail-editing*"
  "$B%a%$%kJT=8MQB`Hr%P%C%U%!(B.")

(defvar *cmail-editing-folder nil
  "$BJT=8Cf$N%a%$%k$N%U%)%k%@$,J];}$5$l$k(B.")

(defvar *cmail-editing-page nil
  "$BJT=8Cf$N%a%$%k$N%Z!<%8HV9f$,J];}$5$l$k(B.")

(put 'cmail-edit-mode 'mode-class 'special)
(defvar cmail-edit-mode-map nil)

(defun cmail-edit-mode ()
  "$B%a%$%kJT=8$G;HMQ$9$k%b!<%I(B.

cmail EDIT mode.
Key bindings are below,
\\[cmail-cease-edit]	: $BJT=8$r=*N;$9$k(B
\\[cmail-abort-edit]	: $BJT=8$rCfCG$9$k(B"
  (interactive)
  (save-excursion
    (use-local-map cmail-edit-mode-map)
    (setq mode-name "Edit")
    (setq major-mode 'cmail-edit-mode)
    (setq truncate-lines nil)
    (let ((page-delimiter *cmail-re-bdr))
      (narrow-to-page))
    (run-hooks 'cmail-edit-mode-hook)))
;;
(if cmail-edit-mode-map
    nil
  (setq cmail-edit-mode-map (copy-keymap text-mode-map))
  (define-key cmail-edit-mode-map "\C-c\C-c" 'cmail-cease-edit)
  (define-key cmail-edit-mode-map "\C-c\C-]" 'cmail-abort-edit)
  (define-key cmail-edit-mode-map "\C-xo" 'cmail-abort-edit-0))
;; ======================================================================

;; ++++ $B%a%$%k$rJT=8$9$k(B(interactive) +++++++++++++++++++++++++++++++++++++++
(defun cmail-edit (page)
  "FOLDER$B$N(BPAGE$B%a%$%k$rJT=8$9$k(B."
  (interactive (list (cmail-get-page-number-from-summary)))
  (cmail-show-contents page)
  (let ((folder cmail-current-folder) buf gbw)
    (if (not (y-or-n-p (cmail-get-resource 'edit-1)))
	(cmail-message-resource 'edit-2)
      (cmail-get-folder folder)
      (cmail-n-page page)
      (let ((beg (point)) (end (cmail-page-max)))
	(setq buf (current-buffer))
	(set-buffer (get-buffer-create *cmail-edit-buffer))
	(erase-buffer)
	(cmail-insert-buffer-substring buf beg end))
      (let ((code (detect-coding-region (point-min) (point-max))))
	(if (listp code) (setq code (car code)))
	(decode-coding-region (point-min) (point-max) code))
      (goto-char (point-min))
      (setq buf (current-buffer))
      (setq gbw (get-buffer-window *cmail-mail-buffer))
      (and gbw (select-window gbw))
      (switch-to-buffer buf)
      (cmail-edit-mode)
      (setq mode-line-buffer-identification
	    (format "cmail:   << Editing  %s / %d >>" folder page))
      (setq *cmail-editing-folder folder)
      (setq *cmail-editing-page page)
      (message
       (substitute-command-keys (cmail-get-resource 'edit-3))))))

(defun cmail-cease-edit ()
  "$BJT=8$r=*N;$9$k(B."
  (interactive)
  (if (string= *cmail-editing-folder cmail-current-folder)
      nil
    (cmail-select-buffer *cmail-mail-buffer)
    (kill-buffer *cmail-edit-buffer)
    (cmail-error-resource 'cease-edit-1))
  (cmail-get-folder)
  (cmail-n-page *cmail-editing-page)
  (let ((code (detect-coding-region (point) (cmail-page-max))) beg end)
    (if (listp code) (setq code (car code)))
    (save-excursion
      (set-buffer *cmail-edit-buffer)
      (encode-coding-region (point-min) (point-max) code)
      (setq beg (point-min))
      (setq end (point-max)))
    (delete-region (point) (cmail-page-max))
    (cmail-insert-buffer-substring *cmail-edit-buffer beg end))
  (cmail-n-page *cmail-editing-page)
  (let ((status-mark (cmail-set-mail-status "Edited")))
    (widen)
    (cmail-select-buffer *cmail-summary-buffer)
    (apply 'cmail-put-mark *cmail-editing-page status-mark))
  (cmail-show-contents *cmail-editing-page)
  (setq *cmail-editing-folder nil)
  (setq *cmail-editing-page nil)
  (cmail-message-resource 'cease-edit-2))

(defun cmail-abort-edit-0 ()
  "$BJT=8$rCfCG$9$k(B($B3NG'$J$7(B)."
  (interactive)
  (set-window-buffer (get-buffer-window (current-buffer))
		     *cmail-mail-buffer)
  (kill-buffer *cmail-edit-buffer)
  (cmail-select-buffer *cmail-summary-buffer)
  (setq *cmail-editing-folder nil)
  (setq *cmail-editing-page nil))

(defun cmail-abort-edit ()
  "$BJT=8$rCfCG$9$k(B."
  (interactive)
  (if (y-or-n-p (cmail-get-resource 'abort-edit-1))
      (progn
	(cmail-abort-edit-0)
	(cmail-message-resource 'abort-edit-2))
    (cmail-message-resource 'abort-edit-3)))
;; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


;; ---- $B%$%s%G%C%/%9$rJT=8$9$k(B ----------------------------------------------
(defun cmail-edit-index (page)
  "PAGE $B5-;v$N%$%s%G%C%/%9$rJT=8$9$k(B."
  (interactive
   (list (cmail-get-page-number-from-summary)))
  (cmail-show-contents page)
  (if (not (y-or-n-p (cmail-get-resource 'edit-index-1)))
      (cmail-message-resource 'edit-index-2)
    (cmail-get-header)
    (if (not (re-search-forward (format "^%d " page) (cmail-head-max) t))
	nil
      (beginning-of-line)
      (let ((idx (read-string (cmail-get-resource 'edit-index-3)
			      (buffer-substring (point)
						(save-excursion
						  (end-of-line)(point))))))
	(if (string= idx "")
	    (cmail-message-resource 'edit-index-4)
	  (cmail-delete-line 1)
	  (insert (format "%s\n" idx))
	  (forward-line -1)
	  (let* ((level (cmail-th-level page))
		 (sumr (cmail-make-summary-line level)))
	    (set-buffer *cmail-summary-buffer)
	    (let ((buffer-read-only nil))
	      (beginning-of-line)
	      (cmail-delete-line 1)
	      (insert sumr)
	      (forward-line -1)
	      (cmail-fixcp)))
	  (if (interactive-p)
	      (cmail-goto-index page))
	  (cmail-message-resource 'edit-index-5))))))
