use Language::INTERCAL;
use Language::INTERCAL::Runtime::Library;

my $prog = '
@z@L`@{J{
@z@L`@{J{
@z@L`@{J{
@@@z
@@@z
@@@z
@K@L`@z@@{
@K@L`@z@@{
@z@L`@K@J@K
@@@z
@K@L`@z@@{
@z@L`@K@J@K
@@@z
@@
';

print "1..42\n";

fiddle Language::INTERCAL 'bug=0', 'ubug=0';

my @foo;

compile Language::INTERCAL 'prog', $prog;
@foo= ();
eval { prog(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 1\n";
print @foo == 5 ? "" : "not ", "ok 2\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 3\n";
print "cxcviDCVIII\n" eq (shift @foo) ? "" : "not ", "ok 4\n";
print "\\i\\v\\C\\C\\X\\C\\I\\VcmlxviiCCXCV\n" eq (shift @foo) ? "" : "not ",
      "ok 5\n";
print "X\n" eq (shift @foo) ? "" : "not ", "ok 6\n";
print "LXXVIII\n" eq (shift @foo) ? "" : "not ", "ok 7\n";

compile Language::INTERCAL 'prog_o', $prog, 'opt';
@foo= ();
eval { prog_o(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 8\n";
print @foo == 5 ? "" : "not ", "ok 9\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 10\n";
print "cxcviDCVIII\n" eq (shift @foo) ? "" : "not ", "ok 11\n";
print "\\i\\v\\C\\C\\X\\C\\I\\VcmlxviiCCXCV\n" eq (shift @foo) ? "" : "not ",
      "ok 12\n";
print "X\n" eq (shift @foo) ? "" : "not ", "ok 13\n";
print "LXXVIII\n" eq (shift @foo) ? "" : "not ", "ok 14\n";

compile Language::INTERCAL 'prog_q', $prog, 'quantum';
@foo= ();
eval { prog_q(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 15\n";
print @foo == 5 ? "" : "not ", "ok 16\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 17\n";
print "cxcviDCVIII\n" eq (shift @foo) ? "" : "not ", "ok 18\n";
print "\\i\\v\\C\\C\\X\\C\\I\\VcmlxviiCCXCV\n" eq (shift @foo) ? "" : "not ",
      "ok 19\n";
print "X\n" eq (shift @foo) ? "" : "not ", "ok 20\n";
print "LXXVIII\n" eq (shift @foo) ? "" : "not ", "ok 21\n";

compile Language::INTERCAL 'prog_p', $prog, 'post';
@foo= ();
eval { prog_p(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 22\n";
print @foo == 5 ? "" : "not ", "ok 23\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 24\n";
print "cxcviDCVIII\n" eq (shift @foo) ? "" : "not ", "ok 25\n";
print "\\i\\v\\C\\C\\X\\C\\I\\VcmlxviiCCXCV\n" eq (shift @foo) ? "" : "not ",
      "ok 26\n";
print "X\n" eq (shift @foo) ? "" : "not ", "ok 27\n";
print "LXXVIII\n" eq (shift @foo) ? "" : "not ", "ok 28\n";

compile Language::INTERCAL 'prog_qp', $prog, 'quantum', 'post';
@foo= ();
eval { prog_qp(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 29\n";
print @foo == 5 ? "" : "not ", "ok 30\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 31\n";
print "cxcviDCVIII\n" eq (shift @foo) ? "" : "not ", "ok 32\n";
print "\\i\\v\\C\\C\\X\\C\\I\\VcmlxviiCCXCV\n" eq (shift @foo) ? "" : "not ",
      "ok 33\n";
print "X\n" eq (shift @foo) ? "" : "not ", "ok 34\n";
print "LXXVIII\n" eq (shift @foo) ? "" : "not ", "ok 35\n";

compile Language::INTERCAL 'prog_d', $prog, 'dbhook';
@foo = ();
_run_db(prog_d(0, \&foo));
print STDERR $@;
print $@ ? "not " : "", "ok 36\n";
print @foo == 5 ? "" : "not ", "ok 37\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 38\n";
print "cxcviDCVIII\n" eq (shift @foo) ? "" : "not ", "ok 39\n";
print "\\i\\v\\C\\C\\X\\C\\I\\VcmlxviiCCXCV\n" eq (shift @foo) ? "" : "not ",
      "ok 40\n";
print "X\n" eq (shift @foo) ? "" : "not ", "ok 41\n";
print "LXXVIII\n" eq (shift @foo) ? "" : "not ", "ok 42\n";

sub foo {
    push @foo, join('', @_);
}

