#!/bin/sh

set -e

VERSION=`cat VERSION`
PKG=cl-odcl
TOPDIR=`basename $PWD`
CVS2CL=`if command -v cvs2cl 2>/dev/null; then	 \
		:					;\
	   elif command -v cvs2cl.pl 2>/dev/null; then	 \
		:					;\
	   else						 \
		echo "true"				;\
		echo "warning: no cvs2cl found" 1>&2	;\
	   fi`


# first we clean everything up
echo "cleaning $PKG up for packaging"
make distclean

TAG=upstream_version_`echo $VERSION | tr . _`

echo "(re)tagging with release tag '$TAG'"
cvs -q rtag -d $TAG $PKG
cvs -q tag -F $TAG

echo "building changelog"
${CVS2CL} -r --global-opts "-q"

# build the documentation
#make -C doc

# build the tarball
echo "building tarball in ../${PKG}_$VERSION.tar.gz"
(   cd ..
    rm -f ${PKG}_$VERSION.tar.gz ${PKG}_$VERSION.orig.tar.gz
    rm -rf $PKG-$VERSION
    ln -s $TOPDIR $PKG-$VERSION
    GZIP=-9 tar czf ${PKG}_$VERSION.tar.gz --exclude='.cvsignore' --exclude='CVS' $PKG-$VERSION/*
    rm -f $PKG-$VERSION
    ln ${PKG}_$VERSION.tar.gz ${PKG}_$VERSION.orig.tar.gz
)

exit 0


