;;; -*- Mode: Lisp -*-
;;; $Id: diagnostics.lisp,v 1.18 2002/03/20 17:13:38 craig Exp $
;;;
;;; Copyright (c) 2001 onShore Development, Inc.

(in-package :odcl)

(defun get-utime ()
  #-cmu
  0
  #+cmu
  (multiple-value-bind (x sec usec)
      (unix:unix-gettimeofday)
    (declare (ignore x))
    (+ (* 1000000 sec) usec)))

(defun print-special-values (package-name &key type)
  (when-bind (target-package (find-package package-name))
    (do-symbols (x target-package)
      (when (and (boundp x)
                 (eq target-package (symbol-package x)))
        (when (or (null type)
                  (typep (symbol-value x) type))
          (format t ";; ~A - ~A~%" (symbol-name x) (symbol-value x)))))))

(defvar *diagnostics* nil)

(defun stat-integer-val (stat)
  (let ((val (or (get-alist stat *diagnostics*) 0)))
    (if (typep val 'integer)
        val
        0)))

(defun note-stat (stat operation)
  (case operation
    (:increment
     (update-alist stat (1+ (stat-integer-val stat)) *diagnostics*))
    (:decrement
     (update-alist stat (1- (stat-integer-val stat)) *diagnostics*))))

(defun list-pkg-bound (package)
  (let ((package (find-package package)))
    (do-symbols (sym package)
      (when (and (eq (symbol-package sym) package)
                 (boundp sym))
        (format t ";; ~s => ~s~%" sym (symbol-value sym))))))

(defun pkg-makunbound (package)
  (let ((package (find-package package)))
    (do-symbols (sym package)
      (when (and (eq (symbol-package sym) package)
                 (boundp sym))
        (makunbound sym)))))

(defun list-instances (type &aux instances)
  #+cmu
  (let ((find-class (find-class type)))
    (vm::map-allocated-objects
     #'(lambda (obj type size)
	 (declare (ignore size) (optimize (speed 3) (safety 0)))
	 (when (eql type vm::instance-header-type)
	   (let* ((instance (vm::%instance-ref obj 0))
                  (class (vm::layout-class instance)))
             (when (eq find-class class)
               (pushnew obj instances)))))
     :dynamic))
  #-cmu (error "list-instances not supported in this lisp implementation")
  instances)

(defvar *console-spam* t)

(defvar *console-spam-types* nil)

(defun cmsg (template &rest args)
  "Format output to console"
  (when *console-spam*
    (setq template (concatenate 'string "~&;; " template "~%"))
    (apply #'format t template args))
  (values))

(defun cmsg-c (condition template &rest args)
  "Push CONDITION keywords into *console-spam-types* to print console spam
   for that CONDITION.  TEMPLATE and ARGS function identically to
   (format t TEMPLATE ARGS) "
  (when (or (member :verbose *console-spam-types*)
            (member condition *console-spam-types*))
    (apply #'cmsg template args)))

(defun cmsg-add (condition)
  (pushnew condition *console-spam-types*))

(defun cmsg-remove (condition)
  (setf *console-spam-types* (remove condition *console-spam-types*)))

(defun fixme (template &rest args)
  "Format output to console"
  (setq template (concatenate 'string "~&;; ** FIXME ** " template "~%"))
  (apply #'format t template args)
  (values))
