#include <dlfcn.h>
#include <stdio.h>

// returns handle to opened plugin
void* load(char* p)
{
  void *h;
  char* (*f)(void);

  printf("Loading %s: ", p);
  h = dlopen(p, RTLD_LAZY);
  f = h ? dlsym(h,"plugin_message") : 0;
  if (f)
    printf(" From %s: %s\n", p, (*f)());
  else
    printf(" Not found.\n");
  return h;
}



int main()
{
  void *h1, *h2;

  h1 = load("plugin1.so");
  h2 = load("plugin2.so");
  
  if (h1) dlclose(h1);
  if (h2) dlclose(h2);

  h2 = load("plugin2.so");
  h1 = load("plugin1.so");
  
  if (h1) dlclose(h1);
  if (h2) dlclose(h2);

  return 1;
}
