#!/bin/sh

distclean=0
CFLAGS="-W -Wall -pedantic -O2"
export CFLAGS

rm bld_iplist.dump
rm bld_blacklist.dump

date > mktest.log
(cd ..
if [ ! -f Makefile ]
then
	distclean=1
	echo Configuring...
	./configure >> mktest/mktest.log 2>&1
fi

for i in Makefile config.h
do
	cp $i mktest
done

echo "=-=" >> mktest/mktest.log
echo Compiling...
make >> mktest/mktest.log 2>&1
echo "=-=" >> mktest/mktest.log
for i in bldquery bldinsert blddecr
do
	ln -sf bldsubmit $i
done
echo Running...
./bld -l 0 -a 127.0.0.1 -p 2906 -P mktest/bld.pid -B `pwd`/mktest/bld_blacklist.dump -I `pwd`/mktest/bld_iplist.dump -t 1 -m 3 >> mktest/mktest.log 2>&1
echo Testing...
sleep 1
./bldsubmit 127.0.0.1 2906 192.168.75.1 >> mktest/mktest.log 2>&1
./bldquery 127.0.0.1 2906 192.168.75.1 >> mktest/mktest.log 2>&1
./bldsubmit 127.0.0.1 2906 192.168.75.1 >> mktest/mktest.log 2>&1
sleep 1
./bldsubmit 127.0.0.1 2906 192.168.75.1 >> mktest/mktest.log 2>&1
./bldquery 127.0.0.1 2906 192.168.75.1 >> mktest/mktest.log 2>&1
./bldinsert 127.0.0.1 2906 192.168.75.2 >> mktest/mktest.log 2>&1
./bldquery 127.0.0.1 2906 192.168.75.2 >> mktest/mktest.log 2>&1
echo Killing...
kill `cat mktest/bld.pid`
rm -f mktest/bld.pid
sleep 1
./bldread mktest/bld_iplist.dump > mktest/bld_iplist.txt 2>&1
./bldread mktest/bld_blacklist.dump > mktest/bld_blacklist.txt 2>&1
echo "=-=" >> mktest/mktest.log

if [ $distclean -eq 1 ]
then
	make distclean >> mktest/mktest.log 2>&1
	echo "=-=" >> mktest/mktest.log
fi
date >> mktest/mktest.log
)

echo Tests are over, thank you!  You can send the content of this directory to:
echo "    <obld@r14.freenix.org>"
