/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxcoo
 * Create date:	2004-03-06 16:03
 */

#ifndef _BLIST_H_
#define _BLIST_H_

#include <vector>
#include <string>
#include "bobject.h"


class CBList:public CBObject
{
public:
	CBList(void)
		:CBObject(3)
		{};
	~CBList(void)
	{
		clear();
	}

	typedef std::vector<CBObject*> CONTAINER;

private:
	CONTAINER m_value;
	void clear(void)
	{
		while(!m_value.empty())
		{
			CBObject* obj=m_value.back();
			m_value.pop_back();
			delete obj;
		}
	}
public:
	unsigned int getCount(void)
	{
		return m_value.size();
	};

	CBObject* getValue(unsigned int index)
	{
		if(m_value.size()>index)
		{
			return m_value[index];
		}
		else
		{
			return NULL;
		}
	};

	int parse(const char* buf,unsigned long bufLen);
	
	void get_bestr(std::string& str)
	{
		str+="l";
		for(size_t i=0;i<m_value.size();++i)
		{
			m_value[i]->get_bestr(str);
		}
		str+="e";
	};
};

#endif
