/* $Id: ArkSkeleton.h,v 1.21 2003/03/20 17:23:25 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ARK_SKELETON_H
#define ARK_SKELETON_H

#include <Ark/ArkMath.h>
#include <Ark/ArkSequence.h>
#include <Ark/ArkLexer.h>

#include <map>
#include <vector>

namespace Ark
{

   struct ARK_DLL_API HitBox : public BBox
   {
	 /// Index of the bone corresponding to this Hitbox.
	 int m_Bone;
   };

   /**
    * A bone in a skeleton. This is used to provide animation to organic
    * models (such as humans).
    */
   class ARK_DLL_API Bone
   {
      public:
	 /// Bone name for symbolic links.
	 String m_Name;

	 /// Index of the parent bone in the model.
	 int m_Parent;
	 
	 /// Bone controller indices for X Y Z and RX, RY, RZ channels
	 /// (-1 means that's there's no controller)
	 int m_BoneControllers[6];
	 
	 /// Default position value.
	 Vector3 m_DefPosition;
	 
	 /// Default rotation value.
	 Vector3 m_DefRotation;
   };

   struct ARK_DLL_API BoneController
   {
	 /// Index of the bone in the model.
	 int m_Bone;
	 
	 /// Channel this controller is bound to.
	 /// (X, Y, Z, RX, RY, RZ).
	 int m_Channel;
	 
	 /// Maximum / minimum values for this controller.
	 scalar m_Start, m_End;
	 
	 /// Index of this controller.
	 int m_Index;
	 
      public:
	 /**
	  * Given a bone controller and an adjustment value for this bone
	  * (ie an angle if this bone has a rotation channel), this function
	  * tries to correct the value.
	  */
	 void ComputeSetting(scalar value, scalar *result);
   };

   class ModelState;
   typedef std::map<String, String> SequenceList;

   /// FIXME: documentation
   class ARK_DLL_API Skeleton : public Object
   {
      public:
         /// Create a skeleton with the given name.
	 Skeleton (const String &name);
	 
	 /// Destroy the skeleton.
	 ~Skeleton ();

	 void Animate (ModelState &state, 
		       scalar delta_time);

	 void SetupBones (const ModelState &state,
			  Matrix44 *matrices,
			  Matrix44 *rootmatrix = NULL,
			  scalar scalefactor = 1.0);

	 void Write (WriteStream &stream);
	 void Read (Lexer &lexer);
	 
	 SequencePtr GetSequence (const String &name);
	 BBox GetBBox (const SequencePtr& seq, scalar scalefactor = 1.0) const;

	 /// Needed for loaders.
         void ComputeBoneOrder();
	 void ApplyReorder();

      public:
	 std::vector<Bone> m_Bones;
	 std::vector<BoneController> m_Controllers;
	 std::vector<HitBox> m_HitBoxes;
	 Matrix44 m_RootMatrix;
	 SequenceList m_Sequences;

      private:
	 friend class Sequence;
	 friend class Model;

	 Cache *m_Cache;
	 String m_SeqList; // File name
	 std::vector<size_t> m_BoneOrder;
	 bool PostLoad (Cache* cache);

	 int OrderChildren(int cur, int bone);
   };

   typedef Ptr<Skeleton> SkeletonPtr;
}


#endif
