/* $Id: ArkPtr.h,v 1.6 2003/03/18 18:23:53 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2003 The Contributors of the ArkRPG Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ARK_PTR_H
#define ARK_PTR_H

namespace Ark
{
   template <class T>
   class Ptr 
   {
      public:
	 inline Ptr () : m_T(0) {}
	 inline explicit Ptr (T *t) : m_T(t) {if (m_T) m_T->Ref();}
	 inline explicit Ptr (T *t, int noref) : m_T(t) {}

	 inline ~Ptr() {if (m_T) m_T->Unref();}

	 // Copy
	 inline Ptr (Ptr<T> const &ptr) : m_T(ptr.m_T) {if (m_T) m_T->Ref();}
	 inline Ptr<T> &operator = (Ptr<T> const &ptr)
	 {
	    if (ptr.m_T) ptr.m_T->Ref();
	    if (m_T) m_T->Unref();
	    m_T = ptr.m_T;
	    return *this;
	 }
	 
	 inline operator bool() const { return m_T != 0; }
	 inline bool operator == (const Ptr<T> &t) const 
	    {return t.m_T == m_T;}

	 inline bool operator != (const Ptr<T> &t) const 
	    {return t.m_T != m_T;}

	 // Accessors..
	 
	 // Function call 
	 inline const T *operator ->() const {return m_T;}
	 inline T *operator ->() {return m_T;}

	 // Dereference
	 inline const T& operator*() const {return *m_T;}
	 inline T& operator*() {return *m_T;}
	 
	 // nosy ones
	 inline T *Get() {return m_T;}
	 inline const T *Get() const {return m_T;}

      private:
	 T *m_T;
   };

}

#endif // ARK_PTR_H

