// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: acqprogress.h,v 1.1.2.1 2002/02/23 14:50:07 daniel Exp $
/* ######################################################################

   Acquire Progress - Command line progress meter 
   
   ##################################################################### */
									/*}}}*/
#ifndef ACQPROGRESS_H
#define ACQPROGRESS_H

#include <apt-pkg/acquire.h>
#include <sigc++/object.h>

class download_manager;

class AcqTextStatus : public SigC::Object
{
   unsigned int &ScreenWidth;
   char BlankLine[300];
   unsigned long ID;
   unsigned long Quiet;
   
  // We have to mirror the download_manager's information (ewww)
  // Another option is to store a reference to the download-manager,
  // but I don't like that for other reasons. (sigh..)
  //
  // A note: these values are only updated when Pulse() is called anyway.
  unsigned long TotalItems, CurrentItems;
  double CurrentCPS, TotalBytes, CurrentBytes;

   public:
   
   virtual bool MediaChange(std::string Media,std::string Drive, download_manager &manager);
   virtual void IMSHit(pkgAcquire::ItemDesc &Itm, download_manager &manager);
   virtual void Fetch(pkgAcquire::ItemDesc &Itm, download_manager &manager);
   virtual void Done(pkgAcquire::ItemDesc &Itm, download_manager &manager);
   virtual void Fail(pkgAcquire::ItemDesc &Itm, download_manager &manager);
   virtual void Start(download_manager &manager);
   virtual void Stop(download_manager &manager);
   
   bool Pulse(pkgAcquire *Owner, download_manager &manager);

   AcqTextStatus(unsigned int &ScreenWidth,unsigned int Quiet);
};

#endif
