/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: STRBOOL.C $
   $Locker: ska $	$Name:  $	$State: Exp $

ob(ject): strbool
su(bsystem): cmdline
ty(pe): 
sh(ort description): Identify a boolean option string
lo(ng description): Identifies the non-numerical string of a boolean
	option
pr(erequistes): s != NULL
va(lue): 
 \item		0: false/off
 \item		1: true/on
 \item		2: toggle/switch
 \item		-1: more than one word found or no word at all
 \item		-2: neither of the above
re(lated to): 
se(condary subsystems): 
bu(gs): 
co(mpilers): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <assert.h>
#include <limits.h>
#include <portable.h>
#include "dynstr.h"
#include "str.h"
#include "msgs.loc"
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: STRBOOL.C 1.4 2001/02/27 01:29:26 ska Exp ska $";
#endif

int strbool(char *s)
{	char *p;

	DBG_ENTER("strbool", Suppl_cmdline)

	assert(s);

	DBG_ARGUMENTS( ("str=\"%s\"", s) )

	if((p = singleword(s)) == 0)
		DBG_RETURN_I( -1)		/* more than one word cannot be here */

	if(lookupwordi(p, cfgNamesOff))
		DBG_RETURN_I( 0)

	if(lookupwordi(p, cfgNamesOn))
		DBG_RETURN_I( 1)

	if(lookupwordi(p, cfgNamesToggle))
		DBG_RETURN_I( 2)

	DBG_RETURN_I( -2)		/* failed */
}
