/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_GSF.C $
   $Locker: ska $	$Name:  $	$State: Exp $

ob(ject): cfg_getStream
su(bsystem): cmdline
ty(pe): L
sy(nopsis): 
sh(ort description): Read the next option from a streaming input
he(ader files): 
lo(ng description): Called by cfgGetopt() to aquire the next argument from
	input objects that return their content as a stream (meaning
	character-by-character). The function reads that many characters from
	the input stream as are necessary to fetch the next argument/option
	completely. It will open response files, pop an input context at end
	of stream etc.
pr(erequistes): 
va(lue): 0: no further option or non-ignored non-option argument found
	\item CFG_CHR_RESCAN: if the internal state is unstable and the
	function must be called again
	\item else: the found option as shortname
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_gsf.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <ctype.h>
#include <assert.h>
#include <portable.h>
#include "dynstr.h"
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_GSF.C 1.4 2001/02/27 01:28:02 ska Exp ska $";
#endif

int cfg_getStream(struct Cfg_Getopt *optstru)
{	int ch, quote, len, ignoreOptSigns, isarg;
	char *p, *q;
	struct Cfg_LongOptions *lOpt;

	DBG_ENTER("cfg_getStream", Suppl_cmdline)

	assert(optstru);

rescan:
	chkHeap
	if((p = S(poi)) != 0)		 /* fetch next shortname option */
		if(S(newopt)) {				/* a new option --> try if long name opt */
			S(newopt) = 0;
			goto longname;
		}
		else goto shortname;

	quote = 0;
	ignoreOptSigns = len = 1;
	isarg = C(_optstop);	/* treat all following arguments as non-options */

	/* skip argument delimiter(s) */
	while((ch = cfg_getc(optstru)) != EOF && isspace(ch));

	if(ch != EOF) do {
redo:
		chkHeap
		if(isSingleQuote(ch)) {
			if((ch = cfg_getc(optstru)) == EOF)
				break;
			/* else append the next character */
		}
		else if(quote) {			/* always add the character */
			if(ch == '\n')			/* end of line --> stop here */
				break;				/* assume the ending quote */
			if(quote == ch) {		/* end of quoted string? */
				if((ch = cfg_getc(optstru)) != EOF
				 && !isarg			/* options still allowed */
				 && isOpt_io(ch)) {
					/* special case: quote ended immediately
						followed by optchar --> next is definitely
						an option
						Buffer the normal option char */
					quote = 0;
					S(bufch) = optSign;
					break;
				}
				if(ch != quote) {	/* end-of-quote character found */
					quote = 0;
					if(ch != EOF)
						goto redo;	/* don't add quote */
					break;		/* end of file */
				}
				/* double quote character --> quoted quote */
				/* fall through to add one quote character */
			}
		}
		else {				/* not quoted */
			if(isQuote(ch)) {	/* is a quote */
				quote = ch;
				continue;	/* don't add quote */
			}
			else if(isspace(ch))	/* argument delimiter */
				break;
			else if(!ignoreOptSigns && isOpt_ia(ch)) {
				/* in-argument option delimiter */
				/* regardless what kind of argument, here a new option
					begins */
				S(bufch) = optSign;	/* next get will fake a normal optch */
				break;
			}
		}
		chkHeap
		Eresize(S(buf), ++len);
		S(buf)[len - 2] = ch;
			/* Fetch all leading opt signs as this is normally an ill-formed
				option syntax, but ignore the optch, if no further
				option is allowed */
		if(ignoreOptSigns && !isarg && !isOpt_ia(ch))
			ignoreOptSigns = 0;
		chkHeap
	} while((ch = cfg_getc(optstru)) != EOF);

	if(len == 1) {		/* nothing scanned */
		chkHeap
		if(ch == EOF) {	
			if(cfg_pop(optstru)) /* end of file reached --> pop former state */
				/* Because this properly conflicts with the new
					getTokenFct(), this function must be terminated */
				DBG_RETURN_I( CFG_CHR_RESCAN)

			/* no former state --> everything scanned */
			DBG_RETURN_I( 0)
		}
		Esetsize(S(buf), 1);		/* zero-length argument argument */
	}

	/* something scanned --> decode it */
	S(buf)[len - 1] = '\0';
	chkHeap

	if(!isarg && (isspace(S(bufch)) || !S(bufch))) {
	/* check for no-more-option */
		/* these special tokens must appear alone on command lone */
		ch = *S(buf);
		if(len == 2 && isStdinSgn(ch))		/* usually "-" */
			isarg = 1;
		else if(len == 3 && ch == S(buf)[1] && isStopSgn(ch))
			/* no more options */	/* usually "--" */
			isarg = C(_optstop) = 1;
	}
	
	if(isarg || !isOpt(*(p = S(buf)))) {		/* is non-option */
		if(isRspnFile(*S(buf))) {				/* response file? */
			cfg_rspfile(optstru, S(buf) + 1);	/* open response file */
			goto rescan;
		}
		/* a non-option argument found --> what to do now? */
		if(C(_foundArg) && (C(_foundArg))(optstru) == 0)
			/* shall ignore/skip this argument */
			goto rescan;

		/* This argument is not an option and is not to be ignored */
		/* this argument must be retreived before getopt() may proceed */
		C(type) = CFG_ARG;
		DBG_RETURN_I( 0)
	}
	/* is an option */
newopt:
	++p;			/* skip the option sign */

longname:
	chkHeap
/* fetch new option */
	/* probe for longname option */
	C(_glbBool) = 0;
	if(isBoolean(ch = *p)) {		/* first character is boolean switch */
		C(_glbBool) = ch;
		if(!*++p) 					/* only boolean sign found */
			/* return as shortname option */
			/* _poi is still NULL --> end of string is saved */
			DBG_RETURN_BI( C(ch) = ch)
	}

	C(bool) = C(_glbBool);		/* if we find a longname opt --> thats the 
									default boolean sign */

	q = p - 1;
	while(*++q)
		if(isOpt_io(*q)) {		/* next option */
			S(poi) = q + 1;
			break;
		}
		else if(isArgSign(*q)) {	/* argument */
			C(arg) = q + 1;
			C(argtype) = CFG_TNONE;
			break;
		}

	chkHeap
	if(isBoolean(q[-1]))		/* ends in boolean sign */
		C(bool) = *--q;

	ch = *q;		/* end the name for the compare */
	*q = NUL;

	if((lOpt = cfg_isLongnameOption(C(long), p)) != 0) {
		/* longname option found */
		C(longname) = p;
		DBG_RETURN_BI( C(ch) = lOpt->shortname)
	}

	*q = ch;						/* restore the original option string */
	C(arg) = 0;
	C(argtype) = CFG_TERROR;

	/* no longname option --> return individual shortname options */
shortname:
	chkHeap
	if(isOpt_io(C(ch) = *p))		/* found start of next option */
		goto newopt;

	S(poi) = 0;
	if(isBoolean(ch = *++p)) {	/* local boolean sign */
		C(bool) = ch;
		ch = *++p;
	}
	if(ch)
		if(isArgSign(ch)) {		/* the rest is the argument of opt */
			C(arg) = p + 1;
			C(argtype) = CFG_TNONE;
		}
		else S(poi) = p;

	DBG_RETURN_I( C(ch))
}
