/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_ACTX.C $
   $Locker: ska $	$Name:  $	$State: Exp $

ob(ject): cfg_addContext
su(bsystem): cmdline
ty(pe): L
sy(nopsis): 
sh(ort description): Initialize a new input stack item
he(ader files): 
lo(ng description): Push a new input stack item and initialize the
	getarg, getchar and close functions.
pr(erequistes): 
va(lue): none
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_actx.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <portable.h>
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_ACTX.C 1.5 1999/12/13 02:21:56 ska Exp ska $";
#endif

void cfg_addContext(struct Cfg_Getopt * const optstru
 , void * const arg, Cfg_rdOptFct get, Cfg_clOptFct close)
{	DBG_ENTER("cfg_addContext", Suppl_cmdline)

	cfg_push(optstru);
	S(getArg) = arg;
	S(getFct) = get;
	S(closeFct) = close;

	DBG_EXIT
}
