// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _TransferLogo_h_
#define _TransferLogo_h_

#include <qpixmap.h>
#include <qlabel.h>

class QPixmap;

//: The TransferLogo class provides an animated sequence of pixmaps that can be turned on and off.
class TransferLogo : public QLabel {
    QPixmap   _logo;
    QPixmap** _pixmaps;
    int       _index;
protected:
    void timerEvent( QTimerEvent* e );
public:
    TransferLogo( QWidget* parent=0, const char* name=0 );
    ~TransferLogo();

    //. Turn the animated logo on or off.  If b is TRUE then the animated logo
    //. shown.  If b is FALSE then the animation is stopped, and the QWeb! logo
    //. is displayed.
    void setTransfer( bool b );
};

#endif
