#ifndef _StyleSheetProto_h_
#define _StyleSheetProto_h_

#include "StyleAttrProto.h"

class StyleSheetProto {
public:
    struct DisplayProto {
        QString               name;
        QString               token;
        int                   display;
        QList<StyleAttrProto> attrProtos;
        DisplayProto( const QString& _name, const QString& _token, int _display ) : name( _name ), token( _token ), display( _display ) {}
    };
private:
    QList<StyleAttrProto> _attrProtos;
    QList<DisplayProto>   _displayProtos;
public:
    StyleSheetProto();

    ~StyleSheetProto();

    StyleAttrProto* findProto( const QString& name );
    
    DisplayProto*   findDisplay( const QString& name );
    
    const QList<DisplayProto>& displayProtos() { return _displayProtos; }
};

extern StyleSheetProto* styleSheetProto;

#endif
