#ifndef _StyleAttrProto_h_
#define _StyleAttrProto_h_

#include <qlist.h>
#include <qstring.h>

class StyleAttrProto {
public:
    enum Type {
        String,
        Number,
        Enumerated,
        List,
        Flag
    };
    struct EnumMap {
        QString name;
        QString token;
        int     value;
        EnumMap( const char* _name, const char* _token, int _value )
                : name( _name ), token( _token ), value( _value ) {}
    };
private:
    QString        _name;
    QString        _token;
    Type           _type;
    bool           _inherit;
    QList<EnumMap> _enumMap;
public:
    StyleAttrProto( const char* name, const char* token, Type type, bool inherit )
            : _name( name ), _token( token ), _type( type ), _inherit( inherit ) {}
    ~StyleAttrProto();
    
    const QString&  name()          { return _name; }
    const QString&  token() const   { return _token; }
    int             type()          { return _type; }
    bool            inherit() const { return _inherit; }
    QList<EnumMap>& enumMap()       { return _enumMap; }
    int             tokenToValue( const QString& name ) const;
    const QString*  valueToToken( int value ) const;
};

#endif
