#ifndef _StyleAttr_h_
#define _StyleAttr_h_

#include <qstring.h>

class StyleAttrProto;

class StyleAttr {
    StyleAttrProto* _proto;
public:
    StyleAttr( StyleAttrProto* proto );
    StyleAttr( const StyleAttr& src );
    virtual ~StyleAttr();
    
    const QString&        name();
    int                   type();
    const StyleAttrProto* proto();
};

class StringStyleAttr : public StyleAttr {
    QString _value;
public:
    StringStyleAttr( StyleAttrProto* proto, const QString& value );
    StringStyleAttr( const StringStyleAttr& src );

    const QString& value();
};

class NumberStyleAttr : public StyleAttr {
    int  _value;
    bool _isPercent;
public:
    NumberStyleAttr( StyleAttrProto* proto, int value, bool isPercent );
    NumberStyleAttr( const NumberStyleAttr& src );

    int  value();
    bool isPercent();
};

class EnumeratedStyleAttr : public StyleAttr {
    int _value;
public:
    EnumeratedStyleAttr( StyleAttrProto* proto, int value );
    EnumeratedStyleAttr( const EnumeratedStyleAttr& src );

    int value();
};

class ListStyleAttr : public StyleAttr {
    QString _value;
public:
    ListStyleAttr( StyleAttrProto* proto, const QString& value );
    ListStyleAttr( const ListStyleAttr& src );

    const QString& value();
};

#endif
