// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _Style_h_
#define _Style_h_

#include <qstring.h>
#include "StyleAttr.h"
#include "StyleSheetProto.h"

class STag;

//: This class stores the style description for an SGML element.
//. An SGML element can contain other SGML elements and/or content.  In order
//. to present the content to a user it must be rendered.  This class specifies
//. a mapping from an SGML element's content and attributes to an on-screen
//. representation.
//. <P>
//. Each instance of the Style class is associated with a single "element".
//. However, an "element" may be a simple element name (i.e. "H1" ) or an
//. element path (i.e. "/HTML/BODY/H1" ).  The list of styles for a document
//. type is stored in a StyleSheet.
class Style {
public:
    enum {
        Inherit=0,
        Anchor,
        Base,
        Block,
        Bold,
        Bullet,
        Center,
        Form,
        FormButton,
        FormCheckBox,
        FormEntry,
        FormHidden,
        FormImage,
        FormListBox,
        FormMLE,
        FormOption,
        FormOptionMenu,
        FormRadio,
        HLine,
        Hyperlink,
        Image,
        Inline,
        Italic,
        Left,
        None,
        Normal,
        Number,
        Pre,
        Right,
        Table,
        TableData,
        TableRow,
        Title,
        Underline
    };

    struct Attr {
        QString name;
        QString value;
        Attr( const QString& _name, const QString& _value ) : name( _name.copy() ), value( _value.copy() ) {}
    };
    
private:
    friend class StyleEditor;
    friend class StyleParser;
    friend class StyleSheet;

    QString                        _name;
    QList<Attr>                    _sgmlAttrs;
    StyleSheetProto::DisplayProto* _display;
    QList<StyleAttr>               _attrs;

    void print();
public:
    //. Construct a default style for the named element.
    Style( const QString& name );

    Style( const Style& src );

    ~Style();

    //. Returns an integer value that tells how good a match this style is to
    //. the given start tag.  If the tag name does not match the name of this
    //. style, or one of the attribute requirements is not met by this tag
    //. then 0 is returned.  Otherwise, one plus the number of attributes for
    //. this style are returned.  The best match should be the first match
    //. with the highest matchFactor().
    int matchFactor( const STag* tag );

    bool enumValue( const char* token, int& value );

    bool listValue( const char* token, QString& value );

    bool numberValue( const char* token, int& value );

    bool stringValue( const char* token, QString& value );

    bool flagValue( const char* token );

    const StyleAttr* find( const char* token );

    int displayType();

    void setDisplay( StyleSheetProto::DisplayProto* display );

    QString selectorString();
};

#endif
