// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _PrefsWindow_h_
#define _PrefsWindow_h_

#include <qtabdlg.h>
#include <qwidget.h>

class QCheckBox;
class QLabel;
class QLineEdit;

//: The GeneralPage class is a single page in the PrefsWindow notebook.
class GeneralPage : public QWidget {
    Q_OBJECT
    int        _labelWidth;
    QLabel*    _homeUrlLabel;
    QLineEdit* _homeUrlEntry;
    QCheckBox* _homeAutoLoadCheck;
    QLabel*    _bookmarksLabel;
    QLineEdit* _bookmarksEntry;
    QLabel*    _catalogUrlLabel;
    QLineEdit* _catalogUrlEntry;
protected:
    //. Reposition my widgets.
    void resizeEvent( QResizeEvent* e );
public:
    //. Create the general page.
    GeneralPage( QWidget* parent=0, const char* name=0 );

    //. Commit the settings on the page to the options object.
    void apply();

    //. Make the page reflect the general settings in the options object.
    void update();
};

//: The PrefsWindow class provides a modal dialog for editting user preferences.
class PrefsWindow : public QTabDialog {
    Q_OBJECT
    GeneralPage* _general;
public:
    //. Create the PrefsWindow.
    PrefsWindow( QWidget* parent=0, const char* name=0 );
public slots:
    //. Commit the settings on each page to the options object.
    void apply();

    //. Make each page in the notebook reflect the settings in the options
    //. object.
    void update();
};

extern PrefsWindow* prefsWindow;

#endif
