// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
extern "C" {
#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <strings.h>

#ifndef __linux
// Solaris ... sheesh!
void bzero(void *s, size_t n);
#endif
}
#include "Poller.h"
#include "Connection.h"

extern int errno;

Poller::Poller()
{
    _fdList.setAutoDelete( TRUE );
    startTimer( 100 );
}

void Poller::reg( Connection* conn, int fd )
{
    for ( Pair* p = _fdList.first(); p; p = _fdList.next() ) {
        if ( ( p->conn == conn ) && ( p->fd == fd ) ) {
            return;
        }
    }
	
    _fdList.append( new Pair( conn, fd ) );
}

void Poller::dereg( Connection* conn, int fd )
{
    for ( Pair* p = _fdList.first(); p; p = _fdList.next() ) {
        if ( ( p->conn == conn ) && ( p->fd == fd ) ) {
            _fdList.remove();
            return;
        }
    }
}

void Poller::timerEvent( QTimerEvent* )
{
    fd_set rSet, wSet, eSet;
    int    max = -1;
    int    count;
    Pair*  p;
	
    FD_ZERO( &rSet );
    FD_ZERO( &wSet );
    FD_ZERO( &eSet );
    for ( p = _fdList.first(); p; p = _fdList.next() ) {
        if ( p->fd > max ) max = p->fd;
        FD_SET( p->fd, &rSet );
        FD_SET( p->fd, &wSet );
        FD_SET( p->fd, &eSet );
    }
	
    struct timeval tv;
    bzero( (void*)&tv, sizeof( tv ) );
	
    if ( ( count = select( max + 1, &rSet, &wSet, &eSet, &tv ) ) < 0 ) {
        printf( "Poller::timerEvent() -- select() failed, errno = %d\n", errno );
    } else if ( count > 0 ) {
        for ( p = _fdList.first(); p; p = _fdList.next() ) {
            if ( FD_ISSET( p->fd, &rSet ) ) {
                p->conn->readable();
            }
        }
        for ( p = _fdList.first(); p; p = _fdList.next() ) {
            if ( FD_ISSET( p->fd, &wSet ) ) {
                p->conn->writable();
            }
        }
        for ( p = _fdList.first(); p; p = _fdList.next() ) {
            if ( FD_ISSET( p->fd, &eSet ) ) {
                p->conn->exception();
            }
        }
    }
}
