// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _ImageDecoder_h_
#define _ImageDecoder_h_

#include <qbitmap.h>
#include <qobject.h>
#include <qpixmap.h>

class Renderer;

//: The ImageDecoder class is the abstract base class of all image decoders.
class ImageDecoder : public QObject {
    Q_OBJECT
protected:
    QPixmap   _pixmap;
    QBitmap   _mask;
    Renderer* _renderer;
public:
    ImageDecoder( Renderer* renderer );

    virtual ~ImageDecoder();

    const QPixmap& pixmap() { return _pixmap; }
public slots:
    //. Process incoming image data.  For progressive renderering, don't
    //. forget to tell the renderer that it needs to redraw.
    virtual void data( const char* bytes, int length ) = 0;

    virtual void endOfData() = 0;
};

#endif
