// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _FormRenderer_h_
#define _FormRenderer_h_

#include <qbttngrp.h>
#include <qlist.h>
#include <qstrlist.h>
#include "FormObjectRenderer.h"
#include "VerticalRenderer.h"

class QRadioButton;

//: The FormRenderer class manages a group of form input fields.
//. A form manages a list of form objects.  When the form is asked to submit
//. the form values, it queries each of the form objects for their
//. contribution.  A query is constructed by concatenating the values, and
//. the resulting URL is requested.
class FormRenderer : public VerticalRenderer {
    Q_OBJECT
    QList<FormObjectRenderer> _formObjects;
    QStrList                  _hiddenNames;
    QStrList                  _hiddenValues;
    QString                   _action;
    QString                   _method;
    QList<QButtonGroup>       _buttonGroups;
public:
    FormRenderer( Canvas*     canvas,
                  SgmlParser* parser,
                  int         clipWidth=0,
                  QObject*    parent=0,
                  const char* name=0 );
    ~FormRenderer();

    //. Add a form object to the list of managed objects.
    void registerFormObject( FormObjectRenderer* formObject );

    //. Radio buttons with the same name are placed into the same button group
    //. to insure that they are mutually exclusive.
    void registerRadioButton( QRadioButton* radio );

    //. Create a query by concatenating the values of all of my form objects.
    //. Make a request for the resulting URL.
    void submit( FormObjectRenderer* formObject );

    void reset();

    //. Add a hidden object to the form.  Hidden objects are simply name/value
    //. pairs that are submitted, but cannot be modified by the user.
    void addHidden( const char* name, const char* value );
public slots:
    //. Watch for the action and method attributes.
    virtual void startTag();
};

#endif
