// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _ContentModelState_h_
#define _ContentModelState_h_

#include <qlist.h>
#include <qstrlist.h>
#include <qdict.h>
#include "SgmlNode.h"

//: The ContentModelState class stores a single state in the content model for an SGML element.
class ContentModelState {
public:
    struct Transition {
	QString            element;
	ContentModelState* state;
	Transition( const QString& _element, ContentModelState* _state ) : element( _element.copy() ), state( _state ) {}
    };
private:
    bool              _marked;
    bool              _accept;
    QList<SgmlNode>   _id;
    QList<Transition> _transitions;
    QStrIList         _transElements;
public:
    //. Create a new state in the content model.
    ContentModelState() : _marked( FALSE ), _accept( FALSE ) {}

    ~ContentModelState();

    //. Is this an accepting state for the content model?
    bool accept() const { return _accept; }

    //. Has this state been visited?
    bool marked() const { return _marked; }

    //. Mark this content state as having been visited.  This is only used
    //. when creating the state table for the content model.
    void mark() { _marked = TRUE; }

    //. Return my ID, which is a list of SgmlNodes.
    QList<SgmlNode>& id() { return _id; }

    //. Add the given element to the list of elements that uniquely identifies
    //. this state in the content model.
    void addId( SgmlNode* element );

    //. Add a transition from this state to the given state for the given
    //. transition element.
    void addTransition( const QString& element, ContentModelState* state );

    //. Return the next state in the content model (if any) for the given
    //. transition element.
    ContentModelState* nextState( QString element );

    //. Return TRUE if there is a default transition out of this state on
    //. the given element.
    bool defaultTrans( QString& element );
};

#endif
