// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include <qpushbt.h>
#include "ButtonRenderer.h"
#include "Canvas.h"
#include "FormRenderer.h"

ButtonRenderer::ButtonRenderer( bool           isReset,
                                const QString* value,
                                Canvas*        canvas,
                                int            clipWidth,
                                QObject*       parent,
                                const char*    name )
        : FormObjectRenderer( canvas, clipWidth, parent, name )
{
    if ( value ) {
        _button = new QPushButton( *value, canvas->clip() );
    } else {
        if ( isReset ) {
            _button = new QPushButton( "Reset", canvas->clip() );
        } else {
            _button = new QPushButton( "Submit", canvas->clip() );
        }
    }
    canvas->registerWidget( this, _button );
    
    _button->resize( _button->sizeHint().width(), 24 );
    _minimumWidth = _button->sizeHint().width() + 8;
    _maximumWidth = _button->sizeHint().width() + 8;

    resize( _button->sizeHint().width() + 8, 32 );

    if ( isReset ) {
        connect( _button, SIGNAL( clicked() ), this, SLOT( doReset() ) );
    } else {
        connect( _button, SIGNAL( clicked() ), this, SLOT( submit() ) );
    }
}

QString ButtonRenderer::value()
{
    QString nm  = name();
    QString val = _button->text();

    if ( ( nm.length() == 0 ) || ( val.length() == 0 ) ) {
        return "";
    }

    Url::encode( nm );
    Url::encode( val );

    QString tmp;
    tmp.sprintf( "%s=%s", nm.data(), val.data() );
    return tmp;
}

void ButtonRenderer::reset()
{
}

bool ButtonRenderer::redraw()
{
    return FALSE;
}

void ButtonRenderer::endOfData()
{
}

void ButtonRenderer::submit()
{
    FormRenderer* f;
    if ( ( f = form() ) ) {
        f->submit( this );
    }
}

void ButtonRenderer::doReset()
{
    FormRenderer* f;
    if ( ( f = form() ) ) {
        f->reset();
    }
}
