// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "Browser.h"
#include "BrowserList.h"

BrowserList::~BrowserList()
{
}

void BrowserList::browserClosed()
{
    _browsers.remove( sender() );
    emit canClose( _browsers.count() > 1 );

    if ( _browsers.count() == 0 ) {
        exit( 0 );
    }
}

void BrowserList::browserOpened( Browser* browser )
{
    connect( browser, SIGNAL( destroyed() )     , this   , SLOT( browserClosed() ) );
    connect( this   , SIGNAL( canClose( bool ) ), browser, SLOT( canClose( bool ) ) );
    _browsers.append( browser );
    emit canClose( _browsers.count() > 1 );
}
