// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _BlockRenderer_h_
#define _BlockRenderer_h_

#include "TextRenderer.h"

//: The BlockRenderer class displays content by word wrapping and compressing white-space.
//. As content comes in, it is broken up into discrete words that may or may
//. not have leading and trailing white-space.  When redraw()ing walk the list
//. of words, and break them into lines, wrapping when necessary.
class BlockRenderer : public TextRenderer {
    Q_OBJECT
    int _alignment;
public:
    //. Create a BlockRenderer.
    BlockRenderer( Canvas*     canvas,
                   SgmlParser* parser,
                   int         clipWidth=0,
                   QObject*    parent=0,
                   const char* name=0 );

    //. Reposition each of the Inline elements.  Words are automatically wrapped
    //. to the next line, and inlined images are treated the same as words.
    virtual bool redraw();
public slots:
    //. Break the text stream up into individual words, and compress white-space.
    //. Record whether each word has space before or after it, to preserving word
    //. breaks when redraw()ing.
    virtual void content( QString text );
};

#endif
