#ifndef lint
static char SccsMId[] = "%W%  %G%";
#endif

/* Module:	motf.h
 * Purpose:	Define the TAE-like button border patterns
 * Defines:	motfBorders
 * Xlib calls:	none
 * Note:	Set by MakeButtonBox()
 * Note:	Used by btn_MakeBdrBitmap() in border.c to put border pattern
 *		on buttons.  Included by create.c where assignments are made.
 * Copyright:	1989, 1990 Smithsonian Astrophysical Observatory
 *		You may do anything you like with this file except remove
 *		this copyright.  The Smithsonian Astrophysical Observatory
 *		makes no representations about the suitability of this
 *		software for any purpose.  It is provided "as is" without
 *		express or implied warranty.
 * Modified:	{0} Michael VanHilst	initial version		21 March 1989
 *		{1} MVH map expanded to 4x32 covering 4 corners	26 March 1990
 *		{n} <who> -- <does what> -- <when>
 */

/*
 * Data:	off_out_button_bits
 * Purpose:	32x32 bit border pattern
 *		for button in off state, not occupied by pointer
 * Note:	compatable with X11 bitmap tool
 */
#define off_out_m_width 32
#define off_out_m_height 32
static unsigned char off_out_m_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0x7f, 0x02, 0x00, 0x00, 0x60,
   0x02, 0x00, 0x00, 0x70, 0xf2, 0xff, 0xff, 0x7f, 0x12, 0x00, 0x00, 0x78,
   0x12, 0x00, 0x00, 0x78, 0x12, 0x00, 0x00, 0x78, 0x12, 0x00, 0x00, 0x78,
   0x12, 0x00, 0x00, 0x78, 0x12, 0x00, 0x00, 0x78, 0x12, 0x00, 0x00, 0x78,
   0x12, 0x00, 0x00, 0x78, 0x12, 0x00, 0x00, 0x78, 0x12, 0x00, 0x00, 0x78,
   0x12, 0x00, 0x00, 0x78, 0x12, 0x00, 0x00, 0x78, 0x12, 0x00, 0x00, 0x78,
   0x12, 0x00, 0x00, 0x78, 0x12, 0x00, 0x00, 0x78, 0x12, 0x00, 0x00, 0x78,
   0x12, 0x00, 0x00, 0x78, 0x12, 0x00, 0x00, 0x78, 0x12, 0x00, 0x00, 0x78,
   0x12, 0x00, 0x00, 0x78, 0x12, 0x00, 0x00, 0x78, 0x12, 0x00, 0x00, 0x78,
   0xf2, 0xff, 0xff, 0x7f, 0xfa, 0xff, 0xff, 0x7f, 0xfe, 0xff, 0xff, 0x7f,
   0xfe, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00};

/*
 * Data:	off_in_button_bits
 * Purpose:	32x32 bit border pattern
 *		for button in off state, occupied by pointer
 * Note:	compatable with X11 bitmap tool
 */
#define off_in_m_width 32
#define off_in_m_height 32
static unsigned char off_in_m_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0x7f, 0x02, 0x00, 0x00, 0x60,
   0xfa, 0xff, 0xff, 0x7f, 0x0a, 0x00, 0x00, 0x70, 0x0a, 0x00, 0x00, 0x70,
   0x0a, 0x00, 0x00, 0x70, 0x0a, 0x00, 0x00, 0x70, 0x0a, 0x00, 0x00, 0x70,
   0x0a, 0x00, 0x00, 0x70, 0x0a, 0x00, 0x00, 0x70, 0x0a, 0x00, 0x00, 0x70,
   0x0a, 0x00, 0x00, 0x70, 0x0a, 0x00, 0x00, 0x70, 0x0a, 0x00, 0x00, 0x70,
   0x0a, 0x00, 0x00, 0x70, 0x0a, 0x00, 0x00, 0x70, 0x0a, 0x00, 0x00, 0x70,
   0x0a, 0x00, 0x00, 0x70, 0x0a, 0x00, 0x00, 0x70, 0x0a, 0x00, 0x00, 0x70,
   0x0a, 0x00, 0x00, 0x70, 0x0a, 0x00, 0x00, 0x70, 0x0a, 0x00, 0x00, 0x70,
   0x0a, 0x00, 0x00, 0x70, 0x0a, 0x00, 0x00, 0x70, 0x0a, 0x00, 0x00, 0x70,
   0x0a, 0x00, 0x00, 0x70, 0xfa, 0xff, 0xff, 0x7f, 0xfe, 0xff, 0xff, 0x7f,
   0xfe, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00};

/*
 * Data:	on_out_button_bits
 * Purpose:	32x32 bit border pattern
 *		for button in on state, not occupied by pointer
 * Note:	compatable with X11 bitmap tool
 */
#define on_out_m_width 32
#define on_out_m_height 32
static unsigned char on_out_m_bits[] = {
   0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0xa0,
   0x01, 0x00, 0x00, 0xb0, 0xf1, 0xff, 0xff, 0xbf, 0x11, 0x00, 0x00, 0xb8,
   0x11, 0x00, 0x00, 0xb8, 0x11, 0x00, 0x00, 0xb8, 0x11, 0x00, 0x00, 0xb8,
   0x11, 0x00, 0x00, 0xb8, 0x11, 0x00, 0x00, 0xb8, 0x11, 0x00, 0x00, 0xb8,
   0x11, 0x00, 0x00, 0xb8, 0x11, 0x00, 0x00, 0xb8, 0x11, 0x00, 0x00, 0xb8,
   0x11, 0x00, 0x00, 0xb8, 0x11, 0x00, 0x00, 0xb8, 0x11, 0x00, 0x00, 0xb8,
   0x11, 0x00, 0x00, 0xb8, 0x11, 0x00, 0x00, 0xb8, 0x11, 0x00, 0x00, 0xb8,
   0x11, 0x00, 0x00, 0xb8, 0x11, 0x00, 0x00, 0xb8, 0x11, 0x00, 0x00, 0xb8,
   0x11, 0x00, 0x00, 0xb8, 0x11, 0x00, 0x00, 0xb8, 0x11, 0x00, 0x00, 0xb8,
   0xf1, 0xff, 0xff, 0xbf, 0xf9, 0xff, 0xff, 0xbf, 0xfd, 0xff, 0xff, 0xbf,
   0x01, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff};

/*
 * Data:	on_in_button_bits
 * Purpose:	32x32 bit border pattern
 *		for button in on state, occupied by pointer
 * Note:	compatable with X11 bitmap tool
 */
#define on_in_m_width 32
#define on_in_m_height 32
static unsigned char on_in_m_bits[] = {
   0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0xa0,
   0xf9, 0xff, 0xff, 0xbf, 0x09, 0x00, 0x00, 0xb0, 0x09, 0x00, 0x00, 0xb0,
   0x09, 0x00, 0x00, 0xb0, 0x09, 0x00, 0x00, 0xb0, 0x09, 0x00, 0x00, 0xb0,
   0x09, 0x00, 0x00, 0xb0, 0x09, 0x00, 0x00, 0xb0, 0x09, 0x00, 0x00, 0xb0,
   0x09, 0x00, 0x00, 0xb0, 0x09, 0x00, 0x00, 0xb0, 0x09, 0x00, 0x00, 0xb0,
   0x09, 0x00, 0x00, 0xb0, 0x09, 0x00, 0x00, 0xb0, 0x09, 0x00, 0x00, 0xb0,
   0x09, 0x00, 0x00, 0xb0, 0x09, 0x00, 0x00, 0xb0, 0x09, 0x00, 0x00, 0xb0,
   0x09, 0x00, 0x00, 0xb0, 0x09, 0x00, 0x00, 0xb0, 0x09, 0x00, 0x00, 0xb0,
   0x09, 0x00, 0x00, 0xb0, 0x09, 0x00, 0x00, 0xb0, 0x09, 0x00, 0x00, 0xb0,
   0x09, 0x00, 0x00, 0xb0, 0xf9, 0xff, 0xff, 0xbf, 0xfd, 0xff, 0xff, 0xbf,
   0x01, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff};

/*
 * Data:	motfBorders
 * Purpose:	TAE-like border patterns for four states of button
 * Note:	Used by MakeButtonBox in create.c
 * Note:	ButtonBorders defined in buttons.h
 */
static BorderPatterns motfBorders = {
  (unsigned char *)off_out_m_bits,
  (unsigned char *)off_in_m_bits,
  (unsigned char *)on_out_m_bits,
  (unsigned char *)on_in_m_bits };
