#!	/bin/sh

# Install the kernel from this boot floppy onto the root filesystem.
# Don't run LILO, so the hard disk won't be bootable until more is done.
# The commands used by this script are limited to the ones available on
# the root floppy.

set -e
umask 022

extract="cpio --format=ustar --extract --unconditional"
if [ -x /bin/star -o -x /usr/bin/star ]; then
	extract="star"
fi

if [ ! -f install.sh ]; then
	echo 	"Error: Change directory to the floppy before running this script."
	1>&2
	exit -1
fi

FLOPPY=`pwd`

if [ $# -gt 0 ]; then
	DESTDIR=$1
fi

(cd ${DESTDIR}/; gunzip < $FLOPPY/modules.tgz|$extract)
(cd ${DESTDIR}/; depmod -a)
sync
exit 0
