#!	/bin/sh
# Boot Disk maker. Bruce Perens, July-September 1995
# This is free software under the GNU General Public License.

# Abort on any non-zero return.
set -e

# Verbose shell execution.
# set -x
# set -v

# Remove this soon - most people should run kerneld.
(modprobe msdos floppy; exit 0)

# Print a usage message and exit if the argument count is wrong.
if [ $# != 4 ]; then
echo "Usage: "$0" kernel-package root-image floppy-drive blocks" 1>&2
	cat 1>&2 << EOF

	kernel-package: the Debian package containing the kernel.
	root-image: a compressed disk image to load in ramdisk and mount as root.
	floppy-drive: the block device file for the floppy drive.
	blocks: the size of the floppy in 1K blocks, use 720, 1200, or 1440.

	/mnt must be available for mounting the floppy disk.

EOF

	exit -1
fi

# Make sure the kernel package is available.
if [ ! -f $1 ]; then
	echo "Can't find $1" 1>&2
	exit -1
fi

# Make sure the specified disk device is indeed a block device.
if [ ! -b $3 ]; then
	echo "Error: "$3": not a block device. Should be the floppy disk device." \
		1>&2
	exit -1
fi

# Try to unmount anything that should not be mounted. Aborted runs of this
# script may have left things mounted.
(umount /mnt; umount $3; true)2>/dev/null >/dev/null

# Zero the entire disk, so that when I compress the raw disk image,
# unused blocks will compress well.
dd if=/dev/zero of=$3 bs=1k count=$4

# Extract the kernel from its package.
(rm -f -r /var/tmp/extract-tmp-$$;true)
mkdir /var/tmp/extract-tmp-$$
dpkg-deb --extract $1 /var/tmp/extract-tmp-$$

# Get the kernel version from its package name.
VERSION="${1##*/kernel-image-}"
VERSION="${VERSION%%_*}"

# Do the actual work of making the disk bootable.
mkrboot syslinux /var/tmp/extract-tmp-$$/boot/vmlinuz-*.*.* $2 $3 $4

# mount the disk to install additional files
mount $3 /mnt

# Copy system.map to the floppy.
gzip -best < /var/tmp/extract-tmp-$$/boot/System.map-$VERSION > /mnt/sys_map.gz

# Install the greeting and help messages
for i in debian.txt readme.txt f1.txt f10.txt f2.txt f3.txt \
 f4.txt f5.txt f6.txt f7.txt f8.txt f9.txt syslinux.cfg ; do
	sed s/--version--/$VERSION/ <scripts/rescue/$i |unix2dos>/mnt/$i
done

sed s/--version--/$VERSION/ <scripts/rescue/install.sh >/mnt/install.sh
sed s/--version--/$VERSION/ <scripts/rescue/rdev.sh >/mnt/rdev.sh
chmod 777 /mnt/install.sh /mnt/rdev.sh
echo "rescue">/mnt/type.txt

umount /mnt

(rm -f -r /var/tmp/extract-tmp-$$ resq$4.bin;true)
dd if=$3 of=resq$4.bin bs=1k count=$4
ls -l resq$4.bin
exit 0
