#!	/bin/sh

set -e

last () {
	eval 'echo $'$#''
}

ramdisk=/dev/ram0
floppy=/dev/fd0

architecture=`dpkg --print-architecture`
# Customize this to refer to the path of the Debian archive.
archive=/debian/CD/debian/frozen/binary-${architecture}
kernel=`last $archive/base/kernel-image-*.deb`
kernel_version="${kernel##*/kernel-image-}"
kernel_version="${kernel_version%%_*}"
packages="$kernel \
 `last $archive/admin/pcmcia-modules-${kernel_version}_*.deb`"

(cd utilities;make)

if [ ! -f root.bin ]; then
	./rootdisk.sh ${archive} $ramdisk 1440
fi

if [ ! -f resq1440.bin ]; then
	./rescue.sh ${kernel} root.bin $floppy 1440
fi

# if [ ! -f resq1200.bin ]; then
#	./rescue.sh ${kernel} root.bin $floppy 1200
# fi

if [ ! -f drv1440.bin ]; then
	./drivers.sh $floppy 1440 $packages
fi

if [ ! -f drv1200.bin ]; then
	./drivers.sh $floppy 1200 $packages
fi

if [ ! -f base1_2.tgz ]; then
	./basedisks.sh ${archive}
fi
