/*
 * GUI directory view header
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_DIRVIEW_H__
#define __GDIFF_DIRVIEW_H__


#include "properties.h" /* for DViewPref */

#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */

/*
 * Data structure definitions
 */
/* Directory view data
 * From an intuitive perspective, this is related to files list. */
struct _GDiffDirViews {
	/* Back-end data */
	DiffDir *diffdir;
	char *dirname1;
	char *dirname2;
	gboolean isdir;

	GSList *gdfile_list;/* Singly linked list of GDiffFileViews */

	/* For reference */
	GDiffWindow *gdwin;

	/* Front-end data */
	DViewPref pref;
	GtkWidget *base;/* A virtual base widget, which points to a real widget. */
	GtkHBox *hbox;
	GtkLabel *label;
	GtkCList *clist;

	gboolean b_dirty;/* Set when one of files under this directory has been reloaded. */
};


/* Global function declarations */
extern GDiffDirViews* gdiff_dirviews_new(GDiffWindow *gdwin, const char *fname1, const char *fname2, gboolean isdir);
extern void gdiff_dirviews_delete(GDiffDirViews *gdirviews);
extern void* gdiff_current_views(const GDiffWindow *gdwin, gboolean *ret_isdir);
extern void dirview_display(GDiffDirViews *gdirviews);
extern void dirview_redisplay(GDiffDirViews *gdirviews);

	
#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_DIRVIEW_H__ */
