.ig \"-*- nroff -*-
Copyright (C) 1989-1999 Free Software Foundation, Inc.

Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.

Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
..
.\" define a string tx for the TeX logo
.ie t .ds tx T\h'-.1667m'\v'.224m'E\v'-.224m'\h'-.125m'X
.el .ds tx TeX
.de TQ
.br
.ns
.TP \\$1
..
.\" Like TP, but if specified indent is more than half
.\" the current line-length - indent, use the default indent.
.de Tp
.ie \\n(.$=0:((0\\$1)*2u>(\\n(.lu-\\n(.iu)) .TP
.el .TP "\\$1"
..
.\" The BSD man macros can't handle " in arguments to font change macros,
.\" so use \(ts instead of ".
.tr \(ts"
.TH @G@TROFF 1 "@MDATE@" "Groff Version @VERSION@"
.SH NAME
@g@troff \- format documents
.SH SYNOPSIS
.nr a \n(.j
.ad l
.nr i \n(.i
.in +\w'\fB@g@troff 'u
.ti \niu
.B @g@troff
.de OP
.ie \\n(.$-1 .RI "[\ \fB\\$1\fP" "\\$2" "\ ]"
.el .RB "[\ " "\\$1" "\ ]"
..
.OP \-abivzCERU
.OP \-w name
.OP \-W name
.OP \-d cs
.OP \-f fam
.OP \-m name
.OP \-n num
.OP \-o list
.OP \-r cn
.OP \-T name
.OP \-F dir
.OP \-M dir
.RI "[\ " files\|.\|.\|. "\ ]"
.br
.ad \na
.SH DESCRIPTION
This manual page describes the GNU version of
.BR troff ,
which is part of the groff document formatting system.
It is highly compatible with Unix troff.
Usually it should be invoked using the groff command, which will
also run preprocessors and postprocessors in the appropriate
order and with the appropriate options.
.SH OPTIONS
.TP \w'\-dname=s'u+2n
.B \-a
Generate an
.SM ASCII
approximation of the typeset output.
.TP
.B \-b
Print a backtrace with each warning or error message.  This backtrace
should help track down the cause of the error.  The line numbers given
in the backtrace may not always be correct:
.B troff 's
idea of line numbers
gets confused by
.B as
or 
.B am
requests.
.TP
.B \-i
Read the standard input after all the named input files have been
processed.
.TP
.B \-v
Print the version number.
.TP
.BI \-w name
Enable warning
.IR  name .
Available warnings are described in
the Warnings subsection below.
Multiple
.B \-w
options are allowed.
.TP
.BI \-W name
Inhibit warning
.IR name .
Multiple
.B \-W
options are allowed.
.TP
.B \-E
Inhibit all error messages.
.TP
.B \-z
Suppress formatted output.
.TP
.B \-C
Enable compatibility mode.
.TP
.BI \-d cs
.TQ
.BI \-d name = s
Define
.I c
or
.I name
to be a string
.IR s ;
.I c
must be a one letter name.
.TP
.BI \-f fam
Use
.I fam
as the default font family.
.TP
.BI \-m name
Read in the file
.BI tmac. name\fR.
Normally this will be searched for in @MACRODIR@.
By default is used the 
.I safer
macro (reverted using -U ).
.TP
.B \-U
Unsafe option, avoids default use of 
.I safer
macro.
.TP
.B \-R
Don't load
.BR troffrc .
.TP
.BI \-n num
Number the first page
.IR num .
.TP
.BI \-o list
Output only pages in
.IR list ,
which is a comma-separated list of page ranges;
.I n
means print page
.IR n ,
.IB m \- n
means print every page between
.I m
and
.IR n ,
.BI \- n
means print every page up to
.IR n ,
.IB n \-
means print every page from
.IR n .
.B Troff
will exit after printing the last page in the list.
.TP
.BI \-r cn
.TQ
.BI \-r name = n
Set number register
.I c
or
.I name
to
.IR n ;
.I c
must be a one character name;
.I n
can be any troff numeric expression.
.TP
.BI \-T name
Prepare output for device
.IR name ,
rather than the default
.BR @DEVICE@ .
.TP
.BI \-F dir
Search
.I dir
for subdirectories
.BI dev name
.RI ( name
is the name of the device)
for the
.B DESC
file and font files before the normal
.BR @FONTDIR@ .
.TP
.BI \-M dir
Search directory
.I dir
for macro files before the normal
.BR @MACRODIR@ .
.SH USAGE
Only the features not in Unix troff are described here.
.SS Long names
The names of number registers, fonts, strings/macros/diversions,
special characters can be of any length. In escape sequences, where
you can use 
.BI ( xx
for a two character name, you can use
.BI [ xxx ]
for a name of arbitrary length:
.TP
.BI \e[ xxx ]
Print the special character called
.IR xxx .
.TP
.BI \ef[ xxx ]
Set font
.IR xxx .
.TP
.BI \e*[ xxx ]
Interpolate string
.IR xxx .
.TP
.BI \en[ xxx ]
Interpolate number register
.IR xxx .
.SS Fractional pointsizes
A
.I
scaled point
is equal to 1/sizescale
points, where
sizescale is specified in the
.B DESC
file (1 by default.)
There is a new scale indicator
.B z
which has the effect of multiplying by sizescale.
Requests and escape sequences in troff 
interpret arguments that represent a pointsize as being in units
of scaled points, but they evaluate each such argument
using a default scale indicator of
.BR z .
Arguments treated in this way are
the argument to the
.B ps
request,
the third argument to the
.B cs
request,
the second and fourth arguments to the
.B tkf
request,
the argument to the
.B \eH
escape sequence,
and those variants of the
.B \es
escape sequence that take a numeric expression as their argument.
.LP
For example, suppose sizescale is 1000;
then a scaled point will be equivalent to a millipoint;
the request
.B .ps 10.25
is equivalent to
.B .ps 10.25z
and so sets the pointsize to 10250 scaled points,
which is equal to 10.25 points.
.LP
The number register
.B \en(.s
returns the pointsize in points as decimal fraction.
There is also a new number register
.B \en[.ps]
that returns the pointsize in scaled points.
.LP
It would make no sense to use the
.B z
scale indicator in a numeric expression
whose default scale indicator was neither
.B u
nor
.BR z ,
and so
.B troff
disallows this.
Similarly it would make no sense to use a scaling indicator
other than
.B z
or
.B u
in a numeric expression whose default scale indicator was
.BR z ,
and so
.B troff
disallows this as well.
.LP
There is also new scale indicator
.B s
which multiplies by the number of units in a scaled point.
So, for example,
.B \en[.ps]s
is equal to
.BR 1m .
Be sure not to confuse the
.B s
and
.B z
scale indicators.
.SS Numeric expressions
.LP
Spaces are permitted in a number expression within parentheses.
.LP
.B M
indicates a scale of 100ths of an em.
.TP
.IB e1 >? e2
The maximum of
.I e1
and
.IR e2 .
.TP
.IB e1 <? e2
The minimum of
.I e1
and
.IR e2 .
.TP
.BI ( c ; e )
Evaluate
.I e
using
.I c
as the default scaling indicator.
If
.I c
is missing, ignore scaling indicators in the evaluation of
.IR e .
.SS New escape sequences
.TP
.BI \eA' anything '
This expands to
.B 1
or
.B 0
according as
.I anything
is or is not acceptable as the name of a string, macro, diversion,
number register, environment or font.
It will return
.B 0
if
.I anything
is empty.
This is useful if you want to lookup user input in some sort of
associative table.
.TP
.BI \eC' xxx '
Typeset character named
.IR xxx .
Normally it is more convenient to use
.BI \e[ xxx ]\fR.
But
.B \eC
has the advantage that it is compatible with recent versions of
.SM UNIX
and is available in compatibility mode.
.TP
.B \eE
This is equivalent to an escape character,
but it's not interpreted in copy-mode.
For example, strings to start and end superscripting could be defined
like this:
.RS
.IP
\&.ds { \ev'\-.3m'\es'\eEn[.s]*6u/10u'
.br
\&.ds } \es0\ev'.3m'
.LP
The use of
.B \eE
ensures that these definitions will work even if
.B \e*{
gets interpreted in copy-mode
(for example, by being used in a macro argument.)
.RE
.TP
.BI \eN' n '
Typeset the character with code
.I n
in the current font.
.I n
can be any integer.
Most devices only have characters with codes between 0 and 255.
If the current font does not contain a character with that code,
special fonts will
.I not
be searched.
The
.B \eN
escape sequence can be conveniently used on conjunction with the
.B char
request:
.RS
.IP
.B
\&.char \e[phone] \ef(ZD\eN'37'
.RE
.IP
The code of each character is given in the fourth column in the font
description file after the
.B charset
command.
It is possible to include unnamed characters in the font description
file by using a name of
.BR \-\-\- ;
the
.B \eN
escape sequence is the only way to use these.
.TP
.BI \eR' name\ \(+-n '
This has the same effect as
.RS
.IP
.BI .nr\  name\ \(+-n
.RE
.TP
.BI \es( nn
.TQ
.BI \es\(+-( nn
Set the point size to
.I nn
points;
.I nn
must be exactly two digits.
.TP
.BI \es[\(+- n ]
.TQ
.BI \es\(+-[ n ]
.TQ
.BI \es'\(+- n '
.TQ
.BI \es\(+-' n '
Set the point size to
.I n
scaled points;
.I n
is a numeric expression with a default scale indicator of
.BR z .
.TP
.BI \eV x
.TQ
.BI \eV( xx
.TQ
.BI \eV[ xxx ]
Interpolate the contents of the environment variable
.I xxx ,
as returned by
.BR getenv (3).
.B \eV
is interpreted in copy-mode.
.TP
.BI \eY x
.TQ
.BI \eY( xx
.TQ
.BI \eY[ xxx ]
This is approximately equivalent to
.BI \eX'\e*[ xxx ]'\fR.
However the contents of the string or macro
.I xxx
are not interpreted;
also it is permitted for
.I xxx
to have been defined as a macro and thus contain newlines
(it is not permitted for the argument to
.B \eX
to contain newlines).
The inclusion of newlines requires an extension to the Unix troff output
format, and will confuse drivers that do not know about this
extension.
.TP
.BI \eZ' anything '
Print anything and then restore the horizontal and vertical
position;
.I anything
may not contain tabs or leaders.
.TP
.B \e$0
The name by which the current macro was invoked.
The
.B als
request can make a macro have more than one name.
.TP
.B \e$*
In a macro, the concatenation of all the arguments separated by spaces.
.TP
.B \e$@
In a macro, the concatenation of all the arguments with each surrounded by
double quotes, and separated by spaces. 
.TP
.BI \e$( nn
.TQ
.BI \e$[ nnn ]
In a macro, this gives the
.IR nn -th
or
.IR nnn -th
argument.
Macros can have a unlimited number of arguments.
.TP
.BI \e? anything \e?
When used in a diversion, this will transparently embed
.I anything
in the diversion.
.I anything
is read in copy mode.
When the diversion is reread,
.I anything
will be interpreted.
.I anything
may not contain newlines; use
.B \e!
if you want to embed newlines in a diversion.
The escape sequence
.B \e?
is also recognised in copy mode and turned into a single internal
code; it is this code that terminates
.IR anything .
Thus
.RS
.RS
.ft B
.nf
.ne 15
\&.nr x 1
\&.nf
\&.di d
\e?\e\e?\e\e\e\e?\e\e\e\e\e\e\e\enx\e\e\e\e?\e\e?\e?
\&.di
\&.nr x 2
\&.di e
\&.d
\&.di
\&.nr x 3
\&.di f
\&.e
\&.di
\&.nr x 4
\&.f
.fi
.ft
.RE
.RE
.IP
will print
.BR 4 .
.TP
.B \e/
This increases the width of the preceding character so that
the spacing between that character and the following character
will be correct if the following character is a roman character.
For example, if an italic f is immediately followed by a roman
right parenthesis, then in many fonts the top right portion of the f
will overlap the top left of the right parenthesis producing \fIf\fR)\fR,
which is ugly.
Inserting
.B \e/
produces
.ie \n(.g \fIf\/\fR)\fR
.el \fIf\|\fR)\fR
and avoids this problem.
It is a good idea to use this escape sequence whenever an
italic character is immediately followed by a roman character without any
intervening space.
.TP
.B \e,
This modifies the spacing of the following character so that the spacing
between that character and the preceding character will correct if
the preceding character is a roman character.
For example, inserting
.B \e,
between the parenthesis and the f changes
\fR(\fIf\fR to
.ie \n(.g \fR(\,\fIf\fR.
.el \fR(\^\fIf\fR.
It is a good idea to use this escape sequence whenever a
roman character is immediately followed by an italic character without any
intervening space.
.TP
.B \e)
Like
.B \e&
except that it behaves like a character declared with the
.B cflags
request to be transparent for the purposes of end of sentence recognition.
.TP
.B \e~
This produces an unbreakable space that stretches like a normal inter-word
space when a line is adjusted.
.TP
.B \e#
Everything up to and including the next newline is ignored.
This is interpreted in copy mode.
This is like
.B \e"
except that
.B \e"
does not ignore the terminating newline.
.SS New requests
.TP
.BI .aln\  xx\ yy
Create an alias
.I xx
for number register object named
.IR yy .
The new name and the old name will be exactly equivalent.
If
.I yy
is undefined, a warning of type
.B reg
will be generated, and the request will be ignored.
.TP
.BI .als\  xx\ yy
Create an alias
.I xx
for request, string, macro, or diversion object named
.IR yy .
The new name and the old name will be exactly equivalent (it is similar to a
hard rather than a soft link).
If
.I yy
is undefined, a warning of type
.B mac
will be generated, and the request will be ignored.
The
.BR de ,
.BR am ,
.BR di ,
.BR da ,
.BR ds ,
and
.B as
requests only create a new object if the name of the macro, diversion
or string diversion is currently undefined or if it is defined to be a
request; normally they modify the value of an existing object.
.TP
.BI .asciify\  xx
This request only exists in order to make it possible
to make certain gross hacks work with GNU troff.
It `unformats' the diversion
.I xx
in such a way that
.SM ASCII
characters that were formatted and diverted into
.I xx
will be treated like ordinary input characters when
.I xx
is reread.
For example, this
.RS
.IP
.ne 7v+\n(.Vu
.ft B
.nf
.ss 24
\&.tr @.
\&.di x
\&@nr\e n\e 1
\&.br
\&.di
\&.tr @@
\&.asciify x
\&.x
.ss 12
.fi
.RE
.IP
will set register
.B n
to 1.
.TP
.B .backtrace
Print a backtrace of the input stack on stderr.
.TP
.BI .blm\  xx
Set the blank line macro to
.IR xx .
If there is a blank line macro,
it will be invoked when a blank line is encountered instead of the usual
troff behaviour.
.TP
.B .break
Break out of a while loop.
See also the
.B while
and
.B continue
requests.
Be sure not to confuse this with the
.B br
request.
.TP
.BI .cflags\  n\ c1\ c2\|.\|.\|.
Characters
.IR c1 ,
.IR c2 ,\|.\|.\|.
have properties determined by
.IR n ,
which is ORed from the following:
.RS
.TP
1
the character ends sentences
(initially characters
.B .?!
have this property);
.TP
2
lines can be broken before the character
(initially no characters have this property);
a line will not be broken at a character with this property
unless the characters on each side both have non-zero
hyphenation codes.
.TP
4
lines can be broken after the character
(initially characters
.B \-\e(hy\e(em
have this property);
a line will not be broken at a character with this property
unless the characters on each side both have non-zero
hyphenation codes.
.TP
8
the character overlaps horizontally
(initially characters
.B \e(ul\e(rn\e(ru
have this property);
.TP
16
the character overlaps vertically
(initially character
.B \e(br
has this property);
.TP
32
an end of sentence character followed by any number of characters
with this property will be treated
as the end of a sentence if followed by a newline or two spaces;
in other words
the character is transparent for the purposes of end of sentence
recognition;
this is the same as having a zero space factor in \*(tx
(initially characters
.B \(ts')]*\e(dg\e(rq
have this property).
.RE
.TP
.BI .char\  c\ string
Define character
.I c
to be
.IR string .
Every time character
.I c
needs to be printed,
.I string
will be processed in a temporary environment and the result
will be wrapped up into a single object.
Compatibility mode will be turned off
and the escape character will be set to
.B \e
while
.I string
is being processed.
Any emboldening, constant spacing or track kerning will be applied
to this object rather than to individual characters in
.IR string .
A character defined by this request can be used just like
a normal character provided by the output device.
In particular other characters can be translated to it
with the
.B tr
request;
it can be made the leader character by the
.B lc
request;
repeated patterns can be drawn with the character using the
.B \el
and
.B \eL
escape sequences;
words containing the character can be hyphenated
correctly, if the
.B hcode
request is used to give the character a hyphenation code.
There is a special anti-recursion feature: 
use of character within the character's definition
will be handled like normal characters not defined with
.BR char .
A character definition can be removed with the
.B rchar
request.
.TP
.BI .chop\  xx
Chop the last character off macro, string, or diversion
.IR xx .
This is useful for removing the newline from the end of diversions
that are to be interpolated as strings.
.TP
.BI .close\  stream
Close the stream named
.IR stream ;
.I stream
will no longer be an acceptable argument to the
.B write
request.
See the
.B open
request.
.TP
.B .continue
Finish the current iteration of a while loop.
See also the
.B while
and
.B break
requests.
.TP
.BI .cp\  n
If
.I n
is non-zero or missing, enable compatibility mode, otherwise
disable it.
In compatibility mode, long names are not recognised, and the
incompatibilities caused by long names do not arise.
.TP
.BI .do\  xxx
Interpret
.I .xxx
with compatibility mode disabled.
For example,
.RS
.IP
.B
\&.do fam T
.LP
would have the same effect as
.IP
.B
\&.fam T
.LP
except that it would work even if compatibility mode had been enabled.
Note that the previous compatibility mode is restored before any files
sourced by
.I xxx
are interpreted.
.RE
.TP
.BI .fam\  xx
Set the current font family to
.IR xx .
The current font family is part of the current environment.
See the description of the
.B sty
request for more information on font families.
.TP
.BI .fspecial\  f\ s1\ s2\|.\|.\|.
When the current font is
.IR f ,
fonts
.IR s1 ,
.IR s2 ,\|.\|.\|.
will be special, that is, they will searched for characters not in
the current font.
Any fonts specified in the
.B special
request will be searched after fonts specified in the
.B fspecial
request.
.TP
.BI .ftr\  f\ g
Translate font
.I f
to
.IR g .
Whenever a font named
.I f
is referred to in
.B \ef
escape sequence,
or in the
.BR ft ,
.BR ul ,
.BR bd ,
.BR cs ,
.BR tkf ,
.BR special ,
.BR fspecial ,
.BR fp ,
or
.BR sty
requests,
font
.I g
will be used.
If
.I g
is missing,
or equal to
.I f
then font
.I f
will not be translated.
.TP
.BI .hcode \ c1\ code1\ c2\ code2\|.\|.\|.
Set the hyphenation code of character
.I c1
to
.I code1
and that of
.I c2
to
.IR code2 .
A hyphenation code must be a single input
character (not a special character) other than a digit or a space.
Initially each lower-case letter has a hyphenation code, which
is itself, and each upper-case letter has a hyphenation code
which is the lower case version of itself.
See also the
.B hpf
request.
.TP
.BI .hla\  lang
Set the current hyphenation language to
.IR lang .
Hyphenation exceptions specified with the
.B hw
request and hyphenation patterns specified with the
.B hpf
request are both associated with the current hyphenation language.
The
.B hla
request is usually invoked by the
.B troffrc
file.
.TP
.BI .hlm\  n
Set the maximum number of consecutive hyphenated lines to
.IR n .
If
.I n
is negative, there is no maximum.
The default value is \-1.
This value is associated with the current environment.
Only lines output from an environment count towards the maximum associated
with that environment.
Hyphens resulting from
.B \e%
are counted; explicit hyphens are not.
.TP
.BI .hpf\  file
Read hyphenation patterns from
.IR file ;
this will be searched for in the same way that
.BI tmac. name
is searched for when the
.BI \-m name
option is specified.
It should have the same format as the argument to
the \epatterns primitive in \*(tx;
the letters appearing in this file are interpreted as hyphenation
codes.
A
.B %
character in the patterns file introduces a comment that continues
to the end of the line.
The set of hyphenation patterns is associated with the current language
set by the
.B hla
request.
The
.B hpf
request
is usually invoked by the
.B troffrc
file.
.TP
.BI .hym\  n
Set the
.I hyphenation margin
to
.IR n :
when the current adjustment mode is not
.BR b ,
the line will not be hyphenated if the line is no more than
.I n
short.
The default hyphenation margin is 0.
The default scaling indicator for this request is
.IR m .
The hyphenation margin is associated with the current environment.
The current hyphenation margin is available in the
.B \en[.hym]
register.
.TP
.BI .hys\  n
Set the
.I hyphenation space
to
.IR n :
when the current adjustment mode is
.B b
don't hyphenate the line if the line can be justified by adding no more than
.I n
extra space to each word space.
The default hyphenation space is 0.
The default scaling indicator for this request is
.BR m .
The hyphenation space is associated with the current environment.
The current hyphenation space is available in the
.B \en[.hys]
register.
.TP
.BI .kern\  n
If
.I n
is non-zero or missing, enable pairwise kerning, otherwise disable it.
.TP
.BI .mso\  file
The same as the
.B so
request except that
.I file
is searched for in the same way that
.BI tmac. name
is searched for when the
.BI \-m name
option is specified.
.TP
.B .nroff
Make the
.B n
built-in condition true
and the
.B t
built-in condition false.
This can be reversed using the
.B troff
request.
.TP
.BI .open\  stream\ filename
Open
.I filename
for writing and associate the stream named
.I stream
with it.
See also the
.B close
and
.B write
requests.
.TP 
.BI .opena\  stream\ filename
Like
.BR open ,
but if
.I filename
exists, append to it instead of truncating it.
.TP
.B .pnr
Print the names and contents of all currently defined number registers
on stderr.
.TP
.BI .pso \ command
This is behaves like the
.B so
request except that input comes from the standard output of
.IR command .
.TP
.B .ptr
Print the names and positions of all traps (not including input line
traps and diversion traps) on stderr.  Empty slots in the page trap
list are printed as well, because they can affect the priority of
subsequently planted traps.
.TP
.BI .rchar\  c1\ c2\|.\|.\|.
Remove the definitions of characters
.IR c1 ,
.IR c2 ,\|.\|.\|.
This undoes the effect of a
.B char
request.
.TP
.B .rj
.TQ
.BI .rj\  n
Right justify the next
.I n
input lines.
Without an argument right justify the next input line.
The number of lines to be right justified is available in the
.B \en[.rj]
register.
This implicitly does
.BR .ce\ 0 .
The
.B ce
request implicitly does
.BR .rj\ 0 .
.TP
.BI .rnn \ xx\ yy
Rename number register
.I xx
to
.IR yy .
.TP
.BI .shc\  c
Set the soft hyphen character to
.IR c .
If
.I c
is omitted,
the soft hyphen character will be set to the default
.BR \e(hy .
The soft hyphen character is the character which will be inserted
when a word is hyphenated at a line break.
If the soft hyphen character does not exist in the font of the character
immediately preceding a potential break point,
then the line will not be broken at that point.
Neither definitions (specified with the
.B char
request)
nor translations (specified with the
.B tr
request)
are considered when finding the soft hyphen character.
.TP
.BI .shift\  n
In a macro, shift the arguments by
.I n
positions:
argument
.I i
becomes argument
.IR i \- n ;
arguments 1 to
.I n
will no longer be available.
If
.I n
is missing,
arguments will be shifted by 1.
Shifting by negative amounts is currently undefined.
.TP
.BI .special\  s1\ s2\|.\|.\|.
Fonts
.IR s1 ,
.IR s2 ,
are special and will be searched for characters not in the
current font.
.TP
.BI .sty\  n\ f
Associate style
.I f
with font position
.IR n .
A font position can be associated either with a font or
with a style.
The current font is the index of a font position and so is also
either a font or a style.
When it is a style, the font that is actually used is the font the
name of which is the concatenation of the name of the current family
and the name of the current style.
For example, if the current font is 1 and font position 1 is
associated with style
.B R
and the current
font family is
.BR T ,
then font
.BR TR
will be used.
If the current font is not a style, then the current family is ignored.
When the requests
.BR cs ,
.BR bd ,
.BR tkf ,
.BR uf ,
or
.B fspecial
are applied to a style,
then they will instead be applied to the member of the
current family corresponding to that style.
The default family can be set with the
.B \-f
option.
The styles command in the
.SM DESC
file controls which font positions
(if any) are initially associated with styles rather than fonts.
.TP
.BI .tkf\  f\ s1\ n1\ s2\ n2
Enable track kerning for font
.IR f .
When the current font is
.I f
the width of every character will be increased by an amount
between
.I n1
and
.IR n2 ;
when the current point size is less than or equal to
.I s1
the width will be increased by
.IR n1 ;
when it is greater than or equal to
.I s2
the width will be increased by
.IR n2 ;
when the point size is greater than or equal to
.I s1
and less than or equal to
.I s2
the increase in width is a linear function of the point size.
.TP
.BI .trf\  filename
Transparently output the contents of file
.IR filename .
Each line is output as it would be were it preceded by
.BR \e! ;
however, the lines are not subject to copy-mode interpretation.
If the file does not end with a newline, then a newline will
be added.
For example, you can define a macro
.I x
containing the contents of file
.IR f ,
using
.RS
.IP
.BI .di\  x
.br
.BI .trf\  f
.br
.B .di
.LP
Unlike with the
.B cf
request,
the file cannot contain characters such as
.SM NUL
that are not legal troff input characters.
.RE
.TP
.B .trnt abcd
This is the same as the
.B tr
request except that the translations do not apply to text that is
transparently throughput into a diversion with
.BR \e! .
For example,
.RS
.LP
.nf
.ft B
\&.tr ab
\&.di x
\e!.tm a
\&.di
\&.x
.fi
.ft
.LP
will print
.BR b ;
if
.B trnt
is used instead of
.B tr
it will print
.BR a .
.RE
.TP
.B .troff
Make the
.B n
built-in condition false,
and the
.B t
built-in condition true.
This undoes the effect of the
.B nroff
request.
.TP
.BI .vpt\  n
Enable vertical position traps if
.I n
is non-zero, disable them otherwise.
Vertical position traps are traps set by the
.B wh
or
.B dt
requests.
Traps set by the
.B it
request are not vertical position traps.
The parameter that controls whether vertical position traps are enabled
is global.
Initially vertical position traps are enabled.
.TP
.BI .warn\  n
Control warnings.
.I n
is the sum of the numbers associated with each warning that is to be enabled;
all other warnings will be disabled.
The number associated with each warning is listed in the `Warnings' section.
For example,
.B .warn 0
will disable all warnings, and
.B .warn 1
will disable all warnings except that about missing characters.
If
.I n
is not given,
all warnings will be enabled.
.TP
.BI .while \ c\ anything
While condition
.I c
is true, accept
.I anything
as input;
.I c
can be any condition acceptable to an
.B if
request;
.I anything
can comprise multiple lines if the first line starts with
.B \e{
and the last line ends with
.BR \e} .
See also the
.B break
and
.B continue
requests.
.TP
.BI .write\  stream\ anything
Write
.I anything
to the stream named
.IR stream .
.I stream
must previously have been the subject of an
.B open
request.
.I anything
is read in copy mode;
a leading
.B \(ts
will be stripped.
.SS Extended requests
.TP
.BI .cf\  filename
When used in a diversion, this will embed in the diversion an object which,
when reread, will cause the contents of
.I filename
to be transparently copied through to the output.
In Unix troff, the
contents of
.I filename
is immediately copied through to the output regardless of whether
there is a current diversion; this behaviour is so anomalous that it
must be considered a bug.
.TP
.BI .ev\  xx
If
.I xx
is not a number, this will switch to a named environment called
.IR xx .
The environment should be popped with a matching
.B ev
request without any arguments, just as for numbered environments.
There is no limit on the number of named environments; they will be
created the first time that they are referenced.
.TP
.BI .fp\  n\ f1\ f2
The
.B fp
request has an optional third argument.
This argument gives the external name of the font,
which is used for finding the font description file.
The second argument gives the internal name of the font
which is used to refer to the font in troff after it has been mounted.
If there is no third argument then the internal name will be used
as the external name.
This feature allows you to use fonts with long names in compatibility mode.
.TP
.BI .ss\  m\ n
When two arguments are given to the
.B ss
request, the second argument gives the
.IR "sentence space size" .
If the second argument is not given, the sentence space size
will be the same as the word space size.
Like the word space size, the sentence space is in units of
one twelfth of the spacewidth parameter for the current font.
Initially both the word space size and the sentence
space size are 12.
The sentence space size is used in two circumstances:
if the end of a sentence occurs at the end of a line in fill mode, then
both an inter-word space and a sentence space will be added;
if two spaces follow the end of a sentence in the middle of a line,
then the second space will be a sentence space.
Note that the behaviour of Unix troff will be exactly
that exhibited by GNU troff if a second argument is never given to the
.B ss
request.
In GNU troff, as in Unix troff, you should always
follow a sentence with either a newline or two spaces.
.TP
.BI .ta\  n1\ n2\|.\|.\|.nn \ T\  r1\ r2\|.\|.\|.\|rn
Set tabs at positions
.IR n1 ,
.IR n2 ,\|.\|.\|.\|,
.I nn
and then set tabs at
.IR nn + r1 ,
.IR nn + r2 ,\|.\|.\|.\|.\|,
.IR nn + rn
and then at
.IR nn + rn + r1 ,
.IR nn + rn + r2 ,\|.\|.\|.\|,
.IR nn + rn + rn ,
and so on.
For example,
.RS
.IP
.B
\&.ta T .5i
.LP
will set tabs every half an inch.
.RE
.SS New number registers
The following read-only registers are available:
.TP
.B \en[.C]
1 if compatibility mode is in effect, 0 otherwise.
.TP
.B \en[.cdp]
The depth of the last character added to the current environment.
It is positive if the character extends below the baseline.
.TP
.B \en[.ce]
The number of lines remaining to be centered, as set by the
.B ce
request.
.TP
.B \en[.cht]
The height of the last character added to the current environment.
It is positive if the character extends above the baseline.
.TP
.B \en[.csk]
The skew of the last character added to the current environment.
The
.I skew
of a character is how far to the right of the center of a character
the center of an accent over that character should be placed.
.TP
.B \en[.ev]
The name or number of the current environment.
This is a string-valued register.
.TP
.B \en[.fam]
The current font family.
This is a string-valued register.
.TP
.B \en[.fp]
The number of the next free font position.
.TP
.B \en[.g]
Always 1.
Macros should use this to determine whether they are running
under GNU troff.
.TP
.B \en[.hla]
The current hyphenation language as set by the
.B hla
request.
.TP
.B \en[.hlc]
The number of immediately preceding consecutive hyphenated lines.
.TP
.B \en[.hlm]
The maximum allowed number of consecutive hyphenated lines, as set by the
.B hlm
request.
.TP
.B \en[.hy]
The current hyphenation flags (as set by the
.B hy
request.)
.TP
.B \en[.hym]
The current hyphenation margin (as set by the
.B hym
request.)
.TP
.B \en[.hys]
The current hyphenation space (as set by the
.B hys
request.)
.TP
.B \en[.in]
The indent that applies to the current output line.
.TP
.B \en[.kern]
.B 1
if pairwise kerning is enabled,
.B 0
otherwise.
.TP
.B \en[.lg]
The current ligature mode (as set by the
.B lg
request.)
.TP
.B \en[.ll]
The line length that applies to the current output line.
.TP
.B \en[.lt]
The title length as set by the
.B lt
request.
.TP
.B \en[.ne]
The amount of space that was needed in the last
.B ne
request that caused a trap to be sprung.
Useful in conjunction with the
.B \en[.trunc]
register.
.TP
.B \en[.pn]
The number of the next page:
either the value set by a
.B pn
request, or the number of the current page plus 1.
.TP
.B \en[.ps]
The current pointsize in scaled points.
.TP
.B \en[.psr]
The last-requested pointsize in scaled points.
.TP
.B \en[.rj]
The number of lines to be right-justified as set by the
.B rj
request.
.TP
.B \en[.sr]
The last requested pointsize in points as a decimal fraction.
This is a string-valued register.
.TP
.B \en[.tabs]
A string representation of the current tab settings suitable for use as
an argument to the
.B ta
request.
.TP
.B \en[.trunc]
The amount of vertical space truncated by the most recently sprung
vertical position trap, or,
if the trap was sprung by a
.B ne
request,
minus the amount of vertical motion produced by the
.B ne
request.
In other words, at the point a trap is sprung, it represents the difference
of what the vertical position would have been but for the trap,
and what the vertical position actually is.
Useful in conjunction with the
.B \en[.ne]
register.
.TP
.B \en[.ss]
.TQ
.B \en[.sss]
These give the values of the parameters set by the
first and second arguments of the
.B ss
request.
.TP
.B \en[.vpt]
1 if vertical position traps are enabled, 0 otherwise.
.TP
.B \en[.warn]
The sum of the numbers associated with each of the currently enabled
warnings.
The number associated with each warning is listed in the `Warnings'
subsection.
.TP
.B \en(.x
The major version number.
For example, if the version number is
.B 1.03
then
.B \en(.x
will contain
.BR 1 .
.TP
.B \en(.y
The minor version number.
For example, if the version number is
.B 1.03
then
.B \en(.y
will contain
.BR 03 .
.LP
The following registers are set by the
.B \ew
escape sequence:
.TP
.B \en[rst]
.TQ
.B \en[rsb]
Like the
.B st
and
.B sb
registers, but takes account of the heights and depths of characters.
.TP
.B \en[ssc]
The amount of horizontal space (possibly negative) that should
be added to the last character before a subscript.
.TP
.B \en[skw]
How far to right of the center of the last character
in the
.B \ew
argument,
the center of an accent from a roman font should be placed over that character.
.LP
The following read/write number registers are available:
.TP
.B \en[systat]
The return value of the system() function executed by the last
.B sy
request.
.TP
.B \en[slimit]
If greater than 0, the maximum number of objects on the input stack.
If less than or equal to 0, there is no limit on the number of objects
on the input stack.  With no limit, recursion can continue until
virtual memory is exhausted.
.SS Miscellaneous
.LP
Fonts not listed in the
.SM DESC
file are automatically mounted on the next available font position
when they are referenced.
If a font is to be mounted explicitly with the
.B fp
request on an unused font position,
it should be mounted on the first unused font position,
which can be found in the
.B \en[.fp]
register;
although
.B troff
does not enforce this strictly,
it will not allow a font to be mounted at a position whose number is much
greater than that of any currently used position.
.LP
Interpolating a string does not hide existing macro arguments.
Thus in a macro, a more efficient way of doing
.IP
.BI . xx\  \e\e$@
.LP
is
.IP
.BI \e\e*[ xx ]\e\e  
.LP
If the font description file contains pairwise kerning information,
characters from that font will be kerned.
Kerning between two characters can be inhibited by placing a
.B \e&
between them.
.LP
In a string comparison in a condition, 
characters that appear at different input levels
to the first delimiter character will not be recognised
as the second or third delimiters.
This applies also to the
.B tl
request.
In a
.B \ew
escape sequence,
a character that appears at a different input level to
the starting delimiter character will not be recognised
as the closing delimiter character.
When decoding a macro argument that is delimited
by double quotes, a character that appears at a different
input level to the starting delimiter character will not
be recognised as the closing delimiter character.
The implementation of
.B \e$@
ensures that the double quotes surrounding an argument
will appear the same input level, which will be different
to the input level of the argument itself.
In a long escape name
.B ]
will not be recognized as a closing delimiter except
when it occurs at the same input level as the opening
.BR ] .
In compatibility mode, no attention is paid to the input-level.
.LP
There are some new types of condition:
.TP
.BI .if\ r xxx
True if there is a number register named
.IR xxx .
.TP
.BI .if\ d xxx
True if there is a string, macro, diversion, or request named
.IR xxx .
.TP
.BI .if\ c ch
True if there is a character
.IR ch
available;
.I ch
is either an
.SM ASCII
character
or a special character
.BI \e( xx
or
.BI \e[ xxx ]\fR;
the condition will also be true if
.I ch
has been defined by the
.B char
request.
.SS Warnings
The warnings that can be given by
.B troff
are divided into the following categories.
The name associated with each warning is used by the
.B \-w
and
.B \-W
options;
the number is used by the
.B warn
request, and by the
.B .warn
register.
.nr x \w'\fBright-brace'+1n+\w'0000'u
.ta \nxuR
.TP \nxu+3n
.BR char \t1
Non-existent characters.
This is enabled by default.
.TP
.BR number \t2
Invalid numeric expressions.
This is enabled by default.
.TP
.BR break \t4
In fill mode, lines which could not be broken so that their length was
less than the line length.
This is enabled by default.
.TP
.BR delim \t8
Missing or mismatched closing delimiters.
.TP
.BR el \t16
Use of the
.B el
request with no matching
.B ie
request.
.TP
.BR scale \t32
Meaningless scaling indicators.
.TP
.BR range \t64
Out of range arguments.
.TP
.BR syntax \t128
Dubious syntax in numeric expressions.
.TP
.BR di \t256
Use of
.B di
or
.B da
without an argument when there is no current diversion.
.TP
.BR mac \t512
Use of undefined strings, macros and diversions.
When an undefined string, macro or diversion is used,
that string is automatically defined as empty.
So, in most cases, at most one warning will be given for
each name.
.TP
.BR reg \t1024
Use of undefined number registers.
When an undefined number register is used,
that register is automatically defined to have a value of 0.
a definition is automatically made with a value of 0.
So, in most cases, at most one warning will be given for
use of a particular name.
.TP
.BR tab \t2048
Inappropriate use of a tab character.
Either use of a tab character where a number was expected,
or use of tab character in an unquoted macro argument.
.TP
.BR right-brace \t4096
Use of
.B \e}
where a number was expected.
.TP
.BR missing \t8192
Requests that are missing non-optional arguments.
.TP
.BR input \t16384
Illegal input characters.
.TP
.BR escape \t32768
Unrecognized escape sequences.
When an unrecognized escape sequence is encountered,
the escape character is ignored.
.TP
.BR space \t65536
Missing space between a request or macro and its argument.
This warning will be given 
when an undefined name longer than two characters is encountered,
and the first two characters of the name make a defined name.
The request or macro will not be invoked.
When this warning is given, no macro is automatically defined.
This is enabled by default.
This warning will never occur in compatibility mode.
.TP
.BR font \t131072
Non-existent fonts.
This is enabled by default.
.TP
.BR ig \t262144
Illegal escapes in text ignored with the
.B ig
request.
These are conditions that are errors when they do not occur
in ignored text.
.LP
There are also names that can be used to refer to groups of warnings:
.TP
.B all
All warnings except
.BR di ,
.B mac
and
.BR reg .
It is intended that this covers all warnings
that are useful with traditional macro packages.
.TP
.B w
All warnings.
.SS Incompatibilities
.LP
Long names cause some incompatibilities.
Unix troff will interpret
.IP
.B
\&.dsabcd
.LP
as defining a string
.B ab
with contents
.BR cd .
Normally, GNU troff will interpret this as a call of a macro named
.BR dsabcd .
Also Unix troff will interpret
.B \e*[
or
.B \en[
as references to a string or number register called
.BR [ .
In GNU troff, however, this will normally be interpreted as the start
of a long name.
In
.I compatibility mode
GNU troff will interpret these things in the traditional way.
In compatibility mode, however, long names are not recognised.
Compatibility mode can be turned on with the
.B \-C
command line option, and turned on or off with the
.B cp
request.
The number register
.B \en(.C
is 1 if compatibility mode is on, 0 otherwise.
.LP
GNU troff
does not allow the use of the escape sequences
.BR \\e\e|\e^\e&\e}\e{\e (space) \e'\e`\e-\e_\e!\e%\ec
in names of strings, macros, diversions, number registers,
fonts or environments; Unix troff does.
The
.B \eA
escape sequence may be helpful in avoiding use of these
escape sequences in names.
.LP
Fractional pointsizes cause one noteworthy incompatibility.
In Unix troff the
.B ps 
request ignores scale indicators and so
.IP
.B .ps\ 10u
.LP
will set the pointsize to 10 points, whereas in
GNU troff it will set the pointsize to 10 scaled points.
.LP
In GNU troff there is a fundamental difference between unformatted,
input characters, and formatted, output characters.
Everything that affects how an output character
will be output is stored with the character; once an output
character has been constructed it is unaffected by any subsequent
requests that are executed, including
.BR bd ,
.BR cs ,
.BR tkf ,
.BR tr ,
or
.B fp
requests.
Normally output characters are constructed from input
characters at the moment immediately before the character
is added to the current output line.
Macros, diversions and strings are all, in fact, the same type
of object; they contain lists of input characters and output
characters in any combination.
An output character does not behave like an input character
for the purposes of macro processing; it does not inherit any
of the special properties that the input character from which it
was constructed might have had.
For example,
.IP
.nf
.ft B
\&.di x
\e\e\e\e
\&.br
\&.di
\&.x
.ft
.fi
.LP
will print
.B \e\e
in GNU troff;
each pair of input
.BR \e s
is turned into one output
.B \e
and the resulting output
.BR \e s
are not interpreted as escape characters when they are reread.
Unix troff would interpret them as escape characters
when they were reread and would end up printing one
.BR \e .
The correct way to obtain a printable
.B \e
is to use the
.B \ee
escape sequence: this will always print a single instance of the
current escape character, regardless of whether or not it is used in a
diversion; it will also work in both GNU troff and Unix troff.
If you wish for some reason to store in a diversion an escape
sequence that will be interpreted when the diversion is reread,
you can either use the traditional
.B \e!
transparent output facility, or, if this is unsuitable, the new
.B \e?
escape sequence.
.SH ENVIRONMENT
.TP
.SM
.B GROFF_TMAC_PATH
A colon separated list of directories in which to search for
macro files.
.TP
.SM
.B GROFF_TYPESETTER
Default device.
.TP
.SM
.B GROFF_FONT_PATH
A colon separated list of directories in which to search for the
.BI dev name
directory.
.B troff
will search in directories given in the
.B \-F
option before these, and in standard directories
.RB ( @FONTPATH@ )
after these.
.SH FILES
.Tp \w'@FONTDIR@/devname/DESC'u+3n
.B @MACRODIR@/troffrc
Initialization file
.TP
.BI @MACRODIR@/tmac. name
Macro files
.TP
.BI @FONTDIR@/dev name /DESC
Device description file for device
.IR name .
.TP
.BI @FONTDIR@/dev name / F
Font file for font
.I F
of device
.IR name .
.SH "SEE ALSO"
.BR groff (@MAN1EXT@)
.BR @g@tbl (@MAN1EXT@),
.BR @g@pic (@MAN1EXT@),
.BR @g@eqn (@MAN1EXT@),
.BR grops (@MAN1EXT@),
.BR grodvi (@MAN1EXT@),
.BR grotty (@MAN1EXT@),
.BR grohtml (@MAN1EXT@),
.BR groff_font (@MAN5EXT@),
.BR groff_out (@MAN5EXT@),
.BR groff_char (@MAN7EXT@)
