;; $Id: dbl1ca.dsl,v 1.1.1.2 1999/08/27 21:20:49 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://nwalsh.com/docbook/dsssl/
;;

;; ----------------------------- Localization -----------------------------

;; If you create a new version of this file, please send it to
;; Norman Walsh, ndw@nwalsh.com

;; The generated text for cross references to elements.  See dblink.dsl
;; for a discussion of how substitution is performed on the %x 
;; keywords.
;;

(define (ca-appendix-xref-string gi-or-name)
  (if %chapter-autolabel%
      "&Appendix; %n"
      "l'&appendix; de nom %t"))

(define (ca-article-xref-string gi-or-name)
  (string-append %gentext-ca-start-quote%
		 "%t"
		 %gentext-ca-end-quote%))

(define (ca-bibliography-xref-string gi-or-name)
  "%t")

(define (ca-book-xref-string gi-or-name)
  "%t")

(define (ca-chapter-xref-string gi-or-name)
  (if %chapter-autolabel%
      "&Chapter; %n"
      "el &chapter; de nom %t"))

(define (ca-equation-xref-string gi-or-name)
  "&Equation; %n")

(define (ca-example-xref-string gi-or-name)
  "&Example; %n")

(define (ca-figure-xref-string gi-or-name)
  "&Figure; %n")

(define (ca-listitem-xref-string gi-or-name)
  "%n")

(define (ca-part-xref-string gi-or-name)
  "&Part; %n")

(define (ca-preface-xref-string gi-or-name)
  "%t")

(define (ca-procedure-xref-string gi-or-name)
  "&Procedure; %n, %t")

(define (ca-section-xref-string gi-or-name)
  (if %section-autolabel% 
      "&Section; %n" 
      "la &section; de nom %t"))

(define (ca-sect1-xref-string gi-or-name)
  (ca-section-xref-string gi-or-name))

(define (ca-sect2-xref-string gi-or-name)
  (ca-section-xref-string gi-or-name))

(define (ca-sect3-xref-string gi-or-name)
  (ca-section-xref-string gi-or-name))

(define (ca-sect4-xref-string gi-or-name)
  (ca-section-xref-string gi-or-name))

(define (ca-sect5-xref-string gi-or-name)
  (ca-section-xref-string gi-or-name))

(define (ca-sidebar-xref-string gi-or-name)
  "la &sidebar; %t")

(define (ca-step-xref-string gi-or-name)
  "&step; %n")

(define (ca-table-xref-string gi-or-name)
  "&Table; %n")

(define (ca-default-xref-string gi-or-name)
  (let* ((giname (if (string? gi-or-name) gi-or-name (gi gi-or-name)))
	 (msg    (string-append "[&xrefto; "
				(if giname giname "&nonexistantelement;")
				" &unsupported;]"))
	 (err    (node-list-error msg (current-node))))
    msg))

(define (gentext-ca-xref-strings gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
      ((equal? name (normalize "appendix")) (ca-appendix-xref-string gind))
      ((equal? name (normalize "article"))  (ca-article-xref-string gind))
      ((equal? name (normalize "bibliography")) (ca-bibliography-xref-string gind))
      ((equal? name (normalize "book"))     (ca-book-xref-string gind))
      ((equal? name (normalize "chapter"))  (ca-chapter-xref-string gind))
      ((equal? name (normalize "equation")) (ca-equation-xref-string gind))
      ((equal? name (normalize "example"))  (ca-example-xref-string gind))
      ((equal? name (normalize "figure"))   (ca-figure-xref-string gind))
      ((equal? name (normalize "listitem")) (ca-listitem-xref-string gind))
      ((equal? name (normalize "part"))     (ca-part-xref-string gind))
      ((equal? name (normalize "preface"))  (ca-preface-xref-string gind))
      ((equal? name (normalize "procedure")) (ca-procedure-xref-string gind))
      ((equal? name (normalize "sect1"))    (ca-sect1-xref-string gind))
      ((equal? name (normalize "sect2"))    (ca-sect2-xref-string gind))
      ((equal? name (normalize "sect3"))    (ca-sect3-xref-string gind))
      ((equal? name (normalize "sect4"))    (ca-sect4-xref-string gind))
      ((equal? name (normalize "sect5"))    (ca-sect5-xref-string gind))
      ((equal? name (normalize "sidebar"))  (ca-sidebar-xref-string gind))
      ((equal? name (normalize "step"))     (ca-step-xref-string gind))
      ((equal? name (normalize "table"))    (ca-table-xref-string gind))
      (else (ca-default-xref-string gind)))))

(define (ca-auto-xref-indirect-connector before) 
  ;; In English, the (cond) is unnecessary since the word is always the
  ;; same, but in other languages, that's not the case.  I've set this
  ;; one up with the (cond) so it stands as an example.
  (cond 
   ((equal? (gi before) (normalize "book"))
    (literal " al "))
   ((equal? (gi before) (normalize "chapter"))
    (literal " al; "))
   ((equal? (gi before) (normalize "sect1"))
    (literal " a la; "))
   (else
    (literal " &in; "))))

;; Should the TOC come first or last?
;;
(define %generate-ca-toc-in-front% #t)

;; gentext-element-name returns the generated text that should be 
;; used to make reference to the selected element.
;;
(define ca-abstract-name	"&Abstract;")
(define ca-appendix-name	"&Appendix;")
(define ca-article-name		"&Article;")
(define ca-bibliography-name	"&Bibliography;")
(define ca-book-name		"&Book;")
(define ca-calloutlist-name	"")
(define ca-caution-name		"&Caution;")
(define ca-chapter-name		"&Chapter;")
(define ca-copyright-name	"&Copyright;")
(define ca-dedication-name	"&Dedication;")
(define ca-edition-name		"&Edition;")
(define ca-equation-name	"&Equation;")
(define ca-example-name		"&Example;")
(define ca-figure-name		"&Figure;")
(define ca-glossary-name	"&Glossary;")
(define ca-glosssee-name	"&GlossSee;")
(define ca-glossseealso-name	"&GlossSeeAlso;")
(define ca-important-name	"&Important;")
(define ca-index-name		"&Index;")
(define ca-setindex-name	"&SetIndex;")
(define ca-isbn-name		"&ISBN;")
(define ca-legalnotice-name	"&LegalNotice;")
(define ca-msgaud-name		"&MsgAud;")
(define ca-msglevel-name	"&MsgLevel;")
(define ca-msgorig-name		"&MsgOrig;")
(define ca-note-name		"&Note;")
(define ca-part-name		"&Part;")
(define ca-preface-name		"&Preface;")
(define ca-procedure-name	"&Procedure;")
(define ca-pubdate-name		"&Published;")
(define ca-reference-name	"&Reference;")
(define ca-refname-name		"&RefName;")
(define ca-revhistory-name	"&RevHistory;")
(define ca-revision-name	"&Revision;")
(define ca-sect1-name		"&Section;")
(define ca-sect2-name		"&Section;")
(define ca-sect3-name		"&Section;")
(define ca-sect4-name		"&Section;")
(define ca-sect5-name		"&Section;")
(define ca-simplesect-name	"&Section;")
(define ca-seeie-name		"&See;")
(define ca-seealsoie-name	"&Seealso;")
(define ca-set-name		"&Set;")
(define ca-sidebar-name		"&Sidebar;")
(define ca-step-name		"&step;")
(define ca-table-name		"&Table;")
(define ca-tip-name		"&Tip;")
(define ca-toc-name		"&TableofContents;")
(define ca-warning-name		"&Warning;")

(define (gentext-ca-element-name gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "abstract"))	ca-abstract-name)
     ((equal? name (normalize "appendix"))	ca-appendix-name)
     ((equal? name (normalize "article"))	ca-article-name)
     ((equal? name (normalize "bibliography"))	ca-bibliography-name)
     ((equal? name (normalize "book"))		ca-book-name)
     ((equal? name (normalize "calloutlist"))	ca-calloutlist-name)
     ((equal? name (normalize "caution"))	ca-caution-name)
     ((equal? name (normalize "chapter"))	ca-chapter-name)
     ((equal? name (normalize "copyright"))	ca-copyright-name)
     ((equal? name (normalize "dedication"))	ca-dedication-name)
     ((equal? name (normalize "edition"))	ca-edition-name)
     ((equal? name (normalize "equation"))	ca-equation-name)
     ((equal? name (normalize "example"))	ca-example-name)
     ((equal? name (normalize "figure"))	ca-figure-name)
     ((equal? name (normalize "glossary"))	ca-glossary-name)
     ((equal? name (normalize "glosssee"))	ca-glosssee-name)
     ((equal? name (normalize "glossseealso"))	ca-glossseealso-name)
     ((equal? name (normalize "important"))	ca-important-name)
     ((equal? name (normalize "index"))		ca-index-name)
     ((equal? name (normalize "setindex"))	ca-setindex-name)
     ((equal? name (normalize "isbn"))		ca-isbn-name)
     ((equal? name (normalize "legalnotice"))	ca-legalnotice-name)
     ((equal? name (normalize "msgaud"))	ca-msgaud-name)
     ((equal? name (normalize "msglevel"))	ca-msglevel-name)
     ((equal? name (normalize "msgorig"))	ca-msgorig-name)
     ((equal? name (normalize "note"))		ca-note-name)
     ((equal? name (normalize "part"))		ca-part-name)
     ((equal? name (normalize "preface"))	ca-preface-name)
     ((equal? name (normalize "procedure"))	ca-procedure-name)
     ((equal? name (normalize "pubdate"))	ca-pubdate-name)
     ((equal? name (normalize "reference"))	ca-reference-name)
     ((equal? name (normalize "refname"))	ca-refname-name)
     ((equal? name (normalize "revhistory"))	ca-revhistory-name)
     ((equal? name (normalize "revision"))	ca-revision-name)
     ((equal? name (normalize "sect1"))		ca-sect1-name)
     ((equal? name (normalize "sect2"))		ca-sect2-name)
     ((equal? name (normalize "sect3"))		ca-sect3-name)
     ((equal? name (normalize "sect4"))		ca-sect4-name)
     ((equal? name (normalize "sect5"))		ca-sect5-name)
     ((equal? name (normalize "simplesect"))    ca-simplesect-name)
     ((equal? name (normalize "seeie"))		ca-seeie-name)
     ((equal? name (normalize "seealsoie"))	ca-seealsoie-name)
     ((equal? name (normalize "set"))		ca-set-name)
     ((equal? name (normalize "sidebar"))	ca-sidebar-name)
     ((equal? name (normalize "step"))		ca-step-name)
     ((equal? name (normalize "table"))		ca-table-name)
     ((equal? name (normalize "tip"))		ca-tip-name)
     ((equal? name (normalize "toc"))		ca-toc-name)
     ((equal? name (normalize "warning"))	ca-warning-name)
     (else (let* ((msg (string-append "&unexpectedelementname;: " name))
		  (err (node-list-error msg (current-node))))
	     msg)))))

;; gentext-element-name-space returns gentext-element-name with a 
;; trailing space, if gentext-element-name isn't "".
;;
(define (gentext-ca-element-name-space giname)
  (string-with-space (gentext-element-name giname)))

;; gentext-intra-label-sep returns the seperator to be inserted
;; between multiple occurances of a label (or parts of a label)
;; for the specified element.  Most of these are for enumerated
;; labels like "Figure 2-4", but this function is used elsewhere
;; (e.g. REFNAME) with a little abuse.
;;

(define ca-equation-intra-label-sep "-")
(define ca-example-intra-label-sep "-")
(define ca-figure-intra-label-sep "-")
(define ca-procedure-intra-label-sep ".")
(define ca-refentry-intra-label-sep ".")
(define ca-reference-intra-label-sep ".")
(define ca-refname-intra-label-sep ", ")
(define ca-refsect1-intra-label-sep ".")
(define ca-refsect2-intra-label-sep ".")
(define ca-refsect3-intra-label-sep ".")
(define ca-sect1-intra-label-sep ".")
(define ca-sect2-intra-label-sep ".")
(define ca-sect3-intra-label-sep ".")
(define ca-sect4-intra-label-sep ".")
(define ca-sect5-intra-label-sep ".")
(define ca-step-intra-label-sep ".")
(define ca-table-intra-label-sep "-")
(define ca-_pagenumber-intra-label-sep "-")
(define ca-default-intra-label-sep "")

(define (gentext-ca-intra-label-sep gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "equation"))	ca-equation-intra-label-sep)
     ((equal? name (normalize "example"))	ca-example-intra-label-sep)
     ((equal? name (normalize "figure"))	ca-figure-intra-label-sep)
     ((equal? name (normalize "procedure"))	ca-procedure-intra-label-sep)
     ((equal? name (normalize "refentry"))	ca-refentry-intra-label-sep)
     ((equal? name (normalize "reference"))	ca-reference-intra-label-sep)
     ((equal? name (normalize "refname"))	ca-refname-intra-label-sep)
     ((equal? name (normalize "refsect1"))	ca-refsect1-intra-label-sep)
     ((equal? name (normalize "refsect2"))	ca-refsect2-intra-label-sep)
     ((equal? name (normalize "refsect3"))	ca-refsect3-intra-label-sep)
     ((equal? name (normalize "sect1"))		ca-sect1-intra-label-sep)
     ((equal? name (normalize "sect2"))		ca-sect2-intra-label-sep)
     ((equal? name (normalize "sect3"))		ca-sect3-intra-label-sep)
     ((equal? name (normalize "sect4"))		ca-sect4-intra-label-sep)
     ((equal? name (normalize "sect5"))		ca-sect5-intra-label-sep)
     ((equal? name (normalize "step"))		ca-step-intra-label-sep)
     ((equal? name (normalize "table"))		ca-table-intra-label-sep)
     ((equal? name (normalize "_pagenumber"))	ca-_pagenumber-intra-label-sep)
     (else ca-default-intra-label-sep))))

;; gentext-label-title-sep returns the seperator to be inserted
;; between a label and the text following the label for the
;; specified element.  Most of these are for use between
;; enumerated labels and titles like "1. Chapter One Title", but
;; this function is used elsewhere (e.g. NOTE) with a little
;; abuse.
;;

(define ca-abstract-label-title-sep ": ")
(define ca-appendix-label-title-sep ". ")
(define ca-caution-label-title-sep "")
(define ca-chapter-label-title-sep ". ")
(define ca-equation-label-title-sep ". ")
(define ca-example-label-title-sep ". ")
(define ca-figure-label-title-sep ". ")
(define ca-footnote-label-title-sep ". ")
(define ca-glosssee-label-title-sep ": ")
(define ca-glossseealso-label-title-sep ": ")
(define ca-important-label-title-sep ": ")
(define ca-note-label-title-sep ": ")
(define ca-orderedlist-label-title-sep ". ")
(define ca-part-label-title-sep ". ")
(define ca-procedure-label-title-sep ". ")
(define ca-prefix-label-title-sep ". ")
(define ca-refentry-label-title-sep "")
(define ca-reference-label-title-sep ". ")
(define ca-refsect1-label-title-sep ". ")
(define ca-refsect2-label-title-sep ". ")
(define ca-refsect3-label-title-sep ". ")
(define ca-sect1-label-title-sep ". ")
(define ca-sect2-label-title-sep ". ")
(define ca-sect3-label-title-sep ". ")
(define ca-sect4-label-title-sep ". ")
(define ca-sect5-label-title-sep ". ")
(define ca-seeie-label-title-sep " ")
(define ca-seealsoie-label-title-sep " ")
(define ca-step-label-title-sep ". ")
(define ca-table-label-title-sep ". ")
(define ca-tip-label-title-sep ": ")
(define ca-warning-label-title-sep "")
(define ca-default-label-title-sep "")

(define (gentext-ca-label-title-sep gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "abstract")) ca-abstract-label-title-sep)
     ((equal? name (normalize "appendix")) ca-appendix-label-title-sep)
     ((equal? name (normalize "caution")) ca-caution-label-title-sep)
     ((equal? name (normalize "chapter")) ca-chapter-label-title-sep)
     ((equal? name (normalize "equation")) ca-equation-label-title-sep)
     ((equal? name (normalize "example")) ca-example-label-title-sep)
     ((equal? name (normalize "figure")) ca-figure-label-title-sep)
     ((equal? name (normalize "footnote")) ca-footnote-label-title-sep)
     ((equal? name (normalize "glosssee")) ca-glosssee-label-title-sep)
     ((equal? name (normalize "glossseealso")) ca-glossseealso-label-title-sep)
     ((equal? name (normalize "important")) ca-important-label-title-sep)
     ((equal? name (normalize "note")) ca-note-label-title-sep)
     ((equal? name (normalize "orderedlist")) ca-orderedlist-label-title-sep)
     ((equal? name (normalize "part")) ca-part-label-title-sep)
     ((equal? name (normalize "procedure")) ca-procedure-label-title-sep)
     ((equal? name (normalize "prefix")) ca-prefix-label-title-sep)
     ((equal? name (normalize "refentry")) ca-refentry-label-title-sep)
     ((equal? name (normalize "reference")) ca-reference-label-title-sep)
     ((equal? name (normalize "refsect1")) ca-refsect1-label-title-sep)
     ((equal? name (normalize "refsect2")) ca-refsect2-label-title-sep)
     ((equal? name (normalize "refsect3")) ca-refsect3-label-title-sep)
     ((equal? name (normalize "sect1")) ca-sect1-label-title-sep)
     ((equal? name (normalize "sect2")) ca-sect2-label-title-sep)
     ((equal? name (normalize "sect3")) ca-sect3-label-title-sep)
     ((equal? name (normalize "sect4")) ca-sect4-label-title-sep)
     ((equal? name (normalize "sect5")) ca-sect5-label-title-sep)
     ((equal? name (normalize "seeie")) ca-seeie-label-title-sep)
     ((equal? name (normalize "seealsoie")) ca-seealsoie-label-title-sep)
     ((equal? name (normalize "step")) ca-step-label-title-sep)
     ((equal? name (normalize "table")) ca-table-label-title-sep)
     ((equal? name (normalize "tip")) ca-tip-label-title-sep)
     ((equal? name (normalize "warning")) ca-warning-label-title-sep)
     (else ca-default-label-title-sep))))

(define (ca-set-label-number-format gind) "1")
(define (ca-book-label-number-format gind) "1")
(define (ca-prefix-label-number-format gind) "1")
(define (ca-part-label-number-format gind) "I")
(define (ca-chapter-label-number-format gind) "1")
(define (ca-appendix-label-number-format gind) "A")
(define (ca-reference-label-number-format gind) "I")
(define (ca-example-label-number-format gind) "1")
(define (ca-figure-label-number-format gind) "1")
(define (ca-table-label-number-format gind) "1")
(define (ca-procedure-label-number-format gind) "1")
(define (ca-step-label-number-format gind) "1")
(define (ca-refsect1-label-number-format gind) "1")
(define (ca-refsect2-label-number-format gind) "1")
(define (ca-refsect3-label-number-format gind) "1")
(define (ca-sect1-label-number-format gind) "1")
(define (ca-sect2-label-number-format gind) "1")
(define (ca-sect3-label-number-format gind) "1")
(define (ca-sect4-label-number-format gind) "1")
(define (ca-sect5-label-number-format gind) "1")
(define (ca-default-label-number-format gind) "1")

(define (ca-label-number-format gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "set")) (ca-set-label-number-format gind))
     ((equal? name (normalize "book")) (ca-book-label-number-format gind))
     ((equal? name (normalize "prefix")) (ca-prefix-label-number-format gind))
     ((equal? name (normalize "part")) (ca-part-label-number-format gind))
     ((equal? name (normalize "chapter")) (ca-chapter-label-number-format gind))
     ((equal? name (normalize "appendix")) (ca-appendix-label-number-format gind))
     ((equal? name (normalize "reference")) (ca-reference-label-number-format gind))
     ((equal? name (normalize "example")) (ca-example-label-number-format gind))
     ((equal? name (normalize "figure")) (ca-figure-label-number-format gind))
     ((equal? name (normalize "table")) (ca-table-label-number-format gind))
     ((equal? name (normalize "procedure")) (ca-procedure-label-number-format gind))
     ((equal? name (normalize "step")) (ca-step-label-number-format gind))
     ((equal? name (normalize "refsect1")) (ca-refsect1-label-number-format gind))
     ((equal? name (normalize "refsect2")) (ca-refsect2-label-number-format gind))
     ((equal? name (normalize "refsect3")) (ca-refsect3-label-number-format gind))
     ((equal? name (normalize "sect1")) (ca-sect1-label-number-format gind))
     ((equal? name (normalize "sect2")) (ca-sect2-label-number-format gind))
     ((equal? name (normalize "sect3")) (ca-sect3-label-number-format gind))
     ((equal? name (normalize "sect4")) (ca-sect4-label-number-format gind))
     ((equal? name (normalize "sect5")) (ca-sect5-label-number-format gind))
     (else (ca-default-label-number-format gind)))))

(define ($lot-title-ca$ gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond ((equal? name (normalize "table"))    "&ListofTables;")
	  ((equal? name (normalize "example"))  "&ListofExamples;")
	  ((equal? name (normalize "figure"))   "&ListofFigures;")
	  ((equal? name (normalize "equation")) "&ListofEquations;")
	  (else (let* ((msg (string-append "&ListofUnknown;: " name))
		       (err (node-list-error msg (current-node))))
		  msg)))))

(define %gentext-ca-start-quote% (dingbat "ldquo"))

(define %gentext-ca-end-quote% (dingbat "rdquo"))

(define %gentext-ca-start-nested-quote% (dingbat "lsquo"))

(define %gentext-ca-end-nested-quote% (dingbat "rsquo"))

(define %gentext-ca-by% "&by;") ;; e.g. Copyright 1997 "by" A. Nonymous
                           ;; Authored "by" Jane Doe

(define %gentext-ca-edited-by% "&Editedby;")
                           ;; "Edited by" Jane Doe

(define %gentext-ca-page% "")

(define %gentext-ca-and% "&and;")

(define %gentext-ca-bibl-pages% "&Pgs;")

(define %gentext-ca-endnotes% "&Notes;")

(define %gentext-ca-table-endnotes% "&TableNotes;:")

(define %gentext-ca-index-see% "&See;")

(define %gentext-ca-index-seealso% "&SeeAlso;")


