/* property.c - Property dialog for synchronizer.

   Copyright (C) 1998 Tom Tromey

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

#include <config.h>

#include <stdlib.h>

#include "sync.h"



/* The current property dialog.  This is global because there is only
   one per application.  */
static GnomePropertyBox *propertybox;

/* Entry holding the file size.  FIXME -- using globals here doesn't
   scale well.  */
static GtkEntry *filesize;

/* Entry holding the number of transfers.  FIXME -- using globals here
   doesn't scale well.  */
static GtkEntry *transfers;



static void
apply_properties (GnomePropertyBox *box, gint page, gpointer client_data)
{
  if (page != 0)
    return;

  /* For now we don't care about errors.  However, we still do the
     conversion so that bad values will end up as "0".  */
  max_file_size = atoi (gtk_entry_get_text (filesize));
  gnome_config_set_int (KEY_FILE_SIZE, max_file_size);

  concurrent_transfers = atoi (gtk_entry_get_text (transfers));
  gnome_config_set_int (KEY_TRANSFERS, concurrent_transfers);

  gnome_config_sync ();
}

static void
entry_changed (GtkWidget *widget, gpointer client_data)
{
  gnome_property_box_changed (propertybox);
}

static GtkWidget *
make_label_entry (const char *label, GtkWidget **entry_ret, const char *text)
{
  GtkWidget *hbox, *w;

  hbox = gtk_hbox_new (FALSE, GNOME_PAD);
  gtk_container_border_width (GTK_CONTAINER (hbox), GNOME_PAD_SMALL);

  w = gtk_label_new (label);
  gtk_box_pack_start (GTK_BOX (hbox), w, FALSE, FALSE, GNOME_PAD_SMALL);
  gtk_widget_show (w);

  *entry_ret = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (hbox), *entry_ret, TRUE, TRUE, GNOME_PAD_SMALL);
  gtk_widget_show (*entry_ret);
  gtk_entry_set_text (GTK_ENTRY (*entry_ret), text);

  return hbox;
}

void
show_properties ()
{
  if (! propertybox)
    {
      GtkWidget *page, *w;
      char buf[30];

      propertybox = GNOME_PROPERTY_BOX (gnome_property_box_new ());
      gnome_dialog_close_hides (GNOME_DIALOG (propertybox), TRUE);
      gtk_signal_connect (GTK_OBJECT (propertybox), "apply",
			  GTK_SIGNAL_FUNC (apply_properties), NULL);
      gtk_window_set_title (GTK_WINDOW (propertybox),
			    _("Gnome Synchronize Properties"));

      page = gtk_vbox_new (FALSE, GNOME_PAD);

      sprintf (buf, "%d", max_file_size);
      w = make_label_entry (_("Maximum in-memory file size"),
			    (GtkWidget **) &filesize, buf);
      gtk_signal_connect (GTK_OBJECT (filesize), "changed",
			  GTK_SIGNAL_FUNC (entry_changed), NULL);
      gtk_widget_show (w);
      gtk_box_pack_start (GTK_BOX (page), w, FALSE, FALSE, GNOME_PAD_SMALL);

      sprintf (buf, "%d", concurrent_transfers);
      w = make_label_entry (_("Number of concurrent transfers"),
			    (GtkWidget **) &transfers, buf);
      gtk_signal_connect (GTK_OBJECT (transfers), "changed",
			  GTK_SIGNAL_FUNC (entry_changed), NULL);
      gtk_widget_show (w);
      gtk_box_pack_start (GTK_BOX (page), w, FALSE, FALSE, GNOME_PAD_SMALL);

      gtk_notebook_append_page (GTK_NOTEBOOK (propertybox->notebook), page,
				gtk_label_new (_("Synchronize")));
      gtk_widget_show (page);
    }

  gtk_widget_show (GTK_WIDGET (propertybox));
}
