%%NAME
%%  eimage  - draw image of a matrix 
%%
%%SYNOPSIS
%%  eimage(matrix[,colorMap])
%%
%%PARAMETER(S)
%%  matrix     matrix for image 
%%             each value of the matrix is a row index of the colormap
%%  colorMap   define own colormap  
%% 
%%GLOBAL PARAMETER(S)
%%  eImageDefaultColorMap 
%%  ePlotTitleText
%%  ePlotAreaPos
%%  ePlotAreaWidth
%%  ePlotAreaHeight
%%  ePlotTitleDistance
%%  ePlotTitleFontSize
%%  ePlotTitleTextFont
%%  eImageFrameVisible
%%  eAxesLineWidth
% written by Stefan Mueller stefan.mueller@fgan.de

function eimage(matrix,colorMap)
  if  nargin >2
    usage('eimage(matrix[,colorMap])');
  end
  eglobpar;
  if nargin==0
    currentDir=pwd;
    eval(['cd ',ePath]);
    eval(['load default.img']);
    eval(['cd ',currentDir]);
    matrix=default;
    ePlotTitleText='Anna and Leah';
  end
  if nargin<2
    colorMap=ecolors(eImageDefaultColorMap); 
  end
  % write title
  if strcmp(ePlotTitleText,'')~=1
  etext(ePlotTitleText,ePlotAreaPos(1)+ePlotAreaWidth/2,...
       ePlotAreaPos(2)+ePlotAreaHeight+ePlotTitleDistance,...
       ePlotTitleFontSize,0,ePlotTitleTextFont,0); 
  end
  eimagexy(eFile,matrix,colorMap,...
           ePlotAreaPos(1)*eFac,ePlotAreaPos(2)*eFac,...
           ePlotAreaWidth*eFac,ePlotAreaHeight*eFac);
  if eImageFrameVisible
    erect(eFile,ePlotAreaPos(1)*eFac,ePlotAreaPos(2)*eFac,...
          ePlotAreaWidth*eFac,ePlotAreaHeight*eFac,eAxesLineWidth*eFac,[0 0 0]);
  end
