%%NAME
%%  eaxes - draw scaled axes around plot area
%%
%%SYNOPSIS
%%  eaxes ([xAxisSouthScale,yAxisWestScale[,xAxisNorthScale,yAxisEastScale]])
%%
%%PARAMETER(S)
%%  xAxisSouthScale   scale vector of south axis [start step end]
%%  yAxisWestScale    scale vector of west axis  [start step end]
%%  xAxisNorthScale   scale vector of north axis [start step end]
%%  yAxisEastScale    scale vector of east axis  [start step end]
%%
%%    special cases of scale vectors are:
%%      if start=0 and end=0 then autorange=on 
%%      if step=0 then autoscale=on
%%    (default scale vector=[0 0 0])
%%
%%GLOBAL PARAMETER(S)
%%  eXAxis(South|West|East|North)ValueFormat
%%  eXAxis(South|West|East|North)ValueVisible
%%  eAxesValueFontSize
%%  eAxesValueSpace
%%  eAxesLineWidth
%%  eAxesTicShortLength
%%  eAxesTicLongLength
%%  eAxesTicLongMaxN
%%  eXAxis(South|West|East|North)Scale
%%  eXAxis(South|West|East|North)ScaleType
%%  eXAxis(South|West|East|North)Visible
%%  eXAxis(South|West|East|North)ValueFormat
%%  eXAxis(South|West|East|North)ValueVisible
%%  eXAxis(South|West|East|North)LabelText
%%  eXAxis(South|West|East|North)LabelDistance
%%  ePlotAreaXValueStart
%%  ePlotAreaXValueEnd
%%  ePlotAreaYValueStart
%%  ePlotAreaYValueEnd
%%  ePlotAreaPos
%%  ePlotAreaWidth
%%  ePlotAreaHeight
%%  eAxesCrossOrigin
%%  eAxesValueFontSize
%%  eAxesLineWidth
%%  eAxesTicShortLength
%%  eAxesTicLongLength
%%  eAxesTicLongMaxN
%%  eAxesValueSpace
%%  eAxesLabelFontSize
%%  eAxesLabelTextFont
% written by Stefan Mueller stefan.mueller@fgan.de 1997

function eaxes(xAxisSouthScale,yAxisWestScale,xAxisNorthScale,yAxisEastScale)
  if nargin~=0 & nargin~=2 & nargin~=4
    usage('eaxes ([xAxisSouthScale,yAxisWestScale[,xAxisNorthScale,yAxisEastScale]])');
  end
  eglobpar;
  if nargin>0
    eXAxisSouthScale=xAxisSouthScale;
    ePlotAreaXValueStart=eXAxisSouthScale(1);
    ePlotAreaXValueEnd=eXAxisSouthScale(3);
    eYAxisWestScale=yAxisWestScale;
    ePlotAreaYValueStart=eYAxisWestScale(1);
    ePlotAreaYValueEnd=eYAxisWestScale(3);
    range=ePlotAreaXValueEnd-ePlotAreaXValueStart;
    if range==0
      range=1;
    end
    ePlotAreaXFac=ePlotAreaWidth*eFac/range;
    range=ePlotAreaYValueEnd-ePlotAreaYValueStart;
    if range==0
      range=1;
    end
    ePlotAreaYFac=ePlotAreaHeight*eFac/range;
  end
  if nargin>2
    eXAxisNorthScale=xAxisNorthScale;
    eYAxisEastScale=yAxisEastScale;
  end
  if eXAxisSouthScale(1)~=eXAxisSouthScale(3)
    ePlotAreaXValueStart=eXAxisSouthScale(1);
    ePlotAreaXValueEnd=eXAxisSouthScale(3);
  end
  if eXAxisNorthScale(1)~=eXAxisNorthScale(3)
    eXAxisNorthValueStart=eXAxisNorthScale(1);
    eXAxisNorthValueEnd=eXAxisNorthScale(3);
  else
    eXAxisNorthValueStart=ePlotAreaXValueStart;
    eXAxisNorthValueEnd=ePlotAreaXValueEnd;
    eXAxisNorthScale=eXAxisSouthScale;
    eXAxisNorthScaleType=eXAxisSouthScaleType;
  end
  if eYAxisWestScale(1)~=eYAxisWestScale(3)
    ePlotAreaYValueStart=eYAxisWestScale(1);
    ePlotAreaYValueEnd=eYAxisWestScale(3);
  end
  if eYAxisEastScale(1)~=eYAxisEastScale(3)
    eYAxisEastValueStart=eYAxisEastScale(1);
    eYAxisEastValueEnd=eYAxisEastScale(3);
  else
    eYAxisEastValueStart=ePlotAreaYValueStart;
    eYAxisEastValueEnd=ePlotAreaYValueEnd;
    eYAxisEastScale=eYAxisWestScale;
    eYAxisEastScaleType=eYAxisWestScaleType;
  end
  
  
  if sign(ePlotAreaXValueStart*ePlotAreaXValueEnd)<0 &...
     sign(ePlotAreaYValueStart*ePlotAreaYValueEnd)<0 & eAxesCrossOrigin
    eXAxisSouthVisible=1;
    eYAxisWestVisible=1;
    eXAxisNorthVisible=0;
    eYAxisEastVisible=0;
    xAxisOffset=-ePlotAreaYValueStart*ePlotAreaYFac;   
    yAxisOffset=-ePlotAreaXValueStart*ePlotAreaXFac;   
  else
    xAxisOffset=0;
    yAxisOffset=0;
  end
  % scale and draw axes
  if eXAxisSouthVisible
    if eXAxisSouthScaleType==0
      escalexy(eFile,'s',...
            ePlotAreaPos(1)*eFac,...
            ePlotAreaPos(2)*eFac,...
            -xAxisOffset,0,...
            ePlotAreaWidth*eFac,...
            ePlotAreaXValueStart,...
            eXAxisSouthScale(2),...
            ePlotAreaXValueEnd,...
            eXAxisSouthValueFormat,...
            eXAxisSouthValueVisible,...
            eAxesValueFontSize*eFac,...
            eAxesLineWidth*eFac,...
            eAxesTicShortLength*eFac,...
            eAxesTicLongLength*eFac,...
            eAxesTicLongMaxN,...
            eAxesValueSpace*eFac);
    elseif eXAxisSouthScaleType==1
      escalecl(eFile,'s',...
            ePlotAreaPos(1)*eFac,...
            ePlotAreaPos(2)*eFac,...
            -xAxisOffset,0,...
            ePlotAreaWidth*eFac,...
            ePlotAreaXValueStart,...
            eXAxisSouthScale(2),...
            ePlotAreaXValueEnd,...
            eXAxisSouthValueFormat,...
            eXAxisSouthValueVisible,...
            eAxesValueFontSize*eFac,...
            eAxesLineWidth*eFac,...
            eAxesTicLongLength*eFac,...
            eAxesTicLongMaxN,...
            eAxesValueSpace*eFac);
    end
  end
  if eXAxisNorthVisible
    if eXAxisNorthScaleType==0
      escalexy(eFile,'n',...
            ePlotAreaPos(1)*eFac,...
            (ePlotAreaPos(2)+ePlotAreaHeight)*eFac,...
            0,0,...
            ePlotAreaWidth*eFac,...
            eXAxisNorthValueStart,...
            eXAxisNorthScale(2),...
            eXAxisNorthValueEnd,...
            eXAxisNorthValueFormat,...
            eXAxisNorthValueVisible,...
            eAxesValueFontSize*eFac,...
            eAxesLineWidth*eFac,...
            eAxesTicShortLength*eFac,...
            eAxesTicLongLength*eFac,...
            eAxesTicLongMaxN,...
            eAxesValueSpace*eFac);
    elseif eXAxisNorthScaleType==1
      escalecl(eFile,'n',...
            ePlotAreaPos(1)*eFac,...
            (ePlotAreaPos(2)+ePlotAreaHeight)*eFac,...
            0,0,...
            ePlotAreaWidth*eFac,...
            eXAxisNorthValueStart,...
            eXAxisNorthScale(2),...
            eXAxisNorthValueEnd,...
            eXAxisNorthValueFormat,...
            eXAxisNorthValueVisible,...
            eAxesValueFontSize*eFac,...
            eAxesLineWidth*eFac,...
            eAxesTicLongLength*eFac,...
            eAxesTicLongMaxN,...
            eAxesValueSpace*eFac);
    end
  end
  if eYAxisWestVisible
    if eYAxisWestScaleType==0
      escalexy(eFile,'w',...
            ePlotAreaPos(1)*eFac,...
            ePlotAreaPos(2)*eFac,...
            -yAxisOffset,0,...
            ePlotAreaHeight*eFac,...
            ePlotAreaYValueStart,...
            eYAxisWestScale(2),...
            ePlotAreaYValueEnd,...
            eYAxisWestValueFormat,...
            eYAxisWestValueVisible,...
            eAxesValueFontSize*eFac,...
            eAxesLineWidth*eFac,...
            eAxesTicShortLength*eFac,...
            eAxesTicLongLength*eFac,...
            eAxesTicLongMaxN,...
            eAxesValueSpace*eFac);
    elseif eYAxisWestScaleType==1
      escalecl(eFile,'w',...
            ePlotAreaPos(1)*eFac,...
            ePlotAreaPos(2)*eFac,...
            -yAxisOffset,0,...
            ePlotAreaHeight*eFac,...
            ePlotAreaYValueStart,...
            eYAxisWestScale(2),...
            ePlotAreaYValueEnd,...
            eYAxisWestValueFormat,...
            eYAxisWestValueVisible,...
            eAxesValueFontSize*eFac,...
            eAxesLineWidth*eFac,...
            eAxesTicLongLength*eFac,...
            eAxesTicLongMaxN,...
            eAxesValueSpace*eFac);
    end
  end
  if eYAxisEastVisible
    if eYAxisEastScaleType==0
      escalexy(eFile,'e',...
            (ePlotAreaPos(1)+ePlotAreaWidth)*eFac,...
            ePlotAreaPos(2)*eFac,...
            0,0,...
            ePlotAreaHeight*eFac,...
            eYAxisEastValueStart,...
            eYAxisEastScale(2),...
            eYAxisEastValueEnd,...
            eYAxisEastValueFormat,...
            eYAxisEastValueVisible,...
            eAxesValueFontSize*eFac,...
            eAxesLineWidth*eFac,...
            eAxesTicShortLength*eFac,...
            eAxesTicLongLength*eFac,...
            eAxesTicLongMaxN,...
            eAxesValueSpace*eFac);
    elseif eYAxisEastScaleType==1
      escalecl(eFile,'e',...
            (ePlotAreaPos(1)+ePlotAreaWidth)*eFac,...
            ePlotAreaPos(2)*eFac,...
            0,0,...
            ePlotAreaHeight*eFac,...
            eYAxisEastValueStart,...
            eYAxisEastScale(2),...
            eYAxisEastValueEnd,...
            eYAxisEastValueFormat,...
            eYAxisEastValueVisible,...
            eAxesValueFontSize*eFac,...
            eAxesLineWidth*eFac,...
            eAxesTicLongLength*eFac,...
            eAxesTicLongMaxN,...
            eAxesValueSpace*eFac);
    end
  end

  %print labels
  scaleSpace=eAxesTicLongLength+eAxesValueSpace+eAxesValueFontSize;
  if strcmp(eXAxisSouthLabelText,'')~=1
    etext(eXAxisSouthLabelText,...
          ePlotAreaPos(1)+ePlotAreaWidth/2,...
          ePlotAreaPos(2)-scaleSpace-...
          eAxesLabelFontSize*0.72-eXAxisSouthLabelDistance,...
          eAxesLabelFontSize,0,eAxesLabelTextFont,0);
  end
  if strcmp(eXAxisNorthLabelText,'')~=1
    etext(eXAxisNorthLabelText,...
          ePlotAreaPos(1)+ePlotAreaWidth/2,...
          ePlotAreaPos(2)+ePlotAreaHeight+...
          scaleSpace+eXAxisNorthLabelDistance,...
          eAxesLabelFontSize,0,eAxesLabelTextFont,0);
  end
  if strcmp(eYAxisWestLabelText,'')~=1
    etext(eYAxisWestLabelText,...
          ePlotAreaPos(1)-scaleSpace-eYAxisWestLabelDistance,...
          ePlotAreaPos(2)+ePlotAreaHeight/2,...
          eAxesLabelFontSize,0,eAxesLabelTextFont,90);
  end
  if strcmp(eYAxisEastLabelText,'')~=1
    etext(eYAxisEastLabelText,...
          ePlotAreaPos(1)+ePlotAreaWidth+scaleSpace+...
          eAxesLabelFontSize/2+eYAxisEastLabelDistance,...
          ePlotAreaPos(2)+ePlotAreaHeight/2,...
          eAxesLabelFontSize,0,eAxesLabelTextFont,90);
  end
