/*								-*- C++ -*-
 * $Id: WIN_item.h,v 1.2 1997-01-15 14:58:00+01 mho Exp $
 *
 * Purpose: base class for all panel items
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef Item_h
#define Item_h

#ifdef __GNUG__
#pragma interface
#endif

class wxCommandEvent;
class wxColour;
class wxFont;
class wxPanel;

class wxItem : public wxWindow {
DECLARE_DYNAMIC_CLASS(wxItem)
public:
    wxItem(void);

    // chain panel<->item, copy colours, fonts, and style
    void ChainToPanel(wxPanel *parent, long style=0, Constdata char *name=NULL);
    // change colours and fonts
    virtual void      ChangeColours(void);
    virtual wxColour  *GetButtonColour(void)  { return GetForegroundColour(); }
    virtual wxFont    *GetButtonFont(void)    { return GetFont(); }
    virtual wxColour  *GetLabelColour(void)   { return &label_fg; }
    virtual wxFont    *GetLabelFont(void)     { return &label_font; }
    virtual void      SetButtonColour(wxColour &col) { SetForegroundColour(col); }
    virtual void      SetButtonFont(wxFont *font)    { SetFont(font); }
    virtual void      SetLabelColour(wxColour &col);
    virtual void      SetLabelFont(wxFont *font);
    // functions to execute item
            void Callback(wxFunction func);
    virtual void Command(wxCommandEvent &event);
            void ProcessCommand(wxCommandEvent &event);
    // event handling for user edit mode
    virtual void OnEvent(wxMouseEvent& event);
    virtual void OnMove(int x, int y);
    virtual void OnSize(int w, int h);
    virtual void OnLeftClick(int x, int y, int keys);
    virtual void OnRightClick(int x, int y, int keys);
    virtual void OnSelect(Bool select);
    // selection handles
    void CalcSelectionHandles(int *hx, int *hy);
    void DrawSelectionHandles(Bool erase=FALSE) { DrawSelectionHandles(NULL, erase); }
    void DrawSelectionHandles(wxPanelDC *dc, Bool erase=FALSE);
    int  SelectionHandleHitTest(int x, int y);
    // label positioning
    int  GetLabelPosition(void);
    void SetLabelPosition(int pos);
    void SetAppropriateLabelPosition(void); // style flag to label position
protected:
    void TravNext (wxEvent* event);
    void TravPrev (wxEvent* event);
    void TravHome (wxEvent* event);
    void TravUp   (wxEvent* event);
    void TravDown (wxEvent* event);
    void TravLeft (wxEvent* event);
    void TravRight(wxEvent* event);
protected:
    friend class wxPanel;

    wxFunction callback;
    wxColour   label_fg;
    wxFont     label_font;
    int        label_position;
};

#endif // Item_h
