/*								-*- C++ -*-
 * $Id: GDI_colour.h,v 1.3 1998/08/10 15:44:06 wmglo Exp $
 *
 * Purpose: classes to cover colours and colourmaps
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef Colour_h
#define Colour_h

#ifdef __GNUG__
#pragma interface
#endif

class wxColourRep;
class wxColourMapRep;

class wxColourMap;

class wxColour : public wxObject { // colour representation
DECLARE_DYNAMIC_CLASS(wxColour)
public:
    wxColour(void);
    wxColour(unsigned char r, unsigned char g, unsigned char b);
    wxColour(wxColour& col);
    wxColour(const char *col);
    ~wxColour(void);

    wxColour& operator = (const wxColour& src);
    void      operator = (const wxColour* src);
    wxColour& operator = (const char *src);

    Bool Ok(void) { return (rep!=NULL); }

    void Get(unsigned char *r, unsigned char *b, unsigned char *g);
    void Set(unsigned char r, unsigned char b, unsigned char g);

    unsigned char Red(void);
    unsigned char Green(void);
    unsigned char Blue(void);

    // alloc X pixel value
#ifdef Have_X_Types
    unsigned long GetPixel(wxColourMap* cmap=wxAPP_COLOURMAP);
#endif
private:
    // free X pixel value
    void FreePixel(Bool free_pixel_only);

    friend wxColourMap;

    wxColourRep* rep; // the encapsulated X representation
};

class wxColourMap : public wxObject { // colourmap representation
DECLARE_DYNAMIC_CLASS(wxColourMap)
public:
    wxColourMap(Bool priv=FALSE);
    wxColourMap(wxColourMap& new_cmap);
    ~wxColourMap(void);

    wxColorMap& operator = (wxColourMap& new_cmap);

    Bool Ok(void) { return (rep!=NULL); }

    Bool IsPrivate(void);
    Bool Create(const int n, const unsigned char *red,
		const unsigned char *green, const unsigned char *blue,
		Bool priv=FALSE);
    enum { wxORDER_RGB = 0, wxORDER_BGR = 0x1000 };
    // Transfer a `raw' 8bit-Bitmap through the colourmap.  For
    // bpp==24, the bpp parameter needs to be ORed with an appropriate
    // wxORDER flag (wxORDER_RGB is the default).
    Bool TransferBitmap8(unsigned char *data, unsigned long size,
			 void *dest, unsigned int bpp);
    Bool TransferBitmap8Fast(const unsigned char *data, unsigned long size,
			     void *dest, unsigned int bpp);
#ifdef Have_X_Types
    Colormap GetColormap(void);
#endif
private:
    void DeleteColormap(void);

    wxColourMapRep* rep; // the encapsulated X representation
};

class wxColourDatabase : public wxList { // colour database representation
DECLARE_DYNAMIC_CLASS(wxColourDatabase)
public:
    wxColourDatabase(void);
    ~wxColourDatabase(void);

    wxColour *FindColour(const char *colour);
    wxColour *FindColour(unsigned char r, unsigned char g, unsigned char b,
			 const char *colour);
    char *FindName(wxColour& colour);
};

#endif // Colour_h
