/*								-*- C++ -*-
 * $Id: WIN_dialogbox.cpp,v 1.1 1996-09-25 11:32:11+02 mho Exp $
 *
 * Purpose: dialog box
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "WIN_dialogbox.h"
#endif

#define  Uses_XtIntrinsic
#define  Uses_wxDialogBox
#define  Uses_wxList
#include "wx.h"

IMPLEMENT_DYNAMIC_CLASS(wxDialogBox, wxFrame)

//-----------------------------------------------------------------------------
// create dialog box (frame with modal attribute)
//-----------------------------------------------------------------------------

wxDialogBox::wxDialogBox(void) : wxFrame()
{
    __type = wxTYPE_DIALOG_BOX;

    // adjust panel placement variables
    h_margin = 2 * PANEL_HMARGIN;
    v_margin = 2 * PANEL_VMARGIN;
}

wxDialogBox::wxDialogBox(wxWindow *parent, Const char *title, Bool modal, int x,
			 int y, int width, int height, long style, Constdata char *name)
    : wxFrame()
{
    __type = wxTYPE_DIALOG_BOX;

    // adjust panel placement variables
    h_margin = 2 * PANEL_HMARGIN;
    v_margin = 2 * PANEL_VMARGIN;

    Create(parent, title, modal, x, y, width, height, style, name);
}

Bool wxDialogBox::Create(wxWindow *parent, Const char *title, Bool modal, int x,
			 int y, int width, int height, long style, Constdata char *name)
{
    if (parent && !parent->IsKindOf(CLASSINFO(wxFrame)))
	wxFatalError("parent has to be a wxFrame or any subtype", "wxDialogBox");

    (void)wxFrame::Create((wxFrame*)parent, title, x, y, width, height, style, name);

    // store if dialog should be modal
    SetModal(modal);
    // Initialize PanelDC
    if (!(style & wxNO_DC)) {
	CreateDC();
    }
    return TRUE;
}
