/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.14 of 01-November-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * help.h --- declarations for FORTH online help utilities.
 * (duz 13Sep94)
 */

#ifndef __HELP_H
#define __HELP_H

#include <limits.h>


typedef struct Hheader HHeader;	/* index file header */
typedef struct Hrecord HRecord;	/* record in index file */

struct Hheader
{
  char magic [4];		/* magic number */
  int nfiles;			/* how many help files are gathered */
  int nitems;			/* total items in this index */
};

struct Hrecord
{
  char name [32];		/* name of the definition */
  int fidx;			/* index of file, see head */
  long pos;			/* position in file */
};

extern char *progname;

void fatal (const char *msg, ...);
void sys_error (void);
void file_errorz (const char *fn);
void read_help_index (const char *pn, const char *fn);
void print_help (const char *name);

#if defined STANDALONE
void *xalloc (size_t size);
#endif

#endif
