
#ifndef _COOL_ICON_H
#define _COOL_ICON_H

#include <X11/xpm.h>
#include <X11/extensions/shape.h>

typedef struct icon_struct {
    CWidget *w;
    Pixmap mask, picture;
    XpmAttributes attributes;
    char *xpm_filename;		/* the name of the .xpm picture file */
    char *title;		/* the text below the picture */
} CIcon;

CWidget *CDrawIcon (const char *identifier, Window parent, int x, int y, const char *filename, char *title);

void convert_array_to_commalist (char **a, char **mime_majors);
void convert_commalist_to_array (char *mime_majors, char ***a);

/* hooked onto CWidget->user */
typedef struct power_icon_struct {
    char *title;		/* discription below the picture */
    char *xpm_filename;		/* xpm file */
    int x, y;			/* positions */
    time_t last_expose;		/* time of last expose - used to ensure that lower on expose does no repeat */
    char *prompt;		/* prompt for to enter a string to pass to the 
				   script or NULL */
    char *confirm;		/* prompt message for confirmation or NULL */
    int options;
    char *drop_script;		/* script to run on recieving a drop */
    char *double_click_script;	/* script to run on recieving a double click */
    char *tool_hint;
    char **mime_majors;		/* major mime types supported for dropping like `text' `video' etc. */
} CPowerIcon;

struct drop {
    unsigned char *data;
    int size;
    char *atom_name;
    char *ident;
};

void execute_icon_drop (CWidget *w, CPowerIcon * icon, char *drop_data, int dnd_len, char *dnd_mime_type);

#define ICON_OPTION_CONFIRM_DOUBLE_CLICK	(1<<0)
#define ICON_OPTION_PROMPT_DOUBLE_CLICK		(1<<1)
#define ICON_OPTION_CONFIRM_DROP		(1<<2)
#define ICON_OPTION_PROMPT_DROP			(1<<3)

#endif

