#
# $Id: tkcvs_def.tcl,v 1.15.4.15 1999/10/15 06:14:32 dorothyr Exp $
#
# tkCVS defaults file.
#
# This file is read by tkCVS on startup.  It will be installed
# automatically by the "configure" script.
#
# Defaults in the .tkcvs file in the user's home directory will
# over-ride this file.
#

# Print setup.
set cvscfg(papersize) "A4"
set cvscfg(pointsize) 9
set cvscfg(headingsize) 14
set cvscfg(subheadingsize) 12

# If you want the module browser to come up on startup, uncomment this.
#set cvscfg(startwindow) "module"

# Colours.  "Colors" that is if you are a yanqui who can't spell.
# Added support for monochrome machines. -sj
if { [winfo depth .] == 1 } {

    set cvscfg(glb_background)      "white"
    set cvscfg(glb_highlight)       "black"
    set cvscfg(bt_lookhere)         "white"
    set cvscfg(bt_pressme)          "black"
    set cvscfg(tool_color)          "white"

} else {

    # These colours are entered into the options database, see below.
    set cvscfg(glb_background)      "SkyBlue2"
    set cvscfg(glb_highlight)       "green"
    set cvscfg(bt_lookhere)         "LightSteelBlue"
    set cvscfg(bt_pressme)          "green"

    # This is the colour of the ToolTips popup windows.
    set cvscfg(tool_color)          "LightGoldenrod1"

    # These colours are used to support tag marking.
    set cvscfg(tagcolour,tkcvs_r6)  "Purple"
    set cvscfg(tagcolour,tkcvs_r5)  "Blue"
    set cvscfg(tagcolour,tkcvs_r4)  "Green"
    set cvscfg(tagcolour,tkcvs_r3)  "Yellow"
    set cvscfg(tagcolour,tkcvs_r2)  "Orange"
    set cvscfg(tagcolour,tkcvs_r1)  "Red"

}

#
# If you want to configure the colours via the above options,
# then you will also need to un-comment these lines.  Otherwise
# you can use the Xdefaults method of colouring the windows.
#
# option add *background                 $cvscfg(glb_background)
# option add *activeBackground           $cvscfg(glb_highlight)
# option add *Button.background          $cvscfg(bt_lookhere)
# option add *Button.activeBackground    $cvscfg(bt_pressme)
# option add *Scrollbar.foreground       $cvscfg(bt_lookhere)
# option add *Scrollbar.activeForeground $cvscfg(bt_pressme)
#
# To use the Xdefaults method, put lines like the following into
# your .Xdefaults or .Xresources file:
#
# tkcvs*background:			SkyBlue2
# tkcvs*activeBackground:		green
# tkcvs*Button.background:		LightSteelBlue
# tkcvs*Button.activeBackground:	green
# tkcvs*Scrollbar.background:		LightSteelBlue
# tkcvs*Scrollbar.activeBackground:	green

# Leave this option here so that tkCVS knows what its own background
# colour is.  This is so that it can erase things like file mark dots.
set cvscfg(glb_background) [option get . background Background]

#
# Other defaults
#

#
# Set this to 1 to see all files displayed in the directory
# browser (including hidden files) by default.
#
set cvscfg(allfiles)           0

#
# set the default log file detail to be reported; one of 
#   "last"       report only the comment from the last checkin
#   "summary"    version number and comment string for all check-ins
#   "verbose"    all logfile detail possible, including symbolic tags
# -sj
set cvscfg(ldetail)            "last"

# --------------------
# set the default detail for repository and workdir reports; one of
#   "terse"      report "status" only and only on those files which 
#                are not "up-to-date"
#   "summary"    report the "status" and include "up-to-date"
#   "verbose"    provide the report as it would appear unmodified
# -sj
set cvscfg(rdetail)            "terse"

# --------------------
# set the number of file names the listbox should accomodate. 
# -sj
set cvscfg(y_size)             24

# --------------------
# set the default pattern to be used by the filter.  Use any valid
# pattern that can be used for a pattern for 'ls'. An empty string
# is equilivant to the entire directory (minus hidden files); 
# i.e., ls *
# -sj
#set cvscfg(file_filter)        "*.ad? *.a"
#set cvscfg(file_filter)        "*.[ch] *.[CH]"
set cvscfg(file_filter)        ""
set cvscfg(ignore_file_filter) "*.a *.o *~"

# --------------------
# set the default for automatic statusing of a CVS controlled 
# directory.  Automatic updates are done when a directory is 
# entered and after some operations.  More operations should cause
# an automatic update ... TBD.
# -sj
set cvscfg(auto_status)        "true"

# --------------------
# set the command to be used to format selected files.
# e.g., "aimap" is a formatter for Ada code.
# -sj
set cvscfg(format_cmd)         "aimap"

# --------------------
# set the pattern to be used for cleaning a directory; i.e., the
# removal of unwanted files.  Typically these files are not under CVS.
# -sj
set cvscfg(clean_these)        "\*.bak \*~ \*tmp tmp\* #\* \*%"

# --------------------
# set the default value for confirmation prompting before performing an
# operation over selected files.
# -sj
set cvscfg(confirm_prompt)     "true"

# I moved setting cvscfg(cvsroot) to env(CVSROOT) to the main program,
# because we can run without it and I don't want an if [info exists] here.
# -dr

# --------------------
# some of the reporting operations could usefully be recursive.  Set
# the default value here.
# -sj
set cvscfg(recurse)            "false"


#
# This determines what sort of buttons you get on the main window, and
# whether you get ToolTips with your buttons or not.
#
# Small bitmap buttons with pop-up tooltips.
set cvscfg(buttonstyle) "Bitmap"
set TOOLTIPS_OFF 0
#
# Big text buttons without pop-up tooltips.
#set cvscfg(buttonstyle) "Text"
#set TOOLTIPS_OFF 1

# Dos specific.
#
# Decide wether you are unlucky and have to run tkcvs on DOS/WIN
# some things will be setup in the following
#
# Please note that you have to setup a bit more.
# The "rm" command is just an example. You are at your own...
if {$tcl_platform(platform) == "windows"} {
    # write awk commands into a file, read over "awk -f file"
    set cvscfg(awkCmdOverFile) 1
    # set temp directory
    set cvscfg(tmpdir) "/tmp"
    # cvs-dos doesn't like the dot "." in some sub-commands
    set cvscfg(no_dot) 1
    # file mask for all files
    set cvscfg(aster) "*.*"
    # null-device
    set cvscfg(null) "nul"
    #
    # Please don't ask me why you have to set -T on DOS,
    # experiments say you have! - CJ
    #
    #set cvs "cvs -T $cvscfg(tmpdir)"
    set cvs "cvs"
    #
    # Accessing SAMBA exported drives as local repository will create only
    # lower case names (may be only our installation), to prevent the
    # CVS-dirs to be handled as normal directories:
    #
    set cvscfg(cvsdir) "cvs"
    set cvscfg(editor) "notepad"
    set cvscfg(tkdiff) "sh /usr/local/bin/tkdiff"
    # What do you want to happen when you ask for a shell?
    set cvscfg(shell) "start C:/cygnus/cygwin-b20/cygnus.bat"
    #set cvscfg(shell) "start C:/windows/command/command.com"
} else {
    set cvscfg(awkCmdOverFile) 0
    set cvscfg(tmpdir) "/var/tmp"
    set cvscfg(no_dot) 0
    set cvscfg(aster) "*"
    set cvscfg(null) "/dev/null"
    #
    # Other defaults
    #
    # Full path to the CVS program if you want to give it,
    # otherwise the PATH environment variable will be searched.
    #
    set cvs "cvs"
    set cvscfg(cvsdir) "CVS"
    # To override the default editor (setup when tkcvs is configured and 
    # installed) a user can set the cvscfg(editor) variable to the editor
    # of choice in their .tkcvs file (if they have one).
    #set cvscfg(editor) "dtpad"
    set cvscfg(editor) "xterm -e vi"
    set cvscfg(tkdiff) "tkdiff"
    # What do you want to happen when you ask for a shell?
    set cvscfg(shell) "xterm -name tkcvsxterm -n {tkCVS xterm}"
}

#
#
# determine which remove command is to be used.  Also set
# any flags that are to be used when the remove command is
# invoked.
# -sj
set cvscfg(rm_cmd)             "/bin/rm"
set cvscfg(rm_flags)           "-rf"
#
# set the default command for printing output.
#set cvscfg(print_cmd)          "enscript -Ghr -fCourier8"
set cvscfg(print_cmd)          "lpr"
#
# What's your awk command?
set cvscfg(awk) "awk"

# --------------------
# User Menus
#
# Set any of these strings to a cvs command that you want to run.
set cvsmenu(Update_to_Head) "update -A"
# set cvsmenu(status) "status"

# Set any of these strings to a non-cvs command that you want to run.
#set usermenu(Remove_Backup_Files) "$cvscfg(rm_cmd) $cvscfg(clean_these)"
# set usermenu(delete) "rm"
# set usermenu(view) "cat"
# sckick Added a menu item so that tkdiff can be used to
# resolve merges
set usermenu(Merge_Conflicts) "$cvscfg(tkdiff) -conflict "
