/*	$Id: lexer.l,v 1.2 1997/07/17 18:07:56 sandro Exp $	*/

/*
 * Copyright (c) 1997
 *	Sandro Sigala, Brescia, Italy.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

Digit		[0-9]
Literal		[a-zA-Z\\\$\.]
Exp		[Ee][+-]?{Digit}+

%{
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <err.h>

#include "parser.h"

static void comment(void);
static void skip_until_eol(void);

static int yywrap(void) { return 1; }

int lineno;
%}

%%

"/*"					{ comment(); }
"//"					{ skip_until_eol(); }
"#"					{ skip_until_eol(); }

"assign"				{ return ASSIGN; }
"case"					{ return CASE; }
"declare"				{ return DECLARE; }
"default"				{ return DEFAULT; }
"do"					{ return DO; }
"else"					{ return ELSE; }
"for"					{ return FOR; }
"if"					{ return IF; }
"switch"				{ return SWITCH; }
"while"					{ return WHILE; }

{Literal}+				{ return IDENTIFIER; }

{Digit}+				{ return CONSTANT; }
{Digit}*\.{Digit}+({Exp})?		{ return CONSTANT; }
{Digit}+\.?{Digit}*({Exp})?		{ return CONSTANT; }

\'[^']*\'				{ return CONST_QUOTED; }
\`[^`]*\`				{ return CONST_RPN; }
\"[^"]*\"				{ return CONST_STRING; }
"@<<"(.)*">>"				{ return CONST_RPN_PROG; }
"@["					{ return HP_OBRACKET; }
"@]"					{ return HP_CBRACKET; }
"@{"					{ return HP_OBRACE; }
"@}"					{ return HP_CBRACE; }
"@("					{ return HP_OPAREN; }
"@)"					{ return HP_CPAREN; }

">>="					{ return SR_ASSIGN; }
"<<="					{ return SL_ASSIGN; }
"+="					{ return SUM_ASSIGN; }
"-="					{ return SUB_ASSIGN; }
"*="					{ return MUL_ASSIGN; }
"/="					{ return DIV_ASSIGN; }
"%="					{ return MOD_ASSIGN; }
"&="					{ return AND_ASSIGN; }
"^="					{ return XOR_ASSIGN; }
"|="					{ return OR_ASSIGN; }
">>"					{ return SR; }
"<<"					{ return SL; }
"++"					{ return INC; }
"--"					{ return DEC; }
"&&"					{ return LOG_AND; }
"||"					{ return LOG_OR; }
"<="					{ return LE; }
">="					{ return GE; }
"=="					{ return EQ; }
"!="					{ return NE; }

\n					{ lineno++; }
[ \t\v\f]				{ /* Skip whitespace. */ }
.					{ return yytext[0]; }

%%

static void
comment(void)
{
	int c;

	while ((c = input()) != EOF) {
	resync:
		if (c == '\n')
			lineno++;
		else if (c == '*')
			if ((c = input()) == '/')
				return;
			else
				goto resync;
	}
}

static void
skip_until_eol(void)
{
	int c;

	while ((c = input()) != EOF && c != '\n')
	       ;

	lineno++;
}
