/*
 * trs_wide_chars.c
 *
 * This file contains the bitmap data for all 256 characters in the
 * TRS-80 character set, for both Model I and Model III/4.  Thanks to
 * Al Petrofsky for supplying some of the data in .bdf format.  Thanks
 * to Todd P. Cromwell III for supplying exact dumps of two different
 * Model III character generator ROMs.
 */

#include "trs_iodefs.h"

char trs_widechar_data[][MAXCHARS][TRS_CHAR_HEIGHT][2] = {

{
/* CG 0 - for Model I */
/* Source: MCM6674 Data Sheet */
/* This is a very old version of the Model I font, found in only a few
   machines, that has standard ASCII [ \ ] ^ instead of directional arrows.
   It also has odd symbols in positions 0-31, and the lowercase letters with
   descenders (plus 'a') are raised. Level II Basic put the odd symbols
   on the screen instead of uppercase if you did a homebrew lowercase
   conversion and did not replace the CG.
*/
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xfc,0x03,0xfc,0x03,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0xcf,0x03,0xcf,0x03,0x33,0x03,0x33,0x03,0xcf,0x03,0xcf,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x33,0x00,0x33,0x00,0x0f,0x00,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcf,0x03,0xcf,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0xff,0x00,0xff,0x00,0x0c,0x03,0x0c,0x03,0x30,0x03,0x30,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xff,0x03,0xff,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x33,0x03,0x33,0x03,0xfc,0x00,0xfc,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x33,0x03,0x33,0x03,0xfc,0x00,0xfc,0x00,0x30,0x00,0x30,0x00,0x33,0x03,0x33,0x03,0xfc,0x00,0xfc,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0xff,0x03,0xff,0x03,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0xcf,0x03,0xcf,0x03,0x33,0x03,0x33,0x03,0xcf,0x03,0xcf,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x33,0x03,0x33,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0xf3,0x03,0xf3,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xf3,0x03,0xf3,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x3f,0x03,0x3f,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x3f,0x03,0x3f,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x03,0x30,0x03,0xc0,0x00,0xc0,0x00,0x33,0x03,0x33,0x03,0x0f,0x00,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcf,0x03,0xcf,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xff,0x03,0xff,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,0xcc,0x00,0xcc,0x00,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,0xfc,0x00,0xfc,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x3f,0x03,0x3f,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x3f,0x03,0x3f,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xf3,0x03,0xf3,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0xf3,0x03,0xf3,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xff,0x03,0xff,0x03,0xcc,0x00,0xcc,0x00,0xff,0x03,0xff,0x03,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xfc,0x03,0xfc,0x03,0x33,0x00,0x33,0x00,0xfc,0x00,0xfc,0x00,0x30,0x03,0x30,0x03,0xff,0x00,0xff,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x03,0x0f,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0xc3,0x03,0xc3,0x03,0xc0,0x03,0xc0,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x0c,0x00,0x0c,0x00,0x33,0x03,0x33,0x03,0xc3,0x00,0xc3,0x00,0x3c,0x03,0x3c,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x33,0x03,0x33,0x03,0xfc,0x00,0xfc,0x00,0xff,0x03,0xff,0x03,0xfc,0x00,0xfc,0x00,0x33,0x03,0x33,0x03,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xff,0x03,0xff,0x03,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0xc3,0x03,0xc3,0x03,0x33,0x03,0x33,0x03,0x0f,0x03,0x0f,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x3c,0x00,0x3c,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0x03,0xfc,0x00,0xfc,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0x03,0xf0,0x00,0xf0,0x00,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0xf0,0x00,0xf0,0x00,0xcc,0x00,0xcc,0x00,0xc3,0x00,0xc3,0x00,0xff,0x03,0xff,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x03,0x00,0x03,0x00,0xff,0x00,0xff,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0xff,0x00,0xff,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x03,0xfc,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x3c,0x00,0x3c,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0x03,0x3c,0x03,0x3c,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xcc,0x00,0xcc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0xfc,0x00,0xfc,0x00,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0xff,0x00,0xff,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0xff,0x00,0xff,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x3f,0x00,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x3f,0x00,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xc3,0x03,0xc3,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x03,0xfc,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0xc3,0x00,0xc3,0x00,0x33,0x00,0x33,0x00,0x0f,0x00,0x0f,0x00,0x33,0x00,0x33,0x00,0xc3,0x00,0xc3,0x00,0x03,0x03,0x03,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0xcf,0x03,0xcf,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x0f,0x03,0x0f,0x03,0x33,0x03,0x33,0x03,0xc3,0x03,0xc3,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x00,0xff,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x33,0x03,0x33,0x03,0xc3,0x00,0xc3,0x00,0x3c,0x03,0x3c,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x00,0xff,0x00,0x33,0x00,0x33,0x00,0xc3,0x00,0xc3,0x00,0x03,0x03,0x03,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0xfc,0x00,0xfc,0x00,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x33,0x03,0x33,0x03,0xcf,0x03,0xcf,0x03,0x03,0x03,0x03,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,0xcc,0x00,0xcc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xcc,0x00,0xcc,0x00,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x00,0x03,0x00,0x03,0xfc,0x03,0xfc,0x03,0x03,0x03,0x03,0x03,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xf3,0x00,0xf3,0x00,0x0f,0x03,0x0f,0x03,0x03,0x03,0x03,0x03,0x0f,0x03,0x0f,0x03,0xf3,0x00,0xf3,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x3c,0x03,0x3c,0x03,0xc3,0x03,0xc3,0x03,0x03,0x03,0x03,0x03,0xc3,0x03,0xc3,0x03,0x3c,0x03,0x3c,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,0x03,0x00,0x03,0x00,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x30,0x03,0x30,0x03,0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x03,0x3c,0x03,0xc3,0x03,0xc3,0x03,0xc3,0x03,0xc3,0x03,0x3c,0x03,0x3c,0x03,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xf3,0x00,0xf3,0x00,0x0f,0x03,0x0f,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xc3,0x00,0xc3,0x00,0x33,0x00,0x33,0x00,0x0f,0x00,0x0f,0x00,0x33,0x00,0x33,0x00,0xc3,0x00,0xc3,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcf,0x00,0xcf,0x00,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf3,0x00,0xf3,0x00,0x0f,0x03,0x0f,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf3,0x00,0xf3,0x00,0x0f,0x03,0x0f,0x03,0x03,0x03,0x03,0x03,0x0f,0x03,0x0f,0x03,0xf3,0x00,0xf3,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x03,0x3c,0x03,0xc3,0x03,0xc3,0x03,0x03,0x03,0x03,0x03,0xc3,0x03,0xc3,0x03,0x3c,0x03,0x3c,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf3,0x00,0xf3,0x00,0x0f,0x03,0x0f,0x03,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x03,0x00,0x03,0x00,0xfc,0x00,0xfc,0x00,0x00,0x03,0x00,0x03,0xff,0x00,0xff,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xff,0x03,0xff,0x03,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x03,0x30,0x03,0xc0,0x00,0xc0,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xc3,0x03,0xc3,0x03,0x3c,0x03,0x3c,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0xcc,0x00,0xcc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,0xcc,0x00,0xcc,0x00,0x03,0x03,0x03,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x03,0xfc,0x03,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x33,0x03,0x33,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xcc,0x00,0xcc,0x00,0x33,0x03,0x33,0x03,0xcc,0x00,0xcc,0x00,0x33,0x03,0x33,0x03,0xcc,0x00,0xcc,0x00,0x33,0x03,0x33,0x03,0xcc,0x00,0xcc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
},

{
/* CG 1 - for Model I */
/* Source: MCM6674 Data Sheet, modified by mann (from memory) to add arrows. */
/* This is the standard Model I character generator found in machines
   without the Radio Shack lower case modification, including the arrows.
   It has odd symbols in positions 0-31, and lowercase letters with
   descenders (plus 'a') are raised. Level II Basic put the odd symbols
   on the screen if you did a homebrew lowercase conversion and did not
   replace the CG.
*/
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xfc,0x03,0xfc,0x03,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0xcf,0x03,0xcf,0x03,0x33,0x03,0x33,0x03,0xcf,0x03,0xcf,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x33,0x00,0x33,0x00,0x0f,0x00,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcf,0x03,0xcf,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0xff,0x00,0xff,0x00,0x0c,0x03,0x0c,0x03,0x30,0x03,0x30,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xff,0x03,0xff,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x33,0x03,0x33,0x03,0xfc,0x00,0xfc,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x33,0x03,0x33,0x03,0xfc,0x00,0xfc,0x00,0x30,0x00,0x30,0x00,0x33,0x03,0x33,0x03,0xfc,0x00,0xfc,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0xff,0x03,0xff,0x03,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0xcf,0x03,0xcf,0x03,0x33,0x03,0x33,0x03,0xcf,0x03,0xcf,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x33,0x03,0x33,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0xf3,0x03,0xf3,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xf3,0x03,0xf3,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x3f,0x03,0x3f,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x3f,0x03,0x3f,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x03,0x30,0x03,0xc0,0x00,0xc0,0x00,0x33,0x03,0x33,0x03,0x0f,0x00,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcf,0x03,0xcf,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xff,0x03,0xff,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,0xcc,0x00,0xcc,0x00,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,0xfc,0x00,0xfc,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x3f,0x03,0x3f,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x3f,0x03,0x3f,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xf3,0x03,0xf3,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0xf3,0x03,0xf3,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xff,0x03,0xff,0x03,0xcc,0x00,0xcc,0x00,0xff,0x03,0xff,0x03,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xfc,0x03,0xfc,0x03,0x33,0x00,0x33,0x00,0xfc,0x00,0xfc,0x00,0x30,0x03,0x30,0x03,0xff,0x00,0xff,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x03,0x0f,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0xc3,0x03,0xc3,0x03,0xc0,0x03,0xc0,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x0c,0x00,0x0c,0x00,0x33,0x03,0x33,0x03,0xc3,0x00,0xc3,0x00,0x3c,0x03,0x3c,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x33,0x03,0x33,0x03,0xfc,0x00,0xfc,0x00,0xff,0x03,0xff,0x03,0xfc,0x00,0xfc,0x00,0x33,0x03,0x33,0x03,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xff,0x03,0xff,0x03,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0xc3,0x03,0xc3,0x03,0x33,0x03,0x33,0x03,0x0f,0x03,0x0f,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x3c,0x00,0x3c,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0x03,0xfc,0x00,0xfc,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0x03,0xf0,0x00,0xf0,0x00,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0xf0,0x00,0xf0,0x00,0xcc,0x00,0xcc,0x00,0xc3,0x00,0xc3,0x00,0xff,0x03,0xff,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x03,0x00,0x03,0x00,0xff,0x00,0xff,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0xff,0x00,0xff,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x03,0xfc,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x3c,0x00,0x3c,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0x03,0x3c,0x03,0x3c,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xcc,0x00,0xcc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0xfc,0x00,0xfc,0x00,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0xff,0x00,0xff,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0xff,0x00,0xff,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x3f,0x00,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x3f,0x00,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xc3,0x03,0xc3,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x03,0xfc,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0xc3,0x00,0xc3,0x00,0x33,0x00,0x33,0x00,0x0f,0x00,0x0f,0x00,0x33,0x00,0x33,0x00,0xc3,0x00,0xc3,0x00,0x03,0x03,0x03,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0xcf,0x03,0xcf,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x0f,0x03,0x0f,0x03,0x33,0x03,0x33,0x03,0xc3,0x03,0xc3,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x00,0xff,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x33,0x03,0x33,0x03,0xc3,0x00,0xc3,0x00,0x3c,0x03,0x3c,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x00,0xff,0x00,0x33,0x00,0x33,0x00,0xc3,0x00,0xc3,0x00,0x03,0x03,0x03,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0xfc,0x00,0xfc,0x00,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x33,0x03,0x33,0x03,0xcf,0x03,0xcf,0x03,0x03,0x03,0x03,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,0xcc,0x00,0xcc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,0x33,0x03,0x33,0x03,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x33,0x03,0x33,0x03,0xfc,0x00,0xfc,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0xff,0x03,0xff,0x03,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xff,0x03,0xff,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x00,0x03,0x00,0x03,0xfc,0x03,0xfc,0x03,0x03,0x03,0x03,0x03,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xf3,0x00,0xf3,0x00,0x0f,0x03,0x0f,0x03,0x03,0x03,0x03,0x03,0x0f,0x03,0x0f,0x03,0xf3,0x00,0xf3,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x3c,0x03,0x3c,0x03,0xc3,0x03,0xc3,0x03,0x03,0x03,0x03,0x03,0xc3,0x03,0xc3,0x03,0x3c,0x03,0x3c,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,0x03,0x00,0x03,0x00,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x30,0x03,0x30,0x03,0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x03,0x3c,0x03,0xc3,0x03,0xc3,0x03,0xc3,0x03,0xc3,0x03,0x3c,0x03,0x3c,0x03,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xf3,0x00,0xf3,0x00,0x0f,0x03,0x0f,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xc3,0x00,0xc3,0x00,0x33,0x00,0x33,0x00,0x0f,0x00,0x0f,0x00,0x33,0x00,0x33,0x00,0xc3,0x00,0xc3,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcf,0x00,0xcf,0x00,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf3,0x00,0xf3,0x00,0x0f,0x03,0x0f,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf3,0x00,0xf3,0x00,0x0f,0x03,0x0f,0x03,0x03,0x03,0x03,0x03,0x0f,0x03,0x0f,0x03,0xf3,0x00,0xf3,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x03,0x3c,0x03,0xc3,0x03,0xc3,0x03,0x03,0x03,0x03,0x03,0xc3,0x03,0xc3,0x03,0x3c,0x03,0x3c,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf3,0x00,0xf3,0x00,0x0f,0x03,0x0f,0x03,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x03,0x00,0x03,0x00,0xfc,0x00,0xfc,0x00,0x00,0x03,0x00,0x03,0xff,0x00,0xff,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xff,0x03,0xff,0x03,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x03,0x30,0x03,0xc0,0x00,0xc0,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xc3,0x03,0xc3,0x03,0x3c,0x03,0x3c,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0xcc,0x00,0xcc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,0xcc,0x00,0xcc,0x00,0x03,0x03,0x03,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x03,0xfc,0x03,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0xff,0x03,0xff,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x33,0x03,0x33,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xcc,0x00,0xcc,0x00,0x33,0x03,0x33,0x03,0xcc,0x00,0xcc,0x00,0x33,0x03,0x33,0x03,0xcc,0x00,0xcc,0x00,0x33,0x03,0x33,0x03,0xcc,0x00,0xcc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
},

{
/* CG 2 - for Model I */
/* Source: MCM6674 Data Sheet, modified by mann (from memory). */
/* This is the replacement Model I character generator you got with the
   Radio Shack lowercase modification. Positions 0-31 are a copy of the
   uppercase letters, to work around a bug (?) in the Level II ROM. All
   characters without descenders are moved up one row.  I'm not sure I got
   all the changes exactly right -- help?
*/
0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0x03,0x3c,0x03,0x3c,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0xcc,0x00,0xcc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x00,0xff,0x00,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0xfc,0x00,0xfc,0x00,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0xff,0x00,0xff,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x00,0xff,0x00,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0xff,0x00,0xff,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x03,0xff,0x03,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x3f,0x00,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x03,0xff,0x03,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x3f,0x00,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x03,0xfc,0x03,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xc3,0x03,0xc3,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x00,0xfc,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x03,0x03,0x03,0xc3,0x00,0xc3,0x00,0x33,0x00,0x33,0x00,0x0f,0x00,0x0f,0x00,0x33,0x00,0x33,0x00,0xc3,0x00,0xc3,0x00,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x03,0x03,0x03,0xcf,0x03,0xcf,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x03,0x03,0x03,0x0f,0x03,0x0f,0x03,0x33,0x03,0x33,0x03,0xc3,0x03,0xc3,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x00,0xff,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x00,0xff,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x33,0x03,0x33,0x03,0xc3,0x00,0xc3,0x00,0x3c,0x03,0x3c,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x00,0xff,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x00,0xff,0x00,0x33,0x00,0x33,0x00,0xc3,0x00,0xc3,0x00,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0xfc,0x00,0xfc,0x00,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x03,0xff,0x03,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x33,0x03,0x33,0x03,0xcf,0x03,0xcf,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,0xcc,0x00,0xcc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x03,0xff,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,0x33,0x03,0x33,0x03,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x33,0x03,0x33,0x03,0xfc,0x00,0xfc,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0xff,0x03,0xff,0x03,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xff,0x03,0xff,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xff,0x03,0xff,0x03,0xcc,0x00,0xcc,0x00,0xff,0x03,0xff,0x03,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0xfc,0x03,0xfc,0x03,0x33,0x00,0x33,0x00,0xfc,0x00,0xfc,0x00,0x30,0x03,0x30,0x03,0xff,0x00,0xff,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0f,0x00,0x0f,0x00,0x0f,0x03,0x0f,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0xc3,0x03,0xc3,0x03,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x00,0x0c,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x0c,0x00,0x0c,0x00,0x33,0x03,0x33,0x03,0xc3,0x00,0xc3,0x00,0x3c,0x03,0x3c,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0x33,0x03,0x33,0x03,0xfc,0x00,0xfc,0x00,0xff,0x03,0xff,0x03,0xfc,0x00,0xfc,0x00,0x33,0x03,0x33,0x03,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xff,0x03,0xff,0x03,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0xc3,0x03,0xc3,0x03,0x33,0x03,0x33,0x03,0x0f,0x03,0x0f,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0x3c,0x00,0x3c,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0x03,0xfc,0x00,0xfc,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0x03,0xf0,0x00,0xf0,0x00,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0xf0,0x00,0xf0,0x00,0xcc,0x00,0xcc,0x00,0xc3,0x00,0xc3,0x00,0xff,0x03,0xff,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x03,0xff,0x03,0x03,0x00,0x03,0x00,0xff,0x00,0xff,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x00,0xf0,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0xff,0x00,0xff,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x03,0xff,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x03,0xfc,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0x03,0x3c,0x03,0x3c,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0xcc,0x00,0xcc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x00,0xff,0x00,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0xfc,0x00,0xfc,0x00,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0xff,0x00,0xff,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x00,0xff,0x00,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0xff,0x00,0xff,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x03,0xff,0x03,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x3f,0x00,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x03,0xff,0x03,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x3f,0x00,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x03,0xfc,0x03,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xc3,0x03,0xc3,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x00,0xfc,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x03,0x03,0x03,0xc3,0x00,0xc3,0x00,0x33,0x00,0x33,0x00,0x0f,0x00,0x0f,0x00,0x33,0x00,0x33,0x00,0xc3,0x00,0xc3,0x00,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x03,0x03,0x03,0xcf,0x03,0xcf,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x03,0x03,0x03,0x0f,0x03,0x0f,0x03,0x33,0x03,0x33,0x03,0xc3,0x03,0xc3,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x00,0xff,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x00,0xff,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x33,0x03,0x33,0x03,0xc3,0x00,0xc3,0x00,0x3c,0x03,0x3c,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x00,0xff,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xff,0x00,0xff,0x00,0x33,0x00,0x33,0x00,0xc3,0x00,0xc3,0x00,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0xfc,0x00,0xfc,0x00,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x03,0xff,0x03,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x33,0x03,0x33,0x03,0xcf,0x03,0xcf,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,0xcc,0x00,0xcc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x03,0xff,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,0x33,0x03,0x33,0x03,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x33,0x03,0x33,0x03,0xfc,0x00,0xfc,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0xff,0x03,0xff,0x03,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xff,0x03,0xff,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x00,0x03,0x00,0x03,0xfc,0x03,0xfc,0x03,0x03,0x03,0x03,0x03,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xf3,0x00,0xf3,0x00,0x0f,0x03,0x0f,0x03,0x03,0x03,0x03,0x03,0x0f,0x03,0x0f,0x03,0xf3,0x00,0xf3,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x3c,0x03,0x3c,0x03,0xc3,0x03,0xc3,0x03,0x03,0x03,0x03,0x03,0xc3,0x03,0xc3,0x03,0x3c,0x03,0x3c,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0xff,0x03,0xff,0x03,0x03,0x00,0x03,0x00,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x30,0x03,0x30,0x03,0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x03,0x3c,0x03,0xc3,0x03,0xc3,0x03,0xc3,0x03,0xc3,0x03,0x3c,0x03,0x3c,0x03,0x00,0x03,0x00,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xf3,0x00,0xf3,0x00,0x0f,0x03,0x0f,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xc3,0x00,0xc3,0x00,0x33,0x00,0x33,0x00,0x0f,0x00,0x0f,0x00,0x33,0x00,0x33,0x00,0xc3,0x00,0xc3,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3c,0x00,0x3c,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcf,0x00,0xcf,0x00,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf3,0x00,0xf3,0x00,0x0f,0x03,0x0f,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf3,0x00,0xf3,0x00,0x0f,0x03,0x0f,0x03,0x0f,0x03,0x0f,0x03,0xf3,0x00,0xf3,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x03,0x3c,0x03,0xc3,0x03,0xc3,0x03,0xc3,0x03,0xc3,0x03,0x3c,0x03,0x3c,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf3,0x00,0xf3,0x00,0x0f,0x03,0x0f,0x03,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x03,0x00,0x03,0x00,0xfc,0x00,0xfc,0x00,0x00,0x03,0x00,0x03,0xff,0x00,0xff,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xff,0x03,0xff,0x03,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x03,0x30,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xc3,0x03,0xc3,0x03,0x3c,0x03,0x3c,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0x33,0x03,0xcc,0x00,0xcc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,0xcc,0x00,0xcc,0x00,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xfc,0x03,0xfc,0x03,0x00,0x03,0x00,0x03,0xfc,0x00,0xfc,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x00,0x0c,0x00,0x33,0x03,0x33,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xcc,0x00,0xcc,0x00,0x33,0x03,0x33,0x03,0xcc,0x00,0xcc,0x00,0x33,0x03,0x33,0x03,0xcc,0x00,0xcc,0x00,0x33,0x03,0x33,0x03,0xcc,0x00,0xcc,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
},

{
/* CG 3 - for Model I */
/* Source: BDF font from Al Petrofsky, probably adapted from another emulator.
   This is not the real Model I font, which used a 6x12 matrix;
   it seems to be a modified version of the 8x12 Model III font.
*/
0xf0,0x3f,0xf0,0x3f,0x0c,0xc0,0x0c,0xc0,0x00,0xc0,0x00,0xc0,0xf0,0xc0,0xf0,0xc0,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xf0,0xff,0xf0,0xff,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0x3f,0xc0,0x3f,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xf0,0xff,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0x0f,0xf0,0x0f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0xff,0xf0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xf0,0xff,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0x0f,0xf0,0x0f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0xff,0xc0,0xff,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xfc,0x30,0xfc,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0xff,0xc0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xf0,0xff,0xf0,0xff,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0xc0,0x30,0xc0,0x30,0x30,0x30,0x30,0x30,0x0c,0x30,0x0c,0xf0,0x03,0xf0,0x03,0x30,0x0c,0x30,0x0c,0x30,0x30,0x30,0x30,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0xff,0xf0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0xc0,0x0c,0xc0,0x3c,0xf0,0x3c,0xf0,0xcc,0xcc,0xcc,0xcc,0x0c,0xc3,0x0c,0xc3,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0xc0,0x30,0xc0,0xf0,0xc0,0xf0,0xc0,0x30,0xc3,0x30,0xc3,0x30,0xcc,0x30,0xcc,0x30,0xf0,0x30,0xf0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xf0,0x3f,0xf0,0x3f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xcc,0x30,0xcc,0x30,0x30,0x30,0x30,0xc0,0xcf,0xc0,0xcf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xf0,0x3f,0xf0,0x3f,0x30,0x0c,0x30,0x0c,0x30,0x30,0x30,0x30,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0x00,0x30,0x00,0xc0,0x3f,0xc0,0x3f,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0xff,0xfc,0xff,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x30,0x30,0x30,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc3,0x0c,0xc3,0xcc,0xcc,0xcc,0xcc,0x3c,0xf0,0x3c,0xf0,0x0c,0xc0,0x0c,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x30,0xc0,0x30,0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0xff,0xfc,0xff,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xfc,0xff,0xfc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x0c,0xc3,0x0c,0xc3,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x0c,0xc3,0x0c,0xc3,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xfc,0xff,0xfc,0xff,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0xfc,0xff,0xfc,0xff,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xfc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xf0,0xff,0xf0,0xff,0xc0,0x30,0xc0,0x30,0xf0,0xff,0xf0,0xff,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xf0,0xff,0xf0,0xff,0x0c,0x03,0x0c,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0xc3,0x00,0xc3,0xfc,0x3f,0xfc,0x3f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0xc0,0xf0,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0xf0,0x30,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0xc0,0x0c,0xc0,0x0c,0xc0,0x03,0xc0,0x03,0x30,0xcc,0x30,0xcc,0x30,0x30,0x30,0x30,0xc0,0xcf,0xc0,0xcf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0xfc,0xff,0xfc,0xff,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0xf0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xf0,0x30,0xf0,0x30,0xcc,0x30,0xcc,0x30,0xc3,0x30,0xc3,0xf0,0xc0,0xf0,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0xc0,0xc0,0x3f,0xc0,0x3f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0xff,0xf0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x3f,0x00,0x3f,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x30,0x00,0x30,0x00,0x3c,0x00,0x3c,0x00,0x33,0x00,0x33,0xc0,0x30,0xc0,0x30,0xf0,0xff,0xf0,0xff,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xf0,0xff,0x30,0x00,0x30,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x3f,0x00,0x3f,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xf0,0x3f,0xf0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xf0,0xff,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0xff,0xc0,0xff,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0xf0,0xff,0x00,0x00,0x00,0x00,0xf0,0xff,0xf0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x00,0x30,0x00,0x30,0x00,0x0f,0x00,0x0f,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0x0c,0xc0,0x0c,0xc0,0x00,0xc0,0x00,0xc0,0xf0,0xc0,0xf0,0xc0,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xf0,0xff,0xf0,0xff,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0x3f,0xc0,0x3f,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xf0,0xff,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0x0f,0xf0,0x0f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0xff,0xf0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xf0,0xff,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0x0f,0xf0,0x0f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0xff,0xc0,0xff,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xfc,0x30,0xfc,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0xff,0xc0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xf0,0xff,0xf0,0xff,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0xc0,0x30,0xc0,0x30,0x30,0x30,0x30,0x30,0x0c,0x30,0x0c,0xf0,0x03,0xf0,0x03,0x30,0x0c,0x30,0x0c,0x30,0x30,0x30,0x30,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0xff,0xf0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0xc0,0x0c,0xc0,0x3c,0xf0,0x3c,0xf0,0xcc,0xcc,0xcc,0xcc,0x0c,0xc3,0x0c,0xc3,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0xc0,0x30,0xc0,0xf0,0xc0,0xf0,0xc0,0x30,0xc3,0x30,0xc3,0x30,0xcc,0x30,0xcc,0x30,0xf0,0x30,0xf0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xf0,0x3f,0xf0,0x3f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xcc,0x30,0xcc,0x30,0x30,0x30,0x30,0xc0,0xcf,0xc0,0xcf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xf0,0x3f,0xf0,0x3f,0x30,0x0c,0x30,0x0c,0x30,0x30,0x30,0x30,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0x00,0x30,0x00,0xc0,0x3f,0xc0,0x3f,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0xff,0xfc,0xff,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x30,0x30,0x30,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc3,0x0c,0xc3,0xcc,0xcc,0xcc,0xcc,0x3c,0xf0,0x3c,0xf0,0x0c,0xc0,0x0c,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x30,0xc0,0x30,0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0xff,0xfc,0xff,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xfc,0xff,0xfc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xfc,0xff,0xfc,0xff,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0xfc,0xff,0xfc,0xff,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xfc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0xf0,0x03,0xf0,0x03,0xc0,0x00,0xc0,0x00,0xc0,0xc0,0xc0,0xc0,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x3f,0xc0,0x3f,0x00,0xc0,0x00,0xc0,0xc0,0xff,0xc0,0xff,0x30,0xc0,0x30,0xc0,0xc0,0xff,0xc0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x3f,0x30,0x3f,0xf0,0xc0,0xf0,0xc0,0x30,0xc0,0x30,0xc0,0xf0,0xc0,0xf0,0xc0,0x30,0x3f,0x30,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0x00,0x30,0x00,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0xc0,0xcf,0xc0,0xcf,0x30,0xf0,0x30,0xf0,0x30,0xc0,0x30,0xc0,0x30,0xf0,0x30,0xf0,0xc0,0xcf,0xc0,0xcf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0xf0,0xff,0xf0,0xff,0x30,0x00,0x30,0x00,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x3f,0x00,0x3f,0xc0,0xc0,0xc0,0xc0,0xc0,0x00,0xc0,0x00,0xf0,0x03,0xf0,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0xff,0xc0,0xff,0x00,0xc0,0x00,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x3f,0x30,0x3f,0xf0,0xc0,0xf0,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xc0,0x30,0xc0,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3c,0xfc,0x3c,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc0,0x0c,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x3f,0x30,0x3f,0xf0,0xc0,0xf0,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x3f,0x30,0x3f,0xf0,0xc0,0xf0,0xc0,0xf0,0xc0,0xf0,0xc0,0x30,0x3f,0x30,0x3f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xcf,0xc0,0xcf,0x30,0xf0,0x30,0xf0,0x30,0xf0,0x30,0xf0,0xc0,0xcf,0xc0,0xcf,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x3f,0x30,0x3f,0xf0,0xc0,0xf0,0xc0,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0xc0,0xff,0x30,0x00,0x30,0x00,0xc0,0x3f,0xc0,0x3f,0x00,0xc0,0x00,0xc0,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xc3,0x00,0xc3,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0xcf,0xc0,0xcf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x30,0x30,0x30,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0xc0,0x0c,0xc0,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0xf0,0x3c,0xf0,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0xc0,0x30,0xc0,0xc0,0x30,0xc0,0x30,0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0xff,0xc0,0xff,0x00,0xc0,0x00,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x3c,0x00,0x3c,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x00,0xf0,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x00,0xf0,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x3c,0x00,0x3c,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0xc0,0x0c,0xc0,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0xfc,0xff,0xfc,0xff,0x00,0x03,0x00,0x03,0xfc,0xff,0xfc,0xff,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xcc,0xcc,0xcc,0xcc,0x30,0x33,0x30,0x33,0xcc,0xcc,0xcc,0xcc,0x30,0x33,0x30,0x33,0xcc,0xcc,0xcc,0xcc,0x30,0x33,0x30,0x33,0xcc,0xcc,0xcc,0xcc,0x30,0x33,0x30,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
},

{
/* CG 4 - for Model III */
/* Source: A model III CG ROM, read by Todd P. Cromwell III (todd2.bin) */
/* This is the older CG with Katakana alternate characters */
/* Letters start at top of cell, Model III style */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0xfc,0x0f,0xfc,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0c,0xc0,0x0c,0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0xcf,0xc0,0xcf,0x30,0x30,0x30,0x30,0x30,0x3c,0x30,0x3c,0x30,0x33,0x30,0x33,0xf0,0x30,0xf0,0x30,0x30,0x30,0x30,0x30,0xcc,0x0f,0xcc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0x30,0x0f,0x30,0x0f,0xf0,0x30,0xf0,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0xfc,0x33,0xfc,0x33,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0xfc,0x03,0xfc,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x0c,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0c,0xc0,0x0c,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x30,0x30,0x30,0x30,0xf0,0x30,0xf0,0x30,0x30,0x33,0x30,0x33,0x30,0x3c,0x30,0x3c,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0c,0xc0,0x0c,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xc3,0x00,0xc3,0xc0,0x3c,0xc0,0x3c,0x30,0x3c,0x30,0x3c,0x30,0x33,0x30,0x33,0xf0,0x30,0xf0,0x30,0xf0,0x0c,0xf0,0x0c,0x0c,0x03,0x0c,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x00,0x33,0x00,0x33,0xc0,0x0f,0xc0,0x0f,0x30,0x03,0x30,0x03,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x03,0x30,0x03,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x00,0x0c,0x00,0xfc,0x0f,0xfc,0x0f,0x0c,0x30,0x0c,0x30,0xf0,0x3f,0xf0,0x3f,0x00,0x30,0x00,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x30,0x00,0x30,0x00,0xf0,0x3f,0xf0,0x3f,0x30,0x00,0x30,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x3f,0xc0,0x3f,0x30,0x0c,0x30,0x0c,0x30,0x3c,0x30,0x3c,0xf0,0x0f,0xf0,0x0f,0x30,0x0c,0x30,0x0c,0x30,0x3c,0x30,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xfc,0x3f,0xfc,0x3f,0x30,0x0c,0x30,0x0c,0xfc,0x3f,0xfc,0x3f,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x3f,0xc0,0x3f,0x30,0x03,0x30,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x33,0x00,0x33,0xf0,0x0f,0xf0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x30,0x3c,0x30,0x3c,0x0c,0x3c,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x3c,0x30,0x3c,0x0c,0x3c,0x0c,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x00,0xf0,0x00,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0xf0,0x00,0xf0,0x00,0x0c,0x33,0x0c,0x33,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0xf0,0x3f,0xf0,0x3f,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xcc,0x33,0xcc,0x33,0x3c,0x30,0x3c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x03,0xc0,0x03,0x30,0x03,0x30,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x00,0x30,0x00,0x30,0x00,0x0f,0x00,0x0f,0xf0,0x00,0xf0,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x00,0x30,0x00,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x30,0x00,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0c,0x00,0x0c,0x00,0x0f,0x00,0x0f,0xc0,0x0c,0xc0,0x0c,0x30,0x0c,0x30,0x0c,0xfc,0x3f,0xfc,0x3f,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0xfc,0x03,0xfc,0x03,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x0c,0x0c,0x0c,0x0c,0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x0f,0xfc,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x3f,0xf0,0x3f,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x3c,0x00,0x3c,0x00,0x0f,0x00,0x0f,0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,0xc0,0x03,0xc0,0x03,0x00,0x0f,0x00,0x0f,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3c,0x00,0x3c,0x00,0xf0,0x00,0xf0,0x00,0xc0,0x03,0xc0,0x03,0x00,0x0f,0x00,0x0f,0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x00,0x30,0x00,0x30,0x00,0x0f,0x00,0x0f,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0x33,0x0c,0x33,0xcc,0x3c,0xcc,0x3c,0x0c,0x0f,0x0c,0x0f,0x30,0x00,0x30,0x00,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x0f,0xfc,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x03,0xfc,0x03,0x30,0x0c,0x30,0x0c,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x0c,0x30,0x0c,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x03,0xfc,0x03,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x03,0xfc,0x03,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0x00,0x0c,0x00,0x0c,0x3f,0x0c,0x3f,0x0c,0x30,0x0c,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x3f,0x00,0x3f,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x0c,0x0c,0x0c,0x0c,0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x30,0x0c,0x30,0x0c,0x0c,0x0c,0x0c,0x0c,0x03,0x0c,0x03,0xfc,0x00,0xfc,0x00,0x0c,0x03,0x0c,0x03,0x0c,0x0c,0x0c,0x0c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x30,0x0c,0x30,0x3c,0x3c,0x3c,0x3c,0xcc,0x33,0xcc,0x33,0xcc,0x33,0xcc,0x33,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x30,0x0c,0x30,0x3c,0x30,0x3c,0x30,0xcc,0x30,0xcc,0x30,0x0c,0x33,0x0c,0x33,0x0c,0x3c,0x0c,0x3c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x0f,0xfc,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xfc,0x0f,0xfc,0x0f,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x33,0x0c,0x33,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x0f,0xfc,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xfc,0x0f,0xfc,0x0f,0x0c,0x03,0x0c,0x03,0x0c,0x0c,0x0c,0x0c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x30,0x00,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xcc,0x33,0xcc,0x33,0xcc,0x33,0xcc,0x33,0x3c,0x3c,0x3c,0x3c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xcc,0x0f,0xcc,0x0f,0x3c,0x30,0x3c,0x30,0x0c,0x30,0x0c,0x30,0x3c,0x30,0x3c,0x30,0xcc,0x0f,0xcc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x00,0x0c,0x00,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xf0,0x33,0xf0,0x33,0x0c,0x3c,0x0c,0x3c,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0xfc,0x0f,0xfc,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x33,0xf0,0x33,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x30,0x00,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xcc,0x0f,0xcc,0x0f,0x3c,0x30,0x3c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x0c,0x0c,0x0c,0x0c,0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x0c,0x0c,0x0c,0x0c,0x03,0x0c,0x03,0xcc,0x00,0xcc,0x00,0x3c,0x03,0x3c,0x03,0x0c,0x0c,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3c,0xfc,0x3c,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcc,0x0f,0xcc,0x0f,0x3c,0x30,0x3c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcc,0x0f,0xcc,0x0f,0x3c,0x30,0x3c,0x30,0x3c,0x30,0x3c,0x30,0xcc,0x0f,0xcc,0x0f,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x33,0xf0,0x33,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcc,0x0f,0xcc,0x0f,0x3c,0x30,0x3c,0x30,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x30,0x00,0x30,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xfc,0x0f,0xfc,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0xc0,0x0c,0xc0,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0xf0,0x3c,0xf0,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x30,0x00,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x0c,0x00,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x00,0x30,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0f,0x00,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x00,0xf0,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x00,0xf0,0x00,0x0c,0xc3,0x0c,0xc3,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0xf0,0x3f,0xf0,0x3f,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x3c,0xf0,0x3c,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xf0,0x3f,0xf0,0x3f,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0xf0,0x3f,0xf0,0x3f,0xfc,0xff,0xfc,0xff,0xf0,0x3f,0xf0,0x3f,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x3c,0xf3,0x3c,0xf3,0xfc,0xff,0xfc,0xff,0x3c,0xf3,0x3c,0xf3,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x33,0xcc,0x33,0xcc,0x03,0xc0,0x03,0xc0,0x33,0xcc,0x33,0xcc,0xc3,0xc3,0xc3,0xc3,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x33,0xcc,0x33,0xcc,0x03,0xc0,0x03,0xc0,0xc3,0xc3,0xc3,0xc3,0x33,0xcc,0x33,0xcc,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xc3,0xf0,0xc3,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0xf0,0xc3,0xf0,0xc3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3c,0xc0,0x3c,0xc0,0xc0,0x30,0xc0,0x30,0xc0,0x0c,0xc0,0x0c,0xc0,0x03,0xc0,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0x00,0x0f,0x00,0x0f,0x00,0x33,0x00,0x33,0xc0,0x30,0xc0,0x30,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x3c,0x00,0x3c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x3f,0xf0,0x3f,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3c,0xc0,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x0f,0xc0,0x0f,0x00,0x30,0x00,0x30,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0f,0x30,0x0f,0xcc,0x30,0xcc,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x00,0x0c,0x00,0x0c,0x03,0x0c,0x03,0xcc,0x00,0xcc,0x00,0x3c,0x00,0x3c,0x00,0xcc,0x00,0xcc,0x00,0x0c,0x33,0x0c,0x33,0x0c,0x0c,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xf0,0x33,0xf0,0x33,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x0c,0xc0,0x0c,0xc0,0x03,0xc0,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x00,0x30,0x00,0xc0,0x03,0xc0,0x03,0x30,0x00,0x30,0x00,0xc0,0x0f,0xc0,0x0f,0x00,0x30,0x00,0x30,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0xcc,0x0c,0xcc,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xf0,0x03,0xf0,0x03,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x0c,0x03,0x0c,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x3c,0x0c,0x3c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x30,0x3c,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0xf0,0x30,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0xc3,0x0c,0xc3,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x30,0x30,0x0c,0xc0,0x0c,0xc0,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0xf0,0x3c,0xf0,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x3c,0xf0,0x3c,0xf0,0x30,0x30,0x30,0x30,0x3c,0xf0,0x3c,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xcc,0x00,0xcc,0x00,0xf0,0x00,0xf0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x0f,0x00,0x0f,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xfc,0xff,0xfc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0xfc,0xff,0xfc,0xff,0x00,0x03,0x00,0x03,0xfc,0xff,0xfc,0xff,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x3f,0xf0,0x3f,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xf0,0xff,0xcc,0x30,0xcc,0x30,0x30,0x0c,0x30,0x0c,0x00,0x03,0x00,0x03,0xc0,0x30,0xc0,0x30,0x30,0xcc,0x30,0xcc,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0xfc,0xff,0xfc,0xff,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3c,0xf0,0x3c,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3c,0xf0,0x3c,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0xf0,0x3c,0xf0,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x0c,0x03,0x0c,0x03,0xcc,0x00,0xcc,0x00,0x3c,0x00,0x3c,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0x00,0x30,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x30,0x00,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x30,0x30,0x30,0xcc,0xcc,0xcc,0xcc,0x30,0x33,0x30,0x33,0xc0,0x0c,0xc0,0x0c,0x30,0x33,0x30,0x33,0xcc,0xcc,0xcc,0xcc,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xc3,0xcf,0xc3,0xcf,0x33,0xc0,0x33,0xc0,0x33,0xc0,0x33,0xc0,0xc3,0xcf,0xc3,0xcf,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0x0c,0x33,0x0c,0x33,0x0c,0x33,0x0c,0x33,0xf0,0x33,0xf0,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x30,0x03,0x30,0x03,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0xfc,0x33,0xfc,0x33,0x33,0xcc,0x33,0xcc,0x33,0xcc,0x33,0xcc,0xf3,0xc3,0xf3,0xc3,0x33,0xc3,0x33,0xc3,0x3c,0x3c,0x3c,0x3c,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xcc,0xff,0xcc,0xff,0x3c,0x00,0x3c,0x00,0x3c,0xf0,0x3c,0xf0,0x3c,0x30,0x3c,0x30,0x3c,0x0c,0x3c,0x0c,0xfc,0xf3,0xfc,0xf3,0x3c,0x00,0x3c,0x00,0xcc,0xff,0xcc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0xff,0xff,0xff,0x00,0x0c,0x00,0x0c,0x00,0xf0,0x00,0xf0,0xff,0x0f,0xff,0x0f,0x00,0x30,0x00,0x30,0xff,0x0f,0xff,0x0f,0x00,0x0c,0x00,0x0c,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x0f,0xff,0x0f,0x00,0x30,0x00,0x30,0xff,0x0f,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x03,0xfc,0x03,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0xfc,0x03,0xfc,0x03,0x0c,0x33,0x0c,0x33,0x0c,0x0c,0x0c,0x0c,0x0c,0xf3,0x0c,0xf3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3c,0xc0,0x3c,0xc0,0x03,0x30,0x03,0x30,0x03,0x0c,0x03,0x0c,0x3c,0x03,0x3c,0x03,0xc0,0x3c,0xc0,0x3c,0x30,0xc3,0x30,0xc3,0x0c,0xc3,0x0c,0xc3,0x03,0x3c,0x03,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x3f,0x00,0x3f,0x00,0x3c,0x00,0x3c,0x00,0x33,0x00,0x33,0xfc,0x00,0xfc,0x00,0xc3,0x00,0xc3,0x00,0xc3,0x00,0xc3,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x3f,0x00,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x3f,0x00,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0xff,0xff,0xff,0x3f,0xf0,0x3f,0xf0,0xcf,0xcf,0xcf,0xcf,0xff,0xf0,0xff,0xf0,0xff,0xfc,0xff,0xfc,0xff,0xff,0xff,0xff,0xff,0xfc,0xff,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0xc0,0x0c,0xc0,0x0c,0xf0,0x3f,0xf0,0x3f,0xc0,0x0c,0xc0,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x33,0x30,0x33,0xf0,0x3c,0xf0,0x3c,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x30,0x30,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x30,0x00,0x30,0x00,0x0f,0x00,0x0f,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x03,0xc0,0x03,0x30,0x03,0x30,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xf0,0x0f,0xf0,0x0f,0xc0,0x03,0xc0,0x03,0x30,0x03,0x30,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0xf0,0x3f,0xf0,0x3f,0xc0,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x30,0x00,0x30,0xc0,0x3f,0xc0,0x3f,0x00,0x30,0x00,0x30,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x30,0x30,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0xc0,0x0c,0xc0,0x0c,0xc0,0x03,0xc0,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x03,0xc0,0x03,0x30,0x03,0x30,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xfc,0x3f,0xfc,0x3f,0x00,0x03,0x00,0x03,0xc0,0x03,0xc0,0x03,0x30,0x03,0x30,0x03,0x0c,0x03,0x0c,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0xfc,0x3f,0xfc,0x3f,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0x30,0x30,0x30,0x30,0x0c,0x3f,0x0c,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x0c,0x30,0x0c,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0x3f,0xf0,0x3f,0x30,0x03,0x30,0x03,0x0c,0x03,0x0c,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0xfc,0x3f,0xfc,0x3f,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x03,0xf0,0x03,0x00,0x30,0x00,0x30,0xfc,0x30,0xfc,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0xfc,0x3f,0xfc,0x3f,0xc0,0x30,0xc0,0x30,0xc0,0x0c,0xc0,0x0c,0xc0,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x30,0x0c,0x30,0x30,0x30,0x30,0x30,0xc0,0x30,0xc0,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x33,0x00,0x33,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x33,0x00,0x33,0xfc,0x0f,0xfc,0x0f,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0x03,0xf0,0x03,0x30,0x0c,0x30,0x0c,0x30,0x30,0x30,0x30,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x0f,0x00,0x0f,0xc0,0x33,0xc0,0x33,0x30,0x03,0x30,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x3c,0x00,0x3c,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0xc0,0x30,0xc0,0x30,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x30,0x03,0x30,0x03,0x0c,0x0c,0x0c,0x0c,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x03,0x0c,0x03,0x0c,0x0c,0x0c,0x0c,0xfc,0x33,0xfc,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x30,0x00,0x30,0x30,0x30,0x30,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0xc0,0x00,0xc0,0x00,0xf0,0x0f,0xf0,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0xfc,0x3f,0xfc,0x3f,0xc0,0x30,0xc0,0x30,0xc0,0x0c,0xc0,0x0c,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xf0,0x3f,0xf0,0x3f,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x30,0x30,0x30,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x0c,0x0c,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x30,0xcc,0x30,0xcc,0x30,0xcc,0x30,0xcc,0x0c,0xcc,0x0c,0xcc,0x03,0xcc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x0c,0x30,0x0c,0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x30,0xfc,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x0c,0x03,0x0c,0x03,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x0c,0x03,0x0c,0x03,0x30,0x0c,0x30,0x0c,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
},

{
/* CG 5 - for Model III */
/* Source: see corresponding Model 4/4P CG below */
/* This is the newer CG with international alternate characters.
   Characters 0-31 are also different from the older CG. I'm not certain
   this CG was available in the Model III; it may have been introduced
   in the Model 4 */
/* Letters shifted up 1 to start at top of cell, Model III style */
0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,
0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
0xf0,0x0f,0xf0,0x0f,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,0x30,0x00,0x30,0x00,0x30,0x30,0x30,0x30,
0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x30,0x00,0x30,
0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,
0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,
0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,
0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,
0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x30,0x03,0x30,0x03,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,
0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,
0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x00,0x0c,0x00,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xfc,0xff,
0x0c,0xc0,0x0c,0xc0,0xfc,0xff,0xfc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x30,0x03,0x30,0x03,0xf0,0x00,0xf0,0x00,
0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xf0,0x0f,0xf0,0x0f,
0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,
0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x00,0x03,0x00,0x0f,0x00,0x0f,0x00,0x3f,0x00,0x3f,0x00,0xff,0x00,0xff,0x00,0xff,0x03,0xff,0x03,0xff,0x0f,0xff,0x0f,
0xff,0x3f,0xff,0x3f,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0xc0,0x0f,0xc0,0x0f,0xc0,0x0c,0xc0,0x0c,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0xfc,0x0f,0xfc,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,
0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xfc,0x3f,0xfc,0x3f,0x30,0x0c,0x30,0x0c,0xfc,0x3f,0xfc,0x3f,0x30,0x0c,0x30,0x0c,
0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x3f,0xc0,0x3f,0x30,0x03,0x30,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x33,0x00,0x33,0xf0,0x0f,0xf0,0x0f,
0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x30,0x3c,0x30,0x3c,0x0c,0x3c,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x3c,0x30,0x3c,
0x0c,0x3c,0x0c,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x00,0xf0,0x00,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0xf0,0x00,0xf0,0x00,0x0c,0x33,0x0c,0x33,0x0c,0x0c,0x0c,0x0c,
0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,
0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,
0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0xf0,0x3f,0xf0,0x3f,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,
0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,
0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,
0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xcc,0x33,0xcc,0x33,0x3c,0x30,0x3c,0x30,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x03,0xc0,0x03,0x30,0x03,0x30,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x00,0x30,0x00,0x30,0x00,0x0f,0x00,0x0f,0xf0,0x00,0xf0,0x00,0x0c,0x00,0x0c,0x00,
0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x00,0x30,0x00,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x30,0x00,0x30,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0c,0x00,0x0c,0x00,0x0f,0x00,0x0f,0xc0,0x0c,0xc0,0x0c,0x30,0x0c,0x30,0x0c,0xfc,0x3f,0xfc,0x3f,0x00,0x0c,0x00,0x0c,
0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0xfc,0x03,0xfc,0x03,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x0c,0x0c,0x0c,0x0c,
0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x0f,0xfc,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x3f,0xf0,0x3f,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,
0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,
0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x3c,0x00,0x3c,0x00,0x0f,0x00,0x0f,0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,0xc0,0x03,0xc0,0x03,0x00,0x0f,0x00,0x0f,
0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3c,0x00,0x3c,0x00,0xf0,0x00,0xf0,0x00,0xc0,0x03,0xc0,0x03,0x00,0x0f,0x00,0x0f,0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,
0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x00,0x30,0x00,0x30,0x00,0x0f,0x00,0x0f,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0x33,0x0c,0x33,0xcc,0x3c,0xcc,0x3c,0x0c,0x0f,0x0c,0x0f,0x30,0x00,0x30,0x00,
0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x0f,0xfc,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x30,0x30,0x30,0x30,
0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x03,0xfc,0x03,0x30,0x0c,0x30,0x0c,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x0c,0x30,0x0c,
0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x03,0xfc,0x03,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,
0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x03,0xfc,0x03,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,
0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0x00,0x0c,0x00,0x0c,0x3f,0x0c,0x3f,0x0c,0x30,0x0c,0x30,0x30,0x30,0x30,0x30,
0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x3f,0x00,0x3f,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x0c,0x0c,0x0c,0x0c,
0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x30,0x0c,0x30,0x0c,0x0c,0x0c,0x0c,0x0c,0x03,0x0c,0x03,0xfc,0x00,0xfc,0x00,0x0c,0x03,0x0c,0x03,0x0c,0x0c,0x0c,0x0c,
0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,
0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x30,0x0c,0x30,0x3c,0x3c,0x3c,0x3c,0xcc,0x33,0xcc,0x33,0xcc,0x33,0xcc,0x33,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x30,0x0c,0x30,0x3c,0x30,0x3c,0x30,0xcc,0x30,0xcc,0x30,0x0c,0x33,0x0c,0x33,0x0c,0x3c,0x0c,0x3c,0x0c,0x30,0x0c,0x30,
0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x0f,0xfc,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xfc,0x0f,0xfc,0x0f,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,
0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x33,0x0c,0x33,0x0c,0x0c,0x0c,0x0c,
0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x0f,0xfc,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xfc,0x0f,0xfc,0x0f,0x0c,0x03,0x0c,0x03,0x0c,0x0c,0x0c,0x0c,
0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x30,0x00,0x30,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,
0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xcc,0x33,0xcc,0x33,0xcc,0x33,0xcc,0x33,0x3c,0x3c,0x3c,0x3c,
0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,
0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,
0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,
0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,
0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xcc,0x0f,0xcc,0x0f,0x3c,0x30,0x3c,0x30,0x0c,0x30,0x0c,0x30,0x3c,0x30,0x3c,0x30,
0xcc,0x0f,0xcc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x00,0x0c,0x00,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xf0,0x33,0xf0,0x33,0x0c,0x3c,0x0c,0x3c,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,
0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0xfc,0x0f,0xfc,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x33,0xf0,0x33,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,
0x00,0x30,0x00,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xcc,0x0f,0xcc,0x0f,0x3c,0x30,0x3c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,
0x0c,0x0c,0x0c,0x0c,0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x0c,0x0c,0x0c,0x0c,0x03,0x0c,0x03,0xcc,0x00,0xcc,0x00,0x3c,0x03,0x3c,0x03,
0x0c,0x0c,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3c,0xfc,0x3c,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,
0x0c,0xc3,0x0c,0xc3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcc,0x0f,0xcc,0x0f,0x3c,0x30,0x3c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcc,0x0f,0xcc,0x0f,0x3c,0x30,0x3c,0x30,0x3c,0x30,0x3c,0x30,0xcc,0x0f,0xcc,0x0f,
0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x33,0xf0,0x33,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,
0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcc,0x0f,0xcc,0x0f,0x3c,0x30,0x3c,0x30,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,
0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x30,0x00,0x30,
0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xfc,0x0f,0xfc,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,
0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,
0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,
0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0xc0,0x0c,0xc0,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,
0xf0,0x3c,0xf0,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,
0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,
0x00,0x30,0x00,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x0c,0x00,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x00,0x30,0x00,
0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0f,0x00,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,
0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x00,0xf0,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x00,0xf0,0x00,0x0c,0xc3,0x0c,0xc3,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0xf0,0x3f,0xf0,0x3f,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xf0,0x3f,0xf0,0x3f,
0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x3c,0xf0,0x3c,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xf0,0x3f,0xf0,0x3f,0xc0,0x0f,0xc0,0x0f,
0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0xf0,0x3f,0xf0,0x3f,0xfc,0xff,0xfc,0xff,0xf0,0x3f,0xf0,0x3f,0xc0,0x0f,0xc0,0x0f,
0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x3c,0xf3,0x3c,0xf3,0xfc,0xff,0xfc,0xff,0x3c,0xf3,0x3c,0xf3,
0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x33,0xcc,0x33,0xcc,0x03,0xc0,0x03,0xc0,0x33,0xcc,0x33,0xcc,0xc3,0xc3,0xc3,0xc3,
0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x33,0xcc,0x33,0xcc,0x03,0xc0,0x03,0xc0,0xc3,0xc3,0xc3,0xc3,0x33,0xcc,0x33,0xcc,
0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,
0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,
0x30,0x00,0x30,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xc3,0xf0,0xc3,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0xf0,0xc3,0xf0,0xc3,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,
0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3c,0xc0,0x3c,0xc0,0xc0,0x30,0xc0,0x30,0xc0,0x0c,0xc0,0x0c,0xc0,0x03,0xc0,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x00,0xf0,0x00,
0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0x00,0x0f,0x00,0x0f,0x00,0x33,0x00,0x33,0xc0,0x30,0xc0,0x30,
0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x3c,0x00,0x3c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x3f,0xf0,0x3f,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,
0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3c,0xc0,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x0f,0xc0,0x0f,0x00,0x30,0x00,0x30,
0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0f,0x30,0x0f,0xcc,0x30,0xcc,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,
0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0xc0,0x0c,0xc0,0x0c,
0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x00,0x0c,0x00,0x0c,0x03,0x0c,0x03,0xcc,0x00,0xcc,0x00,0x3c,0x00,0x3c,0x00,0xcc,0x00,0xcc,0x00,0x0c,0x33,0x0c,0x33,
0x0c,0x0c,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,
0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xf0,0x33,0xf0,0x33,0x30,0x00,0x30,0x00,
0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x0c,0xc0,0x0c,0xc0,0x03,0xc0,0x03,
0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x00,0x30,0x00,0xc0,0x03,0xc0,0x03,0x30,0x00,0x30,0x00,0xc0,0x0f,0xc0,0x0f,
0x00,0x30,0x00,0x30,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,
0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0xcc,0x0c,0xcc,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,
0xc0,0x0c,0xc0,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xf0,0x03,0xf0,0x03,0x30,0x00,0x30,0x00,
0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0xf0,0x00,0xf0,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x0c,0x03,0x0c,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x3c,0x0c,0x3c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,
0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,
0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x30,0x3c,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,
0x30,0xf0,0x30,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0xc3,0x0c,0xc3,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x30,0x30,0x0c,0xc0,0x0c,0xc0,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,
0xf0,0x3c,0xf0,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x3c,0xf0,0x3c,0xf0,0x30,0x30,0x30,0x30,
0x3c,0xf0,0x3c,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xcc,0x00,0xcc,0x00,0xf0,0x00,0xf0,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x0f,0x00,0x0f,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,
0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xfc,0xff,0xfc,0xff,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0xfc,0xff,0xfc,0xff,0x00,0x03,0x00,0x03,0xfc,0xff,0xfc,0xff,0x30,0x00,0x30,0x00,
0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x3f,0xf0,0x3f,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,
0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xf0,0xff,0xcc,0x30,0xcc,0x30,0x30,0x0c,0x30,0x0c,0x00,0x03,0x00,0x03,0xc0,0x30,0xc0,0x30,0x30,0xcc,0x30,0xcc,
0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0xfc,0xff,0xfc,0xff,0x30,0x30,0x30,0x30,
0x30,0x30,0x30,0x30,0x3c,0xf0,0x3c,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3c,0xf0,0x3c,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0xf0,0x3c,0xf0,0x3c,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x0c,0x03,0x0c,0x03,0xcc,0x00,0xcc,0x00,0x3c,0x00,0x3c,0x00,
0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0x00,0x30,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x30,0x00,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x30,0x30,0x30,0xcc,0xcc,0xcc,0xcc,0x30,0x33,0x30,0x33,0xc0,0x0c,0xc0,0x0c,0x30,0x33,0x30,0x33,0xcc,0xcc,0xcc,0xcc,
0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xc3,0xcf,0xc3,0xcf,0x33,0xc0,0x33,0xc0,0x33,0xc0,0x33,0xc0,0xc3,0xcf,0xc3,0xcf,
0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,
0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0x0c,0x33,0x0c,0x33,0x0c,0x33,0x0c,0x33,0xf0,0x33,0xf0,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,
0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x30,0x03,0x30,0x03,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,
0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0xfc,0x33,0xfc,0x33,0x33,0xcc,0x33,0xcc,0x33,0xcc,0x33,0xcc,0xf3,0xc3,0xf3,0xc3,0x33,0xc3,0x33,0xc3,
0x3c,0x3c,0x3c,0x3c,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xcc,0xff,0xcc,0xff,0x3c,0x00,0x3c,0x00,0x3c,0xf0,0x3c,0xf0,0x3c,0x30,0x3c,0x30,0x3c,0x0c,0x3c,0x0c,0xfc,0xf3,0xfc,0xf3,
0x3c,0x00,0x3c,0x00,0xcc,0xff,0xcc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0xff,0xff,0xff,0x00,0x0c,0x00,0x0c,0x00,0xf0,0x00,0xf0,0xff,0x0f,0xff,0x0f,0x00,0x30,0x00,0x30,0xff,0x0f,0xff,0x0f,
0x00,0x0c,0x00,0x0c,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x0f,0xff,0x0f,0x00,0x30,0x00,0x30,0xff,0x0f,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x03,0xfc,0x03,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0xfc,0x03,0xfc,0x03,0x0c,0x33,0x0c,0x33,0x0c,0x0c,0x0c,0x0c,
0x0c,0xf3,0x0c,0xf3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3c,0xc0,0x3c,0xc0,0x03,0x30,0x03,0x30,0x03,0x0c,0x03,0x0c,0x3c,0x03,0x3c,0x03,0xc0,0x3c,0xc0,0x3c,0x30,0xc3,0x30,0xc3,
0x0c,0xc3,0x0c,0xc3,0x03,0x3c,0x03,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x3f,0x00,0x3f,0x00,0x3c,0x00,0x3c,0x00,0x33,0x00,0x33,0xfc,0x00,0xfc,0x00,0xc3,0x00,0xc3,0x00,0xc3,0x00,0xc3,0x00,
0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,
0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x3f,0x00,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x3f,0x00,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0xff,0xff,0xff,0x3f,0xf0,0x3f,0xf0,0xcf,0xcf,0xcf,0xcf,0xff,0xf0,0xff,0xf0,0xff,0xfc,0xff,0xfc,0xff,0xff,0xff,0xff,
0xff,0xfc,0xff,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x00,0x03,0x00,0x03,
0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0xc0,0x0c,0xc0,0x0c,
0xf0,0x3f,0xf0,0x3f,0xc0,0x0c,0xc0,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x33,0x30,0x33,
0xf0,0x3c,0xf0,0x3c,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,
0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x00,0x0c,0x00,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,0x30,0x00,0x30,0x00,0x30,0x30,0x30,0x30,
0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3c,0x30,0x3c,
0xf0,0x33,0xf0,0x33,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x30,0x03,0x30,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0xf0,0x03,0xf0,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x30,0x00,0x30,
0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xf3,0xc3,0xf3,0xc3,0x33,0xcc,0x33,0xcc,0xf3,0xc3,0xf3,0xc3,0x33,0xcc,0x33,0xcc,
0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xc3,0xcf,0xc3,0xcf,0x33,0xc0,0x33,0xc0,0x33,0xc0,0x33,0xc0,0xc3,0xcf,0xc3,0xcf,
0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0x30,0x30,0x30,0x30,0x30,0x0c,0x30,0x0c,0x30,0x03,0x30,0x03,0xc0,0x00,0xc0,0x00,0x30,0x33,0x30,0x33,
0x0c,0x3f,0x0c,0x3f,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3c,0x00,0x3c,0x00,0x30,0x30,0x30,0x30,0x3c,0x0c,0x3c,0x0c,0x30,0x03,0x30,0x03,0xfc,0x00,0xfc,0x00,0x30,0x33,0x30,0x33,
0x0c,0x3f,0x0c,0x3f,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0x30,0x30,0x30,0x30,0x30,0x0c,0x30,0x0c,0x30,0x03,0x30,0x03,0xc0,0x3c,0xc0,0x3c,0x30,0x30,0x30,0x30,
0x0c,0x0c,0x0c,0x0c,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0x0c,0x33,0x0c,0x33,0x0c,0x33,0x0c,0x33,0xf0,0x33,0xf0,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,
0x00,0x33,0x00,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x30,0x30,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,
0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,
0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x30,0x03,0x30,0x03,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,
0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,
0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,
0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
0xf0,0x0f,0xf0,0x0f,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3f,0x00,0x3f,0x00,0x0c,0x33,0x0c,0x33,0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0xc0,0xcc,0xc0,
0xcc,0xc0,0xcc,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,
0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0xfc,0x0f,0xfc,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,
0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x30,0x03,0x30,0x03,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,
0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,
0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,
0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,
0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0xcc,0x0f,0xcc,0x0f,0x3c,0x30,0x3c,0x30,0x0c,0x30,0x0c,0x30,
0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,
0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0x03,0x30,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x3f,0x0c,0x3f,0xfc,0x03,0xfc,0x03,0x0c,0x03,0x0c,0x03,
0x0c,0x3f,0x0c,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x0c,0xfc,0x0c,0x00,0x33,0x00,0x33,0xf0,0x3f,0xf0,0x3f,0x0c,0x03,0x0c,0x03,
0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,
0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,
0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xcc,0x33,0xcc,0x33,0x3c,0x30,0x3c,0x30,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x3c,0x0c,0x3c,0xcc,0x33,0xcc,0x33,0x3c,0x30,0x3c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x3c,0x30,0x3c,0x30,0xcc,0x30,0xcc,0x30,0x0c,0x33,0x0c,0x33,0x0c,0x3c,0x0c,0x3c,
0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0xfc,0x03,0xfc,0x03,0x0c,0x00,0x0c,0x00,
0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,
0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x0c,0x0c,0x0c,
0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,
0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0xfc,0x03,0xfc,0x03,0x0c,0x00,0x0c,0x00,
0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,
0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
},

{
/* CG 6 - for Model III */
/* Source: a Model III CG ROM, read by Todd P. Cromwell III (todd2_4.bin) */
/* I'm guessing this was a 3rd party replacement CG, not from Radio
   Shack.  The ROM was marked as "Model III/4 character
   generator". The normal ASCII characters are bold, and alternates
   are the upper case and numbers in inverse video. This ROM doesn't
   seem especially suited for the Model 4, which had inverse video in
   hardware. */
/* Letters start at top of cell, Model III style */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0xfc,0x0f,0xfc,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0c,0xc0,0x0c,0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0xcf,0xc0,0xcf,0x30,0x30,0x30,0x30,0x30,0x3c,0x30,0x3c,0x30,0x33,0x30,0x33,0xf0,0x30,0xf0,0x30,0x30,0x30,0x30,0x30,0xcc,0x0f,0xcc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0x30,0x0f,0x30,0x0f,0xf0,0x30,0xf0,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0xfc,0x33,0xfc,0x33,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0xfc,0x03,0xfc,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x0c,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0c,0xc0,0x0c,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x30,0x30,0x30,0x30,0xf0,0x30,0xf0,0x30,0x30,0x33,0x30,0x33,0x30,0x3c,0x30,0x3c,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0c,0xc0,0x0c,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xc3,0x00,0xc3,0xc0,0x3c,0xc0,0x3c,0x30,0x3c,0x30,0x3c,0x30,0x33,0x30,0x33,0xf0,0x30,0xf0,0x30,0xf0,0x0c,0xf0,0x0c,0x0c,0x03,0x0c,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x00,0x33,0x00,0x33,0xc0,0x0f,0xc0,0x0f,0x30,0x03,0x30,0x03,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x03,0x30,0x03,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x00,0x0c,0x00,0xfc,0x0f,0xfc,0x0f,0x0c,0x30,0x0c,0x30,0xf0,0x3f,0xf0,0x3f,0x00,0x30,0x00,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x30,0x00,0x30,0x00,0xf0,0x3f,0xf0,0x3f,0x30,0x00,0x30,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x3f,0xc0,0x3f,0x30,0x0c,0x30,0x0c,0x30,0x3c,0x30,0x3c,0xf0,0x0f,0xf0,0x0f,0x30,0x0c,0x30,0x0c,0x30,0x3c,0x30,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x00,0xf0,0x00,0xfc,0x03,0xfc,0x03,0xfc,0x03,0xfc,0x03,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0xff,0x3f,0xff,0x3f,0x3c,0x0f,0x3c,0x0f,0xff,0x3f,0xff,0x3f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x00,0xf0,0x00,0xfc,0x0f,0xfc,0x0f,0x0f,0x00,0x0f,0x00,0xfc,0x03,0xfc,0x03,0x00,0x0f,0x00,0x0f,0xff,0x03,0xff,0x03,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x0f,0x3c,0x0f,0x0f,0x0f,0x0f,0x0f,0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,0x3c,0x3c,0x3c,0x3c,0x0f,0x3c,0x0f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x03,0xf0,0x03,0x3c,0x0f,0x3c,0x0f,0xf0,0x03,0xf0,0x03,0xfc,0x3c,0xfc,0x3c,0xcf,0x0f,0xcf,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x3c,0xfc,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0xf0,0x00,0xf0,0x00,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3c,0x00,0x3c,0x00,0xf0,0x00,0xf0,0x00,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x3c,0x3c,0x3c,0xf0,0x0f,0xf0,0x0f,0xff,0xff,0xff,0xff,0xf0,0x0f,0xf0,0x0f,0x3c,0x3c,0x3c,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xff,0x0f,0xff,0x0f,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x0f,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x0f,0x00,0x0f,0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,0x3c,0x00,0x3c,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x0f,0xfc,0x0f,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0xcf,0x3c,0xcf,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x00,0xf0,0x00,0xfc,0x00,0xfc,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xff,0x0f,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0x00,0x0f,0x00,0x0f,0xf0,0x03,0xf0,0x03,0x3c,0x00,0x3c,0x00,0x0f,0x0f,0x0f,0x0f,0xff,0x0f,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0x00,0x0f,0x00,0x0f,0xf0,0x03,0xf0,0x03,0x00,0x0f,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0xf0,0x0f,0xf0,0x0f,0x3c,0x0f,0x3c,0x0f,0x0f,0x0f,0x0f,0x0f,0xff,0x3f,0xff,0x3f,0x00,0x0f,0x00,0x0f,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x0f,0xff,0x0f,0x0f,0x00,0x0f,0x00,0xff,0x03,0xff,0x03,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x03,0xf0,0x03,0x3c,0x00,0x3c,0x00,0x0f,0x00,0x0f,0x00,0xff,0x03,0xff,0x03,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x0f,0xff,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x0f,0x00,0x0f,0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x0f,0xfc,0x0f,0x00,0x0f,0x00,0x0f,0xc0,0x03,0xc0,0x03,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,0x3c,0x00,0x3c,0x00,0x0f,0x00,0x0f,0x00,0x3c,0x00,0x3c,0x00,0xf0,0x00,0xf0,0x00,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x0f,0xff,0x0f,0x00,0x00,0x00,0x00,0xff,0x0f,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3c,0x00,0x3c,0x00,0xf0,0x00,0xf0,0x00,0xc0,0x03,0xc0,0x03,0x00,0x0f,0x00,0x0f,0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0x00,0x0f,0x00,0x0f,0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x0f,0xfc,0x0f,0x0f,0x3c,0x0f,0x3c,0xcf,0x3f,0xcf,0x3f,0xcf,0x3f,0xcf,0x3f,0xcf,0x3f,0xcf,0x3f,0x0f,0x00,0x0f,0x00,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x00,0xf0,0x00,0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xff,0x0f,0xff,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x0f,0xff,0x0f,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0xfc,0x0f,0xfc,0x0f,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0xff,0x0f,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x3c,0x3c,0x3c,0x3c,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x3c,0x3c,0x3c,0x3c,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x03,0xff,0x03,0x3c,0x0f,0x3c,0x0f,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x0f,0x3c,0x0f,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x3f,0xff,0x3f,0x3c,0x30,0x3c,0x30,0x3c,0x03,0x3c,0x03,0xfc,0x03,0xfc,0x03,0x3c,0x03,0x3c,0x03,0x3c,0x30,0x3c,0x30,0xff,0x3f,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x3f,0xff,0x3f,0x3c,0x30,0x3c,0x30,0x3c,0x03,0x3c,0x03,0xfc,0x03,0xfc,0x03,0x3c,0x03,0x3c,0x03,0x3c,0x00,0x3c,0x00,0xff,0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x3c,0x3c,0x3c,0x3c,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x3f,0x0f,0x3f,0x3c,0x3c,0x3c,0x3c,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xff,0x0f,0xff,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x03,0xfc,0x03,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3f,0x3c,0x3f,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x0f,0x3c,0x0f,0xfc,0x03,0xfc,0x03,0x3c,0x0f,0x3c,0x0f,0x3c,0x3c,0x3c,0x3c,0x3f,0x3c,0x3f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x00,0xff,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x30,0x3c,0x30,0x3c,0x3c,0x3c,0x3c,0xff,0x3f,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0f,0x3c,0x0f,0x3c,0x3f,0x3f,0x3f,0x3f,0xff,0x3f,0xff,0x3f,0xff,0x3f,0xff,0x3f,0xcf,0x3c,0xcf,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0f,0x3c,0x0f,0x3c,0x3f,0x3c,0x3f,0x3c,0xff,0x3c,0xff,0x3c,0xcf,0x3f,0xcf,0x3f,0x0f,0x3f,0x0f,0x3f,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x0f,0xfc,0x0f,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x0f,0xff,0x0f,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0xfc,0x0f,0xfc,0x0f,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0xff,0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xcf,0x0f,0xcf,0x0f,0xfc,0x03,0xfc,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x0f,0xff,0x0f,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0xfc,0x0f,0xfc,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x3c,0x3c,0x3c,0x3f,0x3c,0x3f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0x3f,0x00,0x3f,0x00,0xfc,0x00,0xfc,0x00,0xc0,0x0f,0xc0,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x0f,0xff,0x0f,0xf3,0x0c,0xf3,0x0c,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xff,0x0f,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0xcf,0x3c,0xcf,0x3c,0xff,0x3f,0xff,0x3f,0x3f,0x3f,0x3f,0x3f,0x0f,0x3c,0x0f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x3c,0x0f,0x3c,0x0f,0xf0,0x03,0xf0,0x03,0xf0,0x03,0xf0,0x03,0x3c,0x0f,0x3c,0x0f,0x0f,0x3c,0x0f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x3f,0xff,0x3f,0x0f,0x3c,0x0f,0x3c,0x03,0x0f,0x03,0x0f,0xc0,0x03,0xc0,0x03,0xf0,0x30,0xf0,0x30,0x3c,0x3c,0x3c,0x3c,0xff,0x3f,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0xf0,0x00,0xf0,0x00,0xc0,0x03,0xc0,0x03,0x00,0x0f,0x00,0x0f,0x00,0x3c,0x00,0x3c,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0xf0,0x3c,0xf0,0x3c,0x3c,0xf0,0x3c,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x03,0xc0,0x03,0x00,0x0f,0x00,0x0f,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x00,0x0f,0x00,0x0f,0xfc,0x0f,0xfc,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x3c,0xfc,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3f,0x00,0x3f,0x00,0x3c,0x00,0x3c,0x00,0xfc,0x0f,0xfc,0x0f,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0xcf,0x0f,0xcf,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x0f,0x00,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x00,0x0f,0x00,0x0f,0xfc,0x0f,0xfc,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x3c,0xfc,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0xff,0x0f,0xff,0x0f,0x0f,0x00,0x0f,0x00,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x03,0xf0,0x03,0x3c,0x0f,0x3c,0x0f,0x3c,0x00,0x3c,0x00,0xff,0x00,0xff,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0xff,0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3c,0xfc,0x3c,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x0f,0xfc,0x0f,0x00,0x0f,0x00,0x0f,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3f,0x00,0x3f,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x0f,0x3c,0x0f,0xfc,0x3c,0xfc,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3f,0x3c,0x3f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3f,0x00,0x3f,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x3c,0x3c,0x3c,0x3c,0x0f,0x3c,0x0f,0xfc,0x03,0xfc,0x03,0x3c,0x0f,0x3c,0x0f,0x3f,0x3c,0x3f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x00,0xfc,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0xff,0x3f,0xff,0x3f,0xff,0x3f,0xff,0x3f,0xcf,0x3c,0xcf,0x3c,0x0f,0x3c,0x0f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcf,0x0f,0xcf,0x0f,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0xfc,0x0f,0xfc,0x0f,0x3c,0x00,0x3c,0x00,0xff,0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3c,0xfc,0x3c,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x0f,0xfc,0x0f,0x00,0x0f,0x00,0x0f,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcf,0x0f,0xcf,0x0f,0xfc,0x3c,0xfc,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x00,0x3c,0x00,0xff,0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x0f,0xfc,0x0f,0x0f,0x00,0x0f,0x00,0xfc,0x03,0xfc,0x03,0x00,0x0f,0x00,0x0f,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0xf0,0x00,0xf0,0x00,0xfc,0x0f,0xfc,0x0f,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x0c,0xf0,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x3c,0xfc,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x3c,0x0f,0x3c,0xcf,0x3c,0xcf,0x3c,0xff,0x3f,0xff,0x3f,0xff,0x3f,0xff,0x3f,0x3c,0x0f,0x3c,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x3c,0x0f,0x3c,0x3c,0x0f,0x3c,0x0f,0xf0,0x03,0xf0,0x03,0x3c,0x0f,0x3c,0x0f,0x0f,0x3c,0x0f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x0f,0xfc,0x0f,0x00,0x0f,0x00,0x0f,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x0f,0xff,0x0f,0xc3,0x03,0xc3,0x03,0xf0,0x00,0xf0,0x00,0x3c,0x0c,0x3c,0x0c,0xff,0x0f,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0f,0x00,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x00,0xf0,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x00,0xf0,0x00,0x0c,0xc3,0x0c,0xc3,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0xf0,0x3f,0xf0,0x3f,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x3c,0xf0,0x3c,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xf0,0x3f,0xf0,0x3f,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0xf0,0x3f,0xf0,0x3f,0xfc,0xff,0xfc,0xff,0xf0,0x3f,0xf0,0x3f,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x3c,0xf3,0x3c,0xf3,0xfc,0xff,0xfc,0xff,0x3c,0xf3,0x3c,0xf3,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x33,0xcc,0x33,0xcc,0x03,0xc0,0x03,0xc0,0x33,0xcc,0x33,0xcc,0xc3,0xc3,0xc3,0xc3,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x33,0xcc,0x33,0xcc,0x03,0xc0,0x03,0xc0,0xc3,0xc3,0xc3,0xc3,0x33,0xcc,0x33,0xcc,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xc3,0xf0,0xc3,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0xf0,0xc3,0xf0,0xc3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3c,0xc0,0x3c,0xc0,0xc0,0x30,0xc0,0x30,0xc0,0x0c,0xc0,0x0c,0xc0,0x03,0xc0,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0x00,0x0f,0x00,0x0f,0x00,0x33,0x00,0x33,0xc0,0x30,0xc0,0x30,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x3c,0x00,0x3c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x3f,0xf0,0x3f,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3c,0xc0,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x0f,0xc0,0x0f,0x00,0x30,0x00,0x30,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0f,0x30,0x0f,0xcc,0x30,0xcc,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x00,0x0c,0x00,0x0c,0x03,0x0c,0x03,0xcc,0x00,0xcc,0x00,0x3c,0x00,0x3c,0x00,0xcc,0x00,0xcc,0x00,0x0c,0x33,0x0c,0x33,0x0c,0x0c,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xf0,0x33,0xf0,0x33,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x0c,0xc0,0x0c,0xc0,0x03,0xc0,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x00,0x30,0x00,0xc0,0x03,0xc0,0x03,0x30,0x00,0x30,0x00,0xc0,0x0f,0xc0,0x0f,0x00,0x30,0x00,0x30,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0xcc,0x0c,0xcc,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xf0,0x03,0xf0,0x03,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x0c,0x03,0x0c,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x3c,0x0c,0x3c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x30,0x3c,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0xf0,0x30,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0xc3,0x0c,0xc3,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x30,0x30,0x0c,0xc0,0x0c,0xc0,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0xf0,0x3c,0xf0,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x3c,0xf0,0x3c,0xf0,0x30,0x30,0x30,0x30,0x3c,0xf0,0x3c,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xcc,0x00,0xcc,0x00,0xf0,0x00,0xf0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x3f,0xfc,0x3f,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x0f,0x00,0x0f,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xfc,0xff,0xfc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0xfc,0xff,0xfc,0xff,0x00,0x03,0x00,0x03,0xfc,0xff,0xfc,0xff,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x3f,0xf0,0x3f,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xf0,0xff,0xcc,0x30,0xcc,0x30,0x30,0x0c,0x30,0x0c,0x00,0x03,0x00,0x03,0xc0,0x30,0xc0,0x30,0x30,0xcc,0x30,0xcc,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0xfc,0xff,0xfc,0xff,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3c,0xf0,0x3c,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3c,0xf0,0x3c,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0xf0,0x3c,0xf0,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x0c,0x03,0x0c,0x03,0xcc,0x00,0xcc,0x00,0x3c,0x00,0x3c,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0x00,0x30,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x30,0x00,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x30,0x30,0x30,0xcc,0xcc,0xcc,0xcc,0x30,0x33,0x30,0x33,0xc0,0x0c,0xc0,0x0c,0x30,0x33,0x30,0x33,0xcc,0xcc,0xcc,0xcc,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xc3,0xc3,0xc3,0xc3,0x33,0xc0,0x33,0xc0,0x33,0xc0,0x33,0xc0,0xc3,0xc3,0xc3,0xc3,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0x0c,0x33,0x0c,0x33,0x0c,0x33,0x0c,0x33,0xf0,0x33,0xf0,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x30,0x03,0x30,0x03,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0xfc,0x33,0xfc,0x33,0x33,0xcc,0x33,0xcc,0x33,0xcc,0x33,0xcc,0xf3,0xc3,0xf3,0xc3,0x33,0xc3,0x33,0xc3,0x3c,0x3c,0x3c,0x3c,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xcc,0xff,0xcc,0xff,0x3c,0x00,0x3c,0x00,0x3c,0xf0,0x3c,0xf0,0x3c,0x30,0x3c,0x30,0x3c,0x0c,0x3c,0x0c,0xfc,0xf3,0xfc,0xf3,0x3c,0x00,0x3c,0x00,0xcc,0xff,0xcc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0xff,0xff,0xff,0x00,0x0c,0x00,0x0c,0x00,0xf0,0x00,0xf0,0xff,0x0f,0xff,0x0f,0x00,0x30,0x00,0x30,0xff,0x0f,0xff,0x0f,0x00,0x0c,0x00,0x0c,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x0f,0xff,0x0f,0x00,0x30,0x00,0x30,0xff,0x0f,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0x03,0xfc,0x03,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0xfc,0x03,0xfc,0x03,0x0c,0x33,0x0c,0x33,0x0c,0x0c,0x0c,0x0c,0x0c,0xf3,0x0c,0xf3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3c,0x00,0x3c,0x00,0x03,0x30,0x03,0x30,0x03,0x0c,0x03,0x0c,0x3c,0x03,0x3c,0x03,0xc0,0x3c,0xc0,0x3c,0x30,0xc3,0x30,0xc3,0x0c,0xc3,0x0c,0xc3,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x3f,0x00,0x3f,0x00,0x3c,0x00,0x3c,0x00,0x33,0x00,0x33,0xfc,0x00,0xfc,0x00,0xc3,0x00,0xc3,0x00,0xc3,0x00,0xc3,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x3f,0x00,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x3f,0x00,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0xff,0xff,0xff,0x3f,0xf0,0x3f,0xf0,0xcf,0xcf,0xcf,0xcf,0xff,0xf0,0xff,0xf0,0xff,0xfc,0xff,0xfc,0xff,0xff,0xff,0xff,0xff,0xfc,0xff,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0xc0,0x0c,0xc0,0x0c,0xf0,0x3f,0xf0,0x3f,0xc0,0x0c,0xc0,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xf0,0x3c,0xf0,0x3c,0xfc,0xff,0xfc,0xff,0x3c,0xf0,0x3c,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0f,0xff,0x0f,0xff,0x03,0xfc,0x03,0xfc,0x03,0xfc,0x03,0xfc,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0x00,0xc0,0x00,0xc0,0xc3,0xf0,0xc3,0xf0,0x00,0xc0,0x00,0xc0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0f,0xff,0x0f,0xff,0x03,0xf0,0x03,0xf0,0xf0,0xff,0xf0,0xff,0x03,0xfc,0x03,0xfc,0xff,0xf0,0xff,0xf0,0x00,0xfc,0x00,0xfc,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0xff,0xff,0xff,0xc3,0xf0,0xc3,0xf0,0xf0,0xf0,0xf0,0xf0,0x3f,0xfc,0x3f,0xfc,0x0f,0xff,0x0f,0xff,0xc3,0xc3,0xc3,0xc3,0xf0,0xc3,0xf0,0xc3,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0f,0xfc,0x0f,0xfc,0xc3,0xf0,0xc3,0xf0,0x0f,0xfc,0x0f,0xfc,0x03,0xc3,0x03,0xc3,0x30,0xf0,0x30,0xf0,0xf0,0xf0,0xf0,0xf0,0x03,0xc3,0x03,0xc3,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc3,0xff,0xc3,0xff,0xc3,0xff,0xc3,0xff,0xf0,0xff,0xf0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3f,0xfc,0x3f,0xfc,0x0f,0xff,0x0f,0xff,0xc3,0xff,0xc3,0xff,0xc3,0xff,0xc3,0xff,0xc3,0xff,0xc3,0xff,0x0f,0xff,0x0f,0xff,0x3f,0xfc,0x3f,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc3,0xff,0xc3,0xff,0x0f,0xff,0x0f,0xff,0x3f,0xfc,0x3f,0xfc,0x3f,0xfc,0x3f,0xfc,0x3f,0xfc,0x3f,0xfc,0x0f,0xff,0x0f,0xff,0xc3,0xff,0xc3,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0xff,0xff,0xff,0xc3,0xc3,0xc3,0xc3,0x0f,0xf0,0x0f,0xf0,0x00,0x00,0x00,0x00,0x0f,0xf0,0x0f,0xf0,0xc3,0xc3,0xc3,0xc3,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0xff,0xff,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x00,0xf0,0x00,0xf0,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0xc3,0xff,0xc3,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xf0,0x00,0xf0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0xff,0xff,0xff,0xff,0xc3,0xff,0xc3,0xff,0xf0,0xff,0xf0,0x3f,0xfc,0x3f,0xfc,0x0f,0xff,0x0f,0xff,0xc3,0xff,0xc3,0xff,0xf0,0xff,0xf0,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0xf0,0x03,0xf0,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0x30,0xc3,0x30,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0x03,0xf0,0x03,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0f,0xff,0x0f,0xff,0x03,0xff,0x03,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x00,0xf0,0x00,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0xfc,0x03,0xfc,0xf0,0xf0,0xf0,0xf0,0xff,0xf0,0xff,0xf0,0x0f,0xfc,0x0f,0xfc,0xc3,0xff,0xc3,0xff,0xf0,0xf0,0xf0,0xf0,0x00,0xf0,0x00,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0xfc,0x03,0xfc,0xf0,0xf0,0xf0,0xf0,0xff,0xf0,0xff,0xf0,0x0f,0xfc,0x0f,0xfc,0xff,0xf0,0xff,0xf0,0xf0,0xf0,0xf0,0xf0,0x03,0xfc,0x03,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3f,0xf0,0x3f,0xf0,0x0f,0xf0,0x0f,0xf0,0xc3,0xf0,0xc3,0xf0,0xf0,0xf0,0xf0,0xf0,0x00,0xc0,0x00,0xc0,0xff,0xf0,0xff,0xf0,0x3f,0xc0,0x3f,0xc0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf0,0x00,0xf0,0xf0,0xff,0xf0,0xff,0x00,0xfc,0x00,0xfc,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0x03,0xfc,0x03,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0f,0xfc,0x0f,0xfc,0xc3,0xff,0xc3,0xff,0xf0,0xff,0xf0,0xff,0x00,0xfc,0x00,0xfc,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x03,0xfc,0x03,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf0,0x00,0xf0,0xf0,0xf0,0xf0,0xf0,0xff,0xf0,0xff,0xf0,0x3f,0xfc,0x3f,0xfc,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0xfc,0x03,0xfc,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x03,0xfc,0x03,0xfc,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x03,0xfc,0x03,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0xfc,0x03,0xfc,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x03,0xf0,0x03,0xf0,0xff,0xf0,0xff,0xf0,0x3f,0xfc,0x3f,0xfc,0x03,0xff,0x03,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0xff,0xff,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0xff,0xff,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0xc3,0xff,0xc3,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3f,0xfc,0x3f,0xfc,0x0f,0xff,0x0f,0xff,0xc3,0xff,0xc3,0xff,0xf0,0xff,0xf0,0xff,0xc3,0xff,0xc3,0xff,0x0f,0xff,0x0f,0xff,0x3f,0xfc,0x3f,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xf0,0x00,0xf0,0xff,0xff,0xff,0xff,0x00,0xf0,0x00,0xf0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc3,0xff,0xc3,0xff,0x0f,0xff,0x0f,0xff,0x3f,0xfc,0x3f,0xfc,0xff,0xf0,0xff,0xf0,0x3f,0xfc,0x3f,0xfc,0x0f,0xff,0x0f,0xff,0xc3,0xff,0xc3,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0xfc,0x03,0xfc,0xf0,0xf0,0xf0,0xf0,0xff,0xf0,0xff,0xf0,0x3f,0xfc,0x3f,0xfc,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0xf0,0x03,0xf0,0xf0,0xc3,0xf0,0xc3,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xf0,0xff,0xf0,0xff,0x03,0xfc,0x03,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0f,0xff,0x0f,0xff,0x03,0xfc,0x03,0xfc,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x00,0xf0,0x00,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf0,0x00,0xf0,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0x03,0xf0,0x03,0xf0,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0x00,0xf0,0x00,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0f,0xf0,0x0f,0xf0,0xc3,0xc3,0xc3,0xc3,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xc3,0xc3,0xc3,0xc3,0x0f,0xf0,0x0f,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xfc,0x00,0xfc,0xc3,0xf0,0xc3,0xf0,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xf0,0xc3,0xf0,0x00,0xfc,0x00,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xc0,0x00,0xc0,0xc3,0xcf,0xc3,0xcf,0xc3,0xfc,0xc3,0xfc,0x03,0xfc,0x03,0xfc,0xc3,0xfc,0xc3,0xfc,0xc3,0xcf,0xc3,0xcf,0x00,0xc0,0x00,0xc0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xc0,0x00,0xc0,0xc3,0xcf,0xc3,0xcf,0xc3,0xfc,0xc3,0xfc,0x03,0xfc,0x03,0xfc,0xc3,0xfc,0xc3,0xfc,0xc3,0xff,0xc3,0xff,0x00,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0f,0xf0,0x0f,0xf0,0xc3,0xc3,0xc3,0xc3,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xc0,0xf0,0xc0,0xc3,0xc3,0xc3,0xc3,0x0f,0xf0,0x0f,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x00,0xf0,0x00,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0xfc,0x03,0xfc,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x03,0xfc,0x03,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3f,0xc0,0x3f,0xc0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x03,0xfc,0x03,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0xc3,0xc0,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xf0,0xc3,0xf0,0x03,0xfc,0x03,0xfc,0xc3,0xf0,0xc3,0xf0,0xc3,0xc3,0xc3,0xc3,0xc0,0xc3,0xc0,0xc3,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xff,0x00,0xff,0xc3,0xff,0xc3,0xff,0xc3,0xff,0xc3,0xff,0xc3,0xff,0xc3,0xff,0xc3,0xcf,0xc3,0xcf,0xc3,0xc3,0xc3,0xc3,0x00,0xc0,0x00,0xc0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xc3,0xf0,0xc3,0xc0,0xc0,0xc0,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x30,0xc3,0x30,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xc3,0xf0,0xc3,0xc0,0xc3,0xc0,0xc3,0x00,0xc3,0x00,0xc3,0x30,0xc0,0x30,0xc0,0xf0,0xc0,0xf0,0xc0,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0xf0,0x03,0xf0,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0x03,0xf0,0x03,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf0,0x00,0xf0,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0x03,0xf0,0x03,0xf0,0xc3,0xff,0xc3,0xff,0xc3,0xff,0xc3,0xff,0x00,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0xfc,0x03,0xfc,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x30,0xf0,0x30,0xf0,0x03,0xfc,0x03,0xfc,0x3f,0xf0,0x3f,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf0,0x00,0xf0,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0x03,0xf0,0x03,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xc3,0xc3,0xc3,0xc0,0xc3,0xc0,0xc3,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0xfc,0x03,0xfc,0xf0,0xf0,0xf0,0xf0,0xc0,0xff,0xc0,0xff,0x03,0xff,0x03,0xff,0x3f,0xf0,0x3f,0xf0,0xf0,0xf0,0xf0,0xf0,0x03,0xfc,0x03,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf0,0x00,0xf0,0x0c,0xf3,0x0c,0xf3,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x03,0xfc,0x03,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x00,0xf0,0x00,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x03,0xfc,0x03,0xfc,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0x30,0xc3,0x30,0xc3,0x00,0xc0,0x00,0xc0,0xc0,0xc0,0xc0,0xc0,0xf0,0xc3,0xf0,0xc3,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xc3,0xf0,0xc3,0xf0,0x0f,0xfc,0x0f,0xfc,0x0f,0xfc,0x0f,0xfc,0xc3,0xf0,0xc3,0xf0,0xf0,0xc3,0xf0,0xc3,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x03,0xfc,0x03,0xfc,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x03,0xfc,0x03,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xc0,0x00,0xc0,0xf0,0xc3,0xf0,0xc3,0xfc,0xf0,0xfc,0xf0,0x3f,0xfc,0x3f,0xfc,0x0f,0xcf,0x0f,0xcf,0xc3,0xc3,0xc3,0xc3,0x00,0xc0,0x00,0xc0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0f,0xf0,0x0f,0xf0,0xcf,0xff,0xcf,0xff,0xcf,0xff,0xcf,0xff,0xcf,0xff,0xcf,0xff,0xcf,0xff,0xcf,0xff,0xcf,0xff,0xcf,0xff,0x0f,0xf0,0x0f,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0xff,0xff,0xff,0xc3,0xff,0xc3,0xff,0x0f,0xff,0x0f,0xff,0x3f,0xfc,0x3f,0xfc,0xff,0xf0,0xff,0xf0,0xff,0xc3,0xff,0xc3,0xff,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0f,0xf0,0x0f,0xf0,0xff,0xf3,0xff,0xf3,0xff,0xf3,0xff,0xf3,0xff,0xf3,0xff,0xf3,0xff,0xf3,0xff,0xf3,0xff,0xf3,0xff,0xf3,0x0f,0xf0,0x0f,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0xfc,0xff,0xfc,0x3f,0xf0,0x3f,0xf0,0x0f,0xc3,0x0f,0xc3,0xc3,0x0f,0xc3,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x03,0xf0,0x03,0xcc,0x0c,0xcc,0x0c,0xfc,0x0f,0xfc,0x0f,0x30,0x03,0x30,0x03,0xf0,0x03,0xf0,0x03,0x0f,0x3c,0x0f,0x3c,0xf0,0x03,0xf0,0x03,0x0f,0x3c,0x0f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
},

{
/* CG 7 - for Model 4/4P */
/* Source: A model III CG ROM, read by Todd P. Cromwell III (todd2.bin) */
/* This is the older CG with Katakana alternate characters */
/* Letters shifted 1 line down by mann to match M4 style */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0xfc,0x0f,0xfc,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0c,0xc0,0x0c,0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0xcf,0xc0,0xcf,0x30,0x30,0x30,0x30,0x30,0x3c,0x30,0x3c,0x30,0x33,0x30,0x33,0xf0,0x30,0xf0,0x30,0x30,0x30,0x30,0x30,0xcc,0x0f,0xcc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0x30,0x0f,0x30,0x0f,0xf0,0x30,0xf0,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0xfc,0x33,0xfc,0x33,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0xfc,0x03,0xfc,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x0c,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0c,0xc0,0x0c,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x30,0x30,0x30,0x30,0xf0,0x30,0xf0,0x30,0x30,0x33,0x30,0x33,0x30,0x3c,0x30,0x3c,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x0c,0xc0,0x0c,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xc3,0x00,0xc3,0xc0,0x3c,0xc0,0x3c,0x30,0x3c,0x30,0x3c,0x30,0x33,0x30,0x33,0xf0,0x30,0xf0,0x30,0xf0,0x0c,0xf0,0x0c,0x0c,0x03,0x0c,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x00,0x33,0x00,0x33,0xc0,0x0f,0xc0,0x0f,0x30,0x03,0x30,0x03,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x03,0x30,0x03,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x00,0x0c,0x00,0xfc,0x0f,0xfc,0x0f,0x0c,0x30,0x0c,0x30,0xf0,0x3f,0xf0,0x3f,0x00,0x30,0x00,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x30,0x00,0x30,0x00,0xf0,0x3f,0xf0,0x3f,0x30,0x00,0x30,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x3f,0xc0,0x3f,0x30,0x0c,0x30,0x0c,0x30,0x3c,0x30,0x3c,0xf0,0x0f,0xf0,0x0f,0x30,0x0c,0x30,0x0c,0x30,0x3c,0x30,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xfc,0x3f,0xfc,0x3f,0x30,0x0c,0x30,0x0c,0xfc,0x3f,0xfc,0x3f,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x3f,0xc0,0x3f,0x30,0x03,0x30,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x33,0x00,0x33,0xf0,0x0f,0xf0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x30,0x3c,0x30,0x3c,0x0c,0x3c,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x3c,0x30,0x3c,0x0c,0x3c,0x0c,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0xf0,0x00,0xf0,0x00,0x0c,0x33,0x0c,0x33,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0xf0,0x3f,0xf0,0x3f,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xcc,0x33,0xcc,0x33,0x3c,0x30,0x3c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x03,0xc0,0x03,0x30,0x03,0x30,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x00,0x30,0x00,0x30,0x00,0x0f,0x00,0x0f,0xf0,0x00,0xf0,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x00,0x30,0x00,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x30,0x00,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x0f,0x00,0x0f,0xc0,0x0c,0xc0,0x0c,0x30,0x0c,0x30,0x0c,0xfc,0x3f,0xfc,0x3f,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0xfc,0x03,0xfc,0x03,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x0c,0x0c,0x0c,0x0c,0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x0f,0xfc,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x3f,0xf0,0x3f,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x0f,0x00,0x0f,0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,0xc0,0x03,0xc0,0x03,0x00,0x0f,0x00,0x0f,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0xf0,0x00,0xf0,0x00,0xc0,0x03,0xc0,0x03,0x00,0x0f,0x00,0x0f,0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x00,0x30,0x00,0x30,0x00,0x0f,0x00,0x0f,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0x33,0x0c,0x33,0xcc,0x3c,0xcc,0x3c,0x0c,0x0f,0x0c,0x0f,0x30,0x00,0x30,0x00,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x0f,0xfc,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x30,0x0c,0x30,0x0c,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x0c,0x30,0x0c,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x03,0xfc,0x03,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x03,0xfc,0x03,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0x00,0x0c,0x00,0x0c,0x3f,0x0c,0x3f,0x0c,0x30,0x0c,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0x00,0x3f,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x0c,0x0c,0x0c,0x0c,0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x0c,0x0c,0x0c,0x0c,0x03,0x0c,0x03,0xfc,0x00,0xfc,0x00,0x0c,0x03,0x0c,0x03,0x0c,0x0c,0x0c,0x0c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x3c,0x3c,0x3c,0x3c,0xcc,0x33,0xcc,0x33,0xcc,0x33,0xcc,0x33,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x3c,0x30,0x3c,0x30,0xcc,0x30,0xcc,0x30,0x0c,0x33,0x0c,0x33,0x0c,0x3c,0x0c,0x3c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x0f,0xfc,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xfc,0x0f,0xfc,0x0f,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x33,0x0c,0x33,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x0f,0xfc,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xfc,0x0f,0xfc,0x0f,0x0c,0x03,0x0c,0x03,0x0c,0x0c,0x0c,0x0c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x30,0x00,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xcc,0x33,0xcc,0x33,0xcc,0x33,0xcc,0x33,0x3c,0x3c,0x3c,0x3c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xcc,0x0f,0xcc,0x0f,0x3c,0x30,0x3c,0x30,0x0c,0x30,0x0c,0x30,0x3c,0x30,0x3c,0x30,0xcc,0x0f,0xcc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x00,0x0c,0x00,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xf0,0x33,0xf0,0x33,0x0c,0x3c,0x0c,0x3c,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0xfc,0x0f,0xfc,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x33,0xf0,0x33,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x30,0x00,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xcc,0x0f,0xcc,0x0f,0x3c,0x30,0x3c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x0c,0x0c,0x0c,0x0c,0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x0c,0x0c,0x0c,0x0c,0x03,0x0c,0x03,0xcc,0x00,0xcc,0x00,0x3c,0x03,0x3c,0x03,0x0c,0x0c,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3c,0xfc,0x3c,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcc,0x0f,0xcc,0x0f,0x3c,0x30,0x3c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcc,0x0f,0xcc,0x0f,0x3c,0x30,0x3c,0x30,0x3c,0x30,0x3c,0x30,0xcc,0x0f,0xcc,0x0f,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x33,0xf0,0x33,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcc,0x0f,0xcc,0x0f,0x3c,0x30,0x3c,0x30,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x30,0x00,0x30,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xfc,0x0f,0xfc,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0xc0,0x0c,0xc0,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0xf0,0x3c,0xf0,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x30,0x00,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x0c,0x00,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x00,0x30,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0x0c,0xc3,0x0c,0xc3,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0xf0,0x3f,0xf0,0x3f,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3c,0xf0,0x3c,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xf0,0x3f,0xf0,0x3f,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0xf0,0x3f,0xf0,0x3f,0xfc,0xff,0xfc,0xff,0xf0,0x3f,0xf0,0x3f,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x3c,0xf3,0x3c,0xf3,0xfc,0xff,0xfc,0xff,0x3c,0xf3,0x3c,0xf3,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x33,0xcc,0x33,0xcc,0x03,0xc0,0x03,0xc0,0x33,0xcc,0x33,0xcc,0xc3,0xc3,0xc3,0xc3,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x33,0xcc,0x33,0xcc,0x03,0xc0,0x03,0xc0,0xc3,0xc3,0xc3,0xc3,0x33,0xcc,0x33,0xcc,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xc3,0xf0,0xc3,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0xf0,0xc3,0xf0,0xc3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0xc0,0x3c,0xc0,0xc0,0x30,0xc0,0x30,0xc0,0x0c,0xc0,0x0c,0xc0,0x03,0xc0,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0x00,0x0f,0x00,0x0f,0x00,0x33,0x00,0x33,0xc0,0x30,0xc0,0x30,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x3f,0xf0,0x3f,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x3c,0xc0,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x0f,0xc0,0x0f,0x00,0x30,0x00,0x30,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0f,0x30,0x0f,0xcc,0x30,0xcc,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x03,0x0c,0x03,0xcc,0x00,0xcc,0x00,0x3c,0x00,0x3c,0x00,0xcc,0x00,0xcc,0x00,0x0c,0x33,0x0c,0x33,0x0c,0x0c,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xf0,0x33,0xf0,0x33,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x0c,0xc0,0x0c,0xc0,0x03,0xc0,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x00,0x30,0x00,0xc0,0x03,0xc0,0x03,0x30,0x00,0x30,0x00,0xc0,0x0f,0xc0,0x0f,0x00,0x30,0x00,0x30,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0xcc,0x0c,0xcc,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xf0,0x03,0xf0,0x03,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x0c,0x03,0x0c,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x3c,0x0c,0x3c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x30,0x3c,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0xf0,0x30,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0xc3,0x0c,0xc3,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x30,0x30,0x0c,0xc0,0x0c,0xc0,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0xf0,0x3c,0xf0,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x3c,0xf0,0x3c,0xf0,0x30,0x30,0x30,0x30,0x3c,0xf0,0x3c,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x3f,0xc0,0x3f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xcc,0x00,0xcc,0x00,0xf0,0x00,0xf0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x0f,0x00,0x0f,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xfc,0xff,0xfc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0xfc,0xff,0xfc,0xff,0x00,0x03,0x00,0x03,0xfc,0xff,0xfc,0xff,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x3f,0xf0,0x3f,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0xff,0xf0,0xff,0xcc,0x30,0xcc,0x30,0x30,0x0c,0x30,0x0c,0x00,0x03,0x00,0x03,0xc0,0x30,0xc0,0x30,0x30,0xcc,0x30,0xcc,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0xfc,0xff,0xfc,0xff,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3c,0xf0,0x3c,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3c,0xf0,0x3c,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0xf0,0x3c,0xf0,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x0c,0x03,0x0c,0x03,0xcc,0x00,0xcc,0x00,0x3c,0x00,0x3c,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x3f,0xc0,0x3f,0x30,0x00,0x30,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x30,0x00,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x30,0x30,0x30,0xcc,0xcc,0xcc,0xcc,0x30,0x33,0x30,0x33,0xc0,0x0c,0xc0,0x0c,0x30,0x33,0x30,0x33,0xcc,0xcc,0xcc,0xcc,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xc3,0xcf,0xc3,0xcf,0x33,0xc0,0x33,0xc0,0x33,0xc0,0x33,0xc0,0xc3,0xcf,0xc3,0xcf,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x0c,0x33,0x0c,0x33,0x0c,0x33,0x0c,0x33,0xf0,0x33,0xf0,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x30,0x03,0x30,0x03,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0xfc,0x33,0xfc,0x33,0x33,0xcc,0x33,0xcc,0x33,0xcc,0x33,0xcc,0xf3,0xc3,0xf3,0xc3,0x33,0xc3,0x33,0xc3,0x3c,0x3c,0x3c,0x3c,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xcc,0xff,0xcc,0xff,0x3c,0x00,0x3c,0x00,0x3c,0xf0,0x3c,0xf0,0x3c,0x30,0x3c,0x30,0x3c,0x0c,0x3c,0x0c,0xfc,0xf3,0xfc,0xf3,0x3c,0x00,0x3c,0x00,0xcc,0xff,0xcc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x0c,0x00,0x0c,0x00,0xf0,0x00,0xf0,0xff,0x0f,0xff,0x0f,0x00,0x30,0x00,0x30,0xff,0x0f,0xff,0x0f,0x00,0x0c,0x00,0x0c,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x0f,0xff,0x0f,0x00,0x30,0x00,0x30,0xff,0x0f,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0xfc,0x03,0xfc,0x03,0x0c,0x33,0x0c,0x33,0x0c,0x0c,0x0c,0x0c,0x0c,0xf3,0x0c,0xf3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0xc0,0x3c,0xc0,0x03,0x30,0x03,0x30,0x03,0x0c,0x03,0x0c,0x3c,0x03,0x3c,0x03,0xc0,0x3c,0xc0,0x3c,0x30,0xc3,0x30,0xc3,0x0c,0xc3,0x0c,0xc3,0x03,0x3c,0x03,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0x00,0x3f,0x00,0x3c,0x00,0x3c,0x00,0x33,0x00,0x33,0xfc,0x00,0xfc,0x00,0xc3,0x00,0xc3,0x00,0xc3,0x00,0xc3,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0x00,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x3f,0x00,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x3f,0xf0,0x3f,0xf0,0xcf,0xcf,0xcf,0xcf,0xff,0xf0,0xff,0xf0,0xff,0xfc,0xff,0xfc,0xff,0xff,0xff,0xff,0xff,0xfc,0xff,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0xc0,0x0c,0xc0,0x0c,0xf0,0x3f,0xf0,0x3f,0xc0,0x0c,0xc0,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x33,0x30,0x33,0xf0,0x3c,0xf0,0x3c,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x30,0x30,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x30,0x00,0x30,0x00,0x0f,0x00,0x0f,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x03,0xc0,0x03,0x30,0x03,0x30,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xf0,0x0f,0xf0,0x0f,0xc0,0x03,0xc0,0x03,0x30,0x03,0x30,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0xf0,0x3f,0xf0,0x3f,0xc0,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x30,0x00,0x30,0xc0,0x3f,0xc0,0x3f,0x00,0x30,0x00,0x30,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x30,0x30,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0xc0,0x0c,0xc0,0x0c,0xc0,0x03,0xc0,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x03,0xc0,0x03,0x30,0x03,0x30,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xfc,0x3f,0xfc,0x3f,0x00,0x03,0x00,0x03,0xc0,0x03,0xc0,0x03,0x30,0x03,0x30,0x03,0x0c,0x03,0x0c,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0xfc,0x3f,0xfc,0x3f,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0x30,0x30,0x30,0x30,0x0c,0x3f,0x0c,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x0c,0x30,0x0c,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0x3f,0xf0,0x3f,0x30,0x03,0x30,0x03,0x0c,0x03,0x0c,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0xfc,0x3f,0xfc,0x3f,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x30,0x00,0x30,0xfc,0x30,0xfc,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0xfc,0x3f,0xfc,0x3f,0xc0,0x30,0xc0,0x30,0xc0,0x0c,0xc0,0x0c,0xc0,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x30,0x30,0x30,0x30,0xc0,0x30,0xc0,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x33,0x00,0x33,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x33,0x00,0x33,0xfc,0x0f,0xfc,0x0f,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0x03,0xf0,0x03,0x30,0x0c,0x30,0x0c,0x30,0x30,0x30,0x30,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x0f,0x00,0x0f,0xc0,0x33,0xc0,0x33,0x30,0x03,0x30,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0xc0,0x30,0xc0,0x30,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x30,0x03,0x30,0x03,0x0c,0x0c,0x0c,0x0c,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x03,0x0c,0x03,0x0c,0x0c,0x0c,0x0c,0xfc,0x33,0xfc,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x30,0x30,0x30,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0xc0,0x00,0xc0,0x00,0xf0,0x0f,0xf0,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0xfc,0x3f,0xfc,0x3f,0xc0,0x30,0xc0,0x30,0xc0,0x0c,0xc0,0x0c,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xf0,0x3f,0xf0,0x3f,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x30,0x30,0x30,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x0c,0x0c,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x00,0xcc,0x30,0xcc,0x30,0xcc,0x30,0xcc,0x30,0xcc,0x0c,0xcc,0x0c,0xcc,0x03,0xcc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x0c,0x30,0x0c,0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x30,0xfc,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x0c,0x03,0x0c,0x03,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x0c,0x03,0x0c,0x03,0x30,0x0c,0x30,0x0c,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xcc,0x00,0xcc,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
},

{
/* CG 8 - for Model 4/4P */
/* Source: Reed M4 emulator (reedm4l.xbm, reedm4la.xbm). Checked
   by eye against my Model 4P. I should really pull out the ROM and read
   it directly to be sure this is right. Apologies to Matthew Reed. */
/* This is the newer CG with international alternate characters.
   Characters 0-31 are also different from the older CG. */
/* Letters start one line from top of cell, Model 4 style */
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,0x30,0x00,0x30,0x00,0x30,0x30,0x30,0x30,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x30,0x00,0x30,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x30,0x03,0x30,0x03,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x00,0x0c,0x00,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xfc,0xff,0x0c,0xc0,0x0c,0xc0,0xfc,0xff,0xfc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x30,0x03,0x30,0x03,0xf0,0x00,0xf0,0x00,0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x0f,0x00,0x0f,0x00,0x3f,0x00,0x3f,0x00,0xff,0x00,0xff,0x00,0xff,0x03,0xff,0x03,0xff,0x0f,0xff,0x0f,0xff,0x3f,0xff,0x3f,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0xc0,0x0f,0xc0,0x0f,0xc0,0x0c,0xc0,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0xfc,0x0f,0xfc,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xfc,0x3f,0xfc,0x3f,0x30,0x0c,0x30,0x0c,0xfc,0x3f,0xfc,0x3f,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x3f,0xc0,0x3f,0x30,0x03,0x30,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x33,0x00,0x33,0xf0,0x0f,0xf0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x30,0x3c,0x30,0x3c,0x0c,0x3c,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x3c,0x30,0x3c,0x0c,0x3c,0x0c,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0xf0,0x00,0xf0,0x00,0x0c,0x33,0x0c,0x33,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0xf0,0x3f,0xf0,0x3f,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xcc,0x33,0xcc,0x33,0x3c,0x30,0x3c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x03,0xc0,0x03,0x30,0x03,0x30,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x00,0x30,0x00,0x30,0x00,0x0f,0x00,0x0f,0xf0,0x00,0xf0,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x00,0x30,0x00,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x30,0x00,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x0f,0x00,0x0f,0xc0,0x0c,0xc0,0x0c,0x30,0x0c,0x30,0x0c,0xfc,0x3f,0xfc,0x3f,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0xfc,0x03,0xfc,0x03,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x0c,0x0c,0x0c,0x0c,0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x0f,0xfc,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x3f,0xf0,0x3f,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x0f,0x00,0x0f,0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,0xc0,0x03,0xc0,0x03,0x00,0x0f,0x00,0x0f,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0xf0,0x00,0xf0,0x00,0xc0,0x03,0xc0,0x03,0x00,0x0f,0x00,0x0f,0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x00,0x30,0x00,0x30,0x00,0x0f,0x00,0x0f,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0x33,0x0c,0x33,0xcc,0x3c,0xcc,0x3c,0x0c,0x0f,0x0c,0x0f,0x30,0x00,0x30,0x00,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x0f,0xfc,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x30,0x0c,0x30,0x0c,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x0c,0x30,0x0c,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x03,0xfc,0x03,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x03,0xfc,0x03,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0x00,0x0c,0x00,0x0c,0x3f,0x0c,0x3f,0x0c,0x30,0x0c,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0x00,0x3f,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x0c,0x0c,0x0c,0x0c,0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x0c,0x0c,0x0c,0x0c,0x03,0x0c,0x03,0xfc,0x00,0xfc,0x00,0x0c,0x03,0x0c,0x03,0x0c,0x0c,0x0c,0x0c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x3c,0x3c,0x3c,0x3c,0xcc,0x33,0xcc,0x33,0xcc,0x33,0xcc,0x33,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x3c,0x30,0x3c,0x30,0xcc,0x30,0xcc,0x30,0x0c,0x33,0x0c,0x33,0x0c,0x3c,0x0c,0x3c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x0f,0xfc,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xfc,0x0f,0xfc,0x0f,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x33,0x0c,0x33,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x0f,0xfc,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xfc,0x0f,0xfc,0x0f,0x0c,0x03,0x0c,0x03,0x0c,0x0c,0x0c,0x0c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x30,0x00,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xcc,0x33,0xcc,0x33,0xcc,0x33,0xcc,0x33,0x3c,0x3c,0x3c,0x3c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xcc,0x0f,0xcc,0x0f,0x3c,0x30,0x3c,0x30,0x0c,0x30,0x0c,0x30,0x3c,0x30,0x3c,0x30,0xcc,0x0f,0xcc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x00,0x0c,0x00,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xf0,0x33,0xf0,0x33,0x0c,0x3c,0x0c,0x3c,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0xfc,0x0f,0xfc,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x33,0xf0,0x33,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x30,0x00,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0xcc,0x0f,0xcc,0x0f,0x3c,0x30,0x3c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x0c,0x0c,0x0c,0x0c,0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x0c,0x0c,0x0c,0x0c,0x03,0x0c,0x03,0xcc,0x00,0xcc,0x00,0x3c,0x03,0x3c,0x03,0x0c,0x0c,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3c,0xfc,0x3c,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcc,0x0f,0xcc,0x0f,0x3c,0x30,0x3c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcc,0x0f,0xcc,0x0f,0x3c,0x30,0x3c,0x30,0x3c,0x30,0x3c,0x30,0xcc,0x0f,0xcc,0x0f,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x33,0xf0,0x33,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcc,0x0f,0xcc,0x0f,0x3c,0x30,0x3c,0x30,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x30,0x00,0x30,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xfc,0x0f,0xfc,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0xc0,0x0c,0xc0,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0xf0,0x3c,0xf0,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x30,0x00,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x0c,0x00,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x00,0x30,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0x0c,0xc3,0x0c,0xc3,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0xf0,0x3f,0xf0,0x3f,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3c,0xf0,0x3c,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xf0,0x3f,0xf0,0x3f,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0xf0,0x3f,0xf0,0x3f,0xfc,0xff,0xfc,0xff,0xf0,0x3f,0xf0,0x3f,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x3c,0xf3,0x3c,0xf3,0xfc,0xff,0xfc,0xff,0x3c,0xf3,0x3c,0xf3,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x33,0xcc,0x33,0xcc,0x03,0xc0,0x03,0xc0,0x33,0xcc,0x33,0xcc,0xc3,0xc3,0xc3,0xc3,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x33,0xcc,0x33,0xcc,0x03,0xc0,0x03,0xc0,0xc3,0xc3,0xc3,0xc3,0x33,0xcc,0x33,0xcc,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xc3,0xf0,0xc3,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0xf0,0xc3,0xf0,0xc3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0xc0,0x3c,0xc0,0xc0,0x30,0xc0,0x30,0xc0,0x0c,0xc0,0x0c,0xc0,0x03,0xc0,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0x00,0x0f,0x00,0x0f,0x00,0x33,0x00,0x33,0xc0,0x30,0xc0,0x30,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x3f,0xf0,0x3f,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x3c,0xc0,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x0f,0xc0,0x0f,0x00,0x30,0x00,0x30,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0f,0x30,0x0f,0xcc,0x30,0xcc,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x03,0x0c,0x03,0xcc,0x00,0xcc,0x00,0x3c,0x00,0x3c,0x00,0xcc,0x00,0xcc,0x00,0x0c,0x33,0x0c,0x33,0x0c,0x0c,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xf0,0x33,0xf0,0x33,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x0c,0xc0,0x0c,0xc0,0x03,0xc0,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x00,0x30,0x00,0xc0,0x03,0xc0,0x03,0x30,0x00,0x30,0x00,0xc0,0x0f,0xc0,0x0f,0x00,0x30,0x00,0x30,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0xcc,0x0c,0xcc,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xf0,0x03,0xf0,0x03,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x0c,0x03,0x0c,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x3c,0x0c,0x3c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x30,0x3c,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0xf0,0x30,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0xc3,0x0c,0xc3,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x30,0x30,0x0c,0xc0,0x0c,0xc0,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0xf0,0x3c,0xf0,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x3c,0xf0,0x3c,0xf0,0x30,0x30,0x30,0x30,0x3c,0xf0,0x3c,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x3f,0xc0,0x3f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xcc,0x00,0xcc,0x00,0xf0,0x00,0xf0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x0f,0x00,0x0f,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xfc,0xff,0xfc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0xfc,0xff,0xfc,0xff,0x00,0x03,0x00,0x03,0xfc,0xff,0xfc,0xff,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x3f,0xf0,0x3f,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0xff,0xf0,0xff,0xcc,0x30,0xcc,0x30,0x30,0x0c,0x30,0x0c,0x00,0x03,0x00,0x03,0xc0,0x30,0xc0,0x30,0x30,0xcc,0x30,0xcc,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0xfc,0xff,0xfc,0xff,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3c,0xf0,0x3c,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3c,0xf0,0x3c,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0xf0,0x3c,0xf0,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x0c,0x03,0x0c,0x03,0xcc,0x00,0xcc,0x00,0x3c,0x00,0x3c,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x3f,0xc0,0x3f,0x30,0x00,0x30,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x30,0x00,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x30,0x30,0x30,0xcc,0xcc,0xcc,0xcc,0x30,0x33,0x30,0x33,0xc0,0x0c,0xc0,0x0c,0x30,0x33,0x30,0x33,0xcc,0xcc,0xcc,0xcc,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xc3,0xcf,0xc3,0xcf,0x33,0xc0,0x33,0xc0,0x33,0xc0,0x33,0xc0,0xc3,0xcf,0xc3,0xcf,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x0c,0x33,0x0c,0x33,0x0c,0x33,0x0c,0x33,0xf0,0x33,0xf0,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x30,0x03,0x30,0x03,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0xfc,0x33,0xfc,0x33,0x33,0xcc,0x33,0xcc,0x33,0xcc,0x33,0xcc,0xf3,0xc3,0xf3,0xc3,0x33,0xc3,0x33,0xc3,0x3c,0x3c,0x3c,0x3c,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xcc,0xff,0xcc,0xff,0x3c,0x00,0x3c,0x00,0x3c,0xf0,0x3c,0xf0,0x3c,0x30,0x3c,0x30,0x3c,0x0c,0x3c,0x0c,0xfc,0xf3,0xfc,0xf3,0x3c,0x00,0x3c,0x00,0xcc,0xff,0xcc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x0c,0x00,0x0c,0x00,0xf0,0x00,0xf0,0xff,0x0f,0xff,0x0f,0x00,0x30,0x00,0x30,0xff,0x0f,0xff,0x0f,0x00,0x0c,0x00,0x0c,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x0f,0xff,0x0f,0x00,0x30,0x00,0x30,0xff,0x0f,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0xfc,0x03,0xfc,0x03,0x0c,0x33,0x0c,0x33,0x0c,0x0c,0x0c,0x0c,0x0c,0xf3,0x0c,0xf3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0xc0,0x3c,0xc0,0x03,0x30,0x03,0x30,0x03,0x0c,0x03,0x0c,0x3c,0x03,0x3c,0x03,0xc0,0x3c,0xc0,0x3c,0x30,0xc3,0x30,0xc3,0x0c,0xc3,0x0c,0xc3,0x03,0x3c,0x03,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0x00,0x3f,0x00,0x3c,0x00,0x3c,0x00,0x33,0x00,0x33,0xfc,0x00,0xfc,0x00,0xc3,0x00,0xc3,0x00,0xc3,0x00,0xc3,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0x00,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x3f,0x00,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x3f,0xf0,0x3f,0xf0,0xcf,0xcf,0xcf,0xcf,0xff,0xf0,0xff,0xf0,0xff,0xfc,0xff,0xfc,0xff,0xff,0xff,0xff,0xff,0xfc,0xff,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0xc0,0x0c,0xc0,0x0c,0xf0,0x3f,0xf0,0x3f,0xc0,0x0c,0xc0,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x33,0x30,0x33,0xf0,0x3c,0xf0,0x3c,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x00,0x0c,0x00,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x30,0x00,0x30,0x00,0xfc,0x00,0xfc,0x00,0x30,0x00,0x30,0x00,0x30,0x30,0x30,0x30,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3c,0x30,0x3c,0xf0,0x33,0xf0,0x33,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x30,0x03,0x30,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0xf0,0x03,0xf0,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x30,0x00,0x30,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xf3,0xc3,0xf3,0xc3,0x33,0xcc,0x33,0xcc,0xf3,0xc3,0xf3,0xc3,0x33,0xcc,0x33,0xcc,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xc3,0xcf,0xc3,0xcf,0x33,0xc0,0x33,0xc0,0x33,0xc0,0x33,0xc0,0xc3,0xcf,0xc3,0xcf,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x30,0x30,0x30,0x30,0x0c,0x30,0x0c,0x30,0x03,0x30,0x03,0xc0,0x00,0xc0,0x00,0x30,0x33,0x30,0x33,0x0c,0x3f,0x0c,0x3f,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x30,0x30,0x30,0x30,0x3c,0x0c,0x3c,0x0c,0x30,0x03,0x30,0x03,0xfc,0x00,0xfc,0x00,0x30,0x33,0x30,0x33,0x0c,0x3f,0x0c,0x3f,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x30,0x30,0x30,0x30,0x0c,0x30,0x0c,0x30,0x03,0x30,0x03,0xc0,0x3c,0xc0,0x3c,0x30,0x30,0x30,0x30,0x0c,0x0c,0x0c,0x0c,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x0c,0x33,0x0c,0x33,0x0c,0x33,0x0c,0x33,0xf0,0x33,0xf0,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x30,0x30,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x30,0x03,0x30,0x03,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0x00,0x3f,0x00,0x0c,0x33,0x0c,0x33,0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0xc0,0xcc,0xc0,0xcc,0xc0,0xcc,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0xfc,0x0f,0xfc,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x30,0x03,0x30,0x03,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0xcc,0x0f,0xcc,0x0f,0x3c,0x30,0x3c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x3f,0xc0,0x3f,0x30,0x03,0x30,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x3f,0x0c,0x3f,0xfc,0x03,0xfc,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x3f,0x0c,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x0c,0xfc,0x0c,0x00,0x33,0x00,0x33,0xf0,0x3f,0xf0,0x3f,0x0c,0x03,0x0c,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xcc,0x33,0xcc,0x33,0x3c,0x30,0x3c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x3c,0x0c,0x3c,0xcc,0x33,0xcc,0x33,0x3c,0x30,0x3c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x3c,0x30,0x3c,0x30,0xcc,0x30,0xcc,0x30,0x0c,0x33,0x0c,0x33,0x0c,0x3c,0x0c,0x3c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0xfc,0x03,0xfc,0x03,0x0c,0x00,0x0c,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x0c,0x0c,0x0c,0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0xfc,0x03,0xfc,0x03,0x0c,0x00,0x0c,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0xfc,0x3f,0xfc,0x3f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
},

{
/* CG 9 - for Model 4/4P */
/* Source: a Model III CG ROM, read by Todd P. Cromwell III (todd2_4.bin) */
/* I'm guessing this was a 3rd party replacement CG, not from Radio
   Shack.  The ROM was marked as "Model III/4 character
   generator". The normal ASCII characters are bold, and alternates
   are the upper case and numbers in inverse video. This ROM doesn't
   seem especially suited for the Model 4, which had inverse video in
   hardware. */
/* Letters shifted 1 line down by mann to match M4 style */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0xfc,0x0f,0xfc,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xfc,0x3f,0xfc,0x3f,0x0c,0x00,0x0c,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0c,0xc0,0x0c,0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0xcf,0xc0,0xcf,0x30,0x30,0x30,0x30,0x30,0x3c,0x30,0x3c,0x30,0x33,0x30,0x33,0xf0,0x30,0xf0,0x30,0x30,0x30,0x30,0x30,0xcc,0x0f,0xcc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0x30,0x0f,0x30,0x0f,0xf0,0x30,0xf0,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0xfc,0x33,0xfc,0x33,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0xfc,0x03,0xfc,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x0c,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0c,0xc0,0x0c,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x30,0x30,0x30,0x30,0xf0,0x30,0xf0,0x30,0x30,0x33,0x30,0x33,0x30,0x3c,0x30,0x3c,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x0c,0xc0,0x0c,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xc3,0x00,0xc3,0xc0,0x3c,0xc0,0x3c,0x30,0x3c,0x30,0x3c,0x30,0x33,0x30,0x33,0xf0,0x30,0xf0,0x30,0xf0,0x0c,0xf0,0x0c,0x0c,0x03,0x0c,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x3c,0x0c,0x3c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x00,0x33,0x00,0x33,0xc0,0x0f,0xc0,0x0f,0x30,0x03,0x30,0x03,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x03,0x30,0x03,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x0c,0x0c,0x0c,0x0c,0xf0,0x33,0xf0,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x00,0x0c,0x00,0xfc,0x0f,0xfc,0x0f,0x0c,0x30,0x0c,0x30,0xf0,0x3f,0xf0,0x3f,0x00,0x30,0x00,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x30,0x00,0x30,0x00,0xf0,0x3f,0xf0,0x3f,0x30,0x00,0x30,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x3f,0xc0,0x3f,0x30,0x0c,0x30,0x0c,0x30,0x3c,0x30,0x3c,0xf0,0x0f,0xf0,0x0f,0x30,0x0c,0x30,0x0c,0x30,0x3c,0x30,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xfc,0x03,0xfc,0x03,0xfc,0x03,0xfc,0x03,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0xff,0x3f,0xff,0x3f,0x3c,0x0f,0x3c,0x0f,0xff,0x3f,0xff,0x3f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xfc,0x0f,0xfc,0x0f,0x0f,0x00,0x0f,0x00,0xfc,0x03,0xfc,0x03,0x00,0x0f,0x00,0x0f,0xff,0x03,0xff,0x03,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x0f,0x3c,0x0f,0x0f,0x0f,0x0f,0x0f,0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,0x3c,0x3c,0x3c,0x3c,0x0f,0x3c,0x0f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x3c,0x0f,0x3c,0x0f,0xf0,0x03,0xf0,0x03,0xfc,0x3c,0xfc,0x3c,0xcf,0x0f,0xcf,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x3c,0xfc,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0xf0,0x00,0xf0,0x00,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0xf0,0x00,0xf0,0x00,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x3c,0x3c,0x3c,0xf0,0x0f,0xf0,0x0f,0xff,0xff,0xff,0xff,0xf0,0x0f,0xf0,0x0f,0x3c,0x3c,0x3c,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xff,0x0f,0xff,0x0f,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x0f,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x0f,0x00,0x0f,0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,0x3c,0x00,0x3c,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x0f,0xfc,0x0f,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0xcf,0x3c,0xcf,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xfc,0x00,0xfc,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xff,0x0f,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0x00,0x0f,0x00,0x0f,0xf0,0x03,0xf0,0x03,0x3c,0x00,0x3c,0x00,0x0f,0x0f,0x0f,0x0f,0xff,0x0f,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0x00,0x0f,0x00,0x0f,0xf0,0x03,0xf0,0x03,0x00,0x0f,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0xf0,0x0f,0xf0,0x0f,0x3c,0x0f,0x3c,0x0f,0x0f,0x0f,0x0f,0x0f,0xff,0x3f,0xff,0x3f,0x00,0x0f,0x00,0x0f,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x0f,0xff,0x0f,0x0f,0x00,0x0f,0x00,0xff,0x03,0xff,0x03,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x3c,0x00,0x3c,0x00,0x0f,0x00,0x0f,0x00,0xff,0x03,0xff,0x03,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x0f,0xff,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x0f,0x00,0x0f,0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x0f,0xfc,0x0f,0x00,0x0f,0x00,0x0f,0xc0,0x03,0xc0,0x03,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,0x3c,0x00,0x3c,0x00,0x0f,0x00,0x0f,0x00,0x3c,0x00,0x3c,0x00,0xf0,0x00,0xf0,0x00,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x0f,0xff,0x0f,0x00,0x00,0x00,0x00,0xff,0x0f,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0xf0,0x00,0xf0,0x00,0xc0,0x03,0xc0,0x03,0x00,0x0f,0x00,0x0f,0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0x00,0x0f,0x00,0x0f,0xc0,0x03,0xc0,0x03,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x0f,0xfc,0x0f,0x0f,0x3c,0x0f,0x3c,0xcf,0x3f,0xcf,0x3f,0xcf,0x3f,0xcf,0x3f,0xcf,0x3f,0xcf,0x3f,0x0f,0x00,0x0f,0x00,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xff,0x0f,0xff,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x0f,0xff,0x0f,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0xfc,0x0f,0xfc,0x0f,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0xff,0x0f,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x3c,0x3c,0x3c,0x3c,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x3c,0x3c,0x3c,0x3c,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x3c,0x0f,0x3c,0x0f,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x0f,0x3c,0x0f,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x3f,0xff,0x3f,0x3c,0x30,0x3c,0x30,0x3c,0x03,0x3c,0x03,0xfc,0x03,0xfc,0x03,0x3c,0x03,0x3c,0x03,0x3c,0x30,0x3c,0x30,0xff,0x3f,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x3f,0xff,0x3f,0x3c,0x30,0x3c,0x30,0x3c,0x03,0x3c,0x03,0xfc,0x03,0xfc,0x03,0x3c,0x03,0x3c,0x03,0x3c,0x00,0x3c,0x00,0xff,0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x3c,0x3c,0x3c,0x3c,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x3f,0x0f,0x3f,0x3c,0x3c,0x3c,0x3c,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xff,0x0f,0xff,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x3f,0xc0,0x3f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3f,0x3c,0x3f,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x0f,0x3c,0x0f,0xfc,0x03,0xfc,0x03,0x3c,0x0f,0x3c,0x0f,0x3c,0x3c,0x3c,0x3c,0x3f,0x3c,0x3f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x30,0x3c,0x30,0x3c,0x3c,0x3c,0x3c,0xff,0x3f,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0f,0x3c,0x0f,0x3c,0x3f,0x3f,0x3f,0x3f,0xff,0x3f,0xff,0x3f,0xff,0x3f,0xff,0x3f,0xcf,0x3c,0xcf,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0f,0x3c,0x0f,0x3c,0x3f,0x3c,0x3f,0x3c,0xff,0x3c,0xff,0x3c,0xcf,0x3f,0xcf,0x3f,0x0f,0x3f,0x0f,0x3f,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x0f,0xfc,0x0f,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0xfc,0x0f,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x0f,0xff,0x0f,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0xfc,0x0f,0xfc,0x0f,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0xff,0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xcf,0x0f,0xcf,0x0f,0xfc,0x03,0xfc,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x0f,0xff,0x0f,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0xfc,0x0f,0xfc,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x3c,0x3c,0x3c,0x3f,0x3c,0x3f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0x3f,0x00,0x3f,0x00,0xfc,0x00,0xfc,0x00,0xc0,0x0f,0xc0,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x0f,0xff,0x0f,0xf3,0x0c,0xf3,0x0c,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xff,0x0f,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0xcf,0x3c,0xcf,0x3c,0xff,0x3f,0xff,0x3f,0x3f,0x3f,0x3f,0x3f,0x0f,0x3c,0x0f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x3c,0x0f,0x3c,0x0f,0xf0,0x03,0xf0,0x03,0xf0,0x03,0xf0,0x03,0x3c,0x0f,0x3c,0x0f,0x0f,0x3c,0x0f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x3f,0xff,0x3f,0x0f,0x3c,0x0f,0x3c,0x03,0x0f,0x03,0x0f,0xc0,0x03,0xc0,0x03,0xf0,0x30,0xf0,0x30,0x3c,0x3c,0x3c,0x3c,0xff,0x3f,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0xf0,0x00,0xf0,0x00,0xc0,0x03,0xc0,0x03,0x00,0x0f,0x00,0x0f,0x00,0x3c,0x00,0x3c,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0xf0,0x3c,0xf0,0x3c,0x3c,0xf0,0x3c,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x00,0x0f,0x00,0x0f,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x00,0x0f,0x00,0x0f,0xfc,0x0f,0xfc,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x3c,0xfc,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3f,0x00,0x3f,0x00,0x3c,0x00,0x3c,0x00,0xfc,0x0f,0xfc,0x0f,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0xcf,0x0f,0xcf,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x0f,0x00,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x00,0x0f,0x00,0x0f,0xfc,0x0f,0xfc,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x3c,0xfc,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0xff,0x0f,0xff,0x0f,0x0f,0x00,0x0f,0x00,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0x3c,0x0f,0x3c,0x0f,0x3c,0x00,0x3c,0x00,0xff,0x00,0xff,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0xff,0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3c,0xfc,0x3c,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x0f,0xfc,0x0f,0x00,0x0f,0x00,0x0f,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3f,0x00,0x3f,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x0f,0x3c,0x0f,0xfc,0x3c,0xfc,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3f,0x3c,0x3f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3f,0x00,0x3f,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x3c,0x3c,0x3c,0x3c,0x0f,0x3c,0x0f,0xfc,0x03,0xfc,0x03,0x3c,0x0f,0x3c,0x0f,0x3f,0x3c,0x3f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0xff,0x3f,0xff,0x3f,0xff,0x3f,0xff,0x3f,0xcf,0x3c,0xcf,0x3c,0x0f,0x3c,0x0f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x03,0xff,0x03,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcf,0x0f,0xcf,0x0f,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0xfc,0x0f,0xfc,0x0f,0x3c,0x00,0x3c,0x00,0xff,0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3c,0xfc,0x3c,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x0f,0xfc,0x0f,0x00,0x0f,0x00,0x0f,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcf,0x0f,0xcf,0x0f,0xfc,0x3c,0xfc,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x00,0x3c,0x00,0xff,0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x0f,0xfc,0x0f,0x0f,0x00,0x0f,0x00,0xfc,0x03,0xfc,0x03,0x00,0x0f,0x00,0x0f,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0xf0,0x00,0xf0,0x00,0xfc,0x0f,0xfc,0x0f,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x0c,0xf0,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x3c,0xfc,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x03,0xfc,0x03,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x3c,0x0f,0x3c,0xcf,0x3c,0xcf,0x3c,0xff,0x3f,0xff,0x3f,0xff,0x3f,0xff,0x3f,0x3c,0x0f,0x3c,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x3c,0x0f,0x3c,0x3c,0x0f,0x3c,0x0f,0xf0,0x03,0xf0,0x03,0x3c,0x0f,0x3c,0x0f,0x0f,0x3c,0x0f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x0f,0xfc,0x0f,0x00,0x0f,0x00,0x0f,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x0f,0xff,0x0f,0xc3,0x03,0xc3,0x03,0xf0,0x00,0xf0,0x00,0x3c,0x0c,0x3c,0x0c,0xff,0x0f,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0x0c,0xc3,0x0c,0xc3,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0xf0,0x3f,0xf0,0x3f,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3c,0xf0,0x3c,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xfc,0xff,0xf0,0x3f,0xf0,0x3f,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0xf0,0x3f,0xf0,0x3f,0xfc,0xff,0xfc,0xff,0xf0,0x3f,0xf0,0x3f,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x3c,0xf3,0x3c,0xf3,0xfc,0xff,0xfc,0xff,0x3c,0xf3,0x3c,0xf3,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x33,0xcc,0x33,0xcc,0x03,0xc0,0x03,0xc0,0x33,0xcc,0x33,0xcc,0xc3,0xc3,0xc3,0xc3,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x33,0xcc,0x33,0xcc,0x03,0xc0,0x03,0xc0,0xc3,0xc3,0xc3,0xc3,0x33,0xcc,0x33,0xcc,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xc3,0xf0,0xc3,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0x0c,0x3c,0xf0,0xc3,0xf0,0xc3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0xc0,0x3c,0xc0,0xc0,0x30,0xc0,0x30,0xc0,0x0c,0xc0,0x0c,0xc0,0x03,0xc0,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0x00,0x0f,0x00,0x0f,0x00,0x33,0x00,0x33,0xc0,0x30,0xc0,0x30,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x3f,0xf0,0x3f,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x3c,0xc0,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x0f,0xc0,0x0f,0x00,0x30,0x00,0x30,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0f,0x30,0x0f,0xcc,0x30,0xcc,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xf0,0x3f,0xf0,0x3f,0x30,0x30,0x30,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x03,0x0c,0x03,0xcc,0x00,0xcc,0x00,0x3c,0x00,0x3c,0x00,0xcc,0x00,0xcc,0x00,0x0c,0x33,0x0c,0x33,0x0c,0x0c,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xf0,0x33,0xf0,0x33,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x0c,0xc0,0x0c,0xc0,0x03,0xc0,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x00,0x30,0x00,0xc0,0x03,0xc0,0x03,0x30,0x00,0x30,0x00,0xc0,0x0f,0xc0,0x0f,0x00,0x30,0x00,0x30,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0xcc,0x0c,0xcc,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xf0,0x03,0xf0,0x03,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x0c,0x03,0x0c,0x03,0x0c,0x03,0x0c,0x03,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x0c,0x03,0x0c,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x3c,0x0c,0x3c,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x30,0x3c,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0xf0,0x30,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0xc3,0x0c,0xc3,0x30,0x33,0x30,0x33,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x30,0x30,0x0c,0xc0,0x0c,0xc0,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0xf0,0x3c,0xf0,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x3c,0xf0,0x3c,0xf0,0x30,0x30,0x30,0x30,0x3c,0xf0,0x3c,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x3f,0xc0,0x3f,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xcc,0x00,0xcc,0x00,0xf0,0x00,0xf0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x3f,0xfc,0x3f,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x0f,0x00,0x0f,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xfc,0x3f,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0xf0,0x30,0xf0,0x30,0x0c,0x0f,0x0c,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0xfc,0xff,0xfc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0xfc,0xff,0xfc,0xff,0x00,0x03,0x00,0x03,0xfc,0xff,0xfc,0xff,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0xf0,0x3f,0xf0,0x3f,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0xff,0xf0,0xff,0xcc,0x30,0xcc,0x30,0x30,0x0c,0x30,0x0c,0x00,0x03,0x00,0x03,0xc0,0x30,0xc0,0x30,0x30,0xcc,0x30,0xcc,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0xfc,0xff,0xfc,0xff,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3c,0xf0,0x3c,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3c,0xf0,0x3c,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0xf0,0x3c,0xf0,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x0c,0x03,0x0c,0x03,0xcc,0x00,0xcc,0x00,0x3c,0x00,0x3c,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x3f,0xc0,0x3f,0x30,0x00,0x30,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x30,0x00,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x30,0x30,0x30,0x30,0xcc,0xcc,0xcc,0xcc,0x30,0x33,0x30,0x33,0xc0,0x0c,0xc0,0x0c,0x30,0x33,0x30,0x33,0xcc,0xcc,0xcc,0xcc,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0xc3,0xc3,0xc3,0xc3,0x33,0xc0,0x33,0xc0,0x33,0xc0,0x33,0xc0,0xc3,0xc3,0xc3,0xc3,0x0c,0x30,0x0c,0x30,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x30,0x0c,0x30,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0xc0,0x03,0xc0,0x03,0x30,0x0c,0x30,0x0c,0x0c,0x30,0x0c,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x0c,0x33,0x0c,0x33,0x0c,0x33,0x0c,0x33,0xf0,0x33,0xf0,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x30,0x03,0x30,0x03,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0xfc,0x33,0xfc,0x33,0x33,0xcc,0x33,0xcc,0x33,0xcc,0x33,0xcc,0xf3,0xc3,0xf3,0xc3,0x33,0xc3,0x33,0xc3,0x3c,0x3c,0x3c,0x3c,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xcc,0xff,0xcc,0xff,0x3c,0x00,0x3c,0x00,0x3c,0xf0,0x3c,0xf0,0x3c,0x30,0x3c,0x30,0x3c,0x0c,0x3c,0x0c,0xfc,0xf3,0xfc,0xf3,0x3c,0x00,0x3c,0x00,0xcc,0xff,0xcc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x0c,0x00,0x0c,0x00,0xf0,0x00,0xf0,0xff,0x0f,0xff,0x0f,0x00,0x30,0x00,0x30,0xff,0x0f,0xff,0x0f,0x00,0x0c,0x00,0x0c,0xff,0x03,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0x0f,0xff,0x0f,0x00,0x30,0x00,0x30,0xff,0x0f,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0xfc,0x03,0xfc,0x03,0x0c,0x33,0x0c,0x33,0x0c,0x0c,0x0c,0x0c,0x0c,0xf3,0x0c,0xf3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x03,0x30,0x03,0x30,0x03,0x0c,0x03,0x0c,0x3c,0x03,0x3c,0x03,0xc0,0x3c,0xc0,0x3c,0x30,0xc3,0x30,0xc3,0x0c,0xc3,0x0c,0xc3,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0x00,0x3f,0x00,0x3c,0x00,0x3c,0x00,0x33,0x00,0x33,0xfc,0x00,0xfc,0x00,0xc3,0x00,0xc3,0x00,0xc3,0x00,0xc3,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0x00,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x3f,0x00,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x3f,0xf0,0x3f,0xf0,0xcf,0xcf,0xcf,0xcf,0xff,0xf0,0xff,0xf0,0xff,0xfc,0xff,0xfc,0xff,0xff,0xff,0xff,0xff,0xfc,0xff,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0xc0,0x0c,0xc0,0x0c,0xf0,0x3f,0xf0,0x3f,0xc0,0x0c,0xc0,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xf0,0x3c,0xf0,0x3c,0xfc,0xff,0xfc,0xff,0x3c,0xf0,0x3c,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0f,0xff,0x0f,0xff,0x03,0xfc,0x03,0xfc,0x03,0xfc,0x03,0xfc,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0x00,0xc0,0x00,0xc0,0xc3,0xf0,0xc3,0xf0,0x00,0xc0,0x00,0xc0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0f,0xff,0x0f,0xff,0x03,0xf0,0x03,0xf0,0xf0,0xff,0xf0,0xff,0x03,0xfc,0x03,0xfc,0xff,0xf0,0xff,0xf0,0x00,0xfc,0x00,0xfc,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xc3,0xf0,0xc3,0xf0,0xf0,0xf0,0xf0,0xf0,0x3f,0xfc,0x3f,0xfc,0x0f,0xff,0x0f,0xff,0xc3,0xc3,0xc3,0xc3,0xf0,0xc3,0xf0,0xc3,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0f,0xfc,0x0f,0xfc,0xc3,0xf0,0xc3,0xf0,0x0f,0xfc,0x0f,0xfc,0x03,0xc3,0x03,0xc3,0x30,0xf0,0x30,0xf0,0xf0,0xf0,0xf0,0xf0,0x03,0xc3,0x03,0xc3,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc3,0xff,0xc3,0xff,0xc3,0xff,0xc3,0xff,0xf0,0xff,0xf0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3f,0xfc,0x3f,0xfc,0x0f,0xff,0x0f,0xff,0xc3,0xff,0xc3,0xff,0xc3,0xff,0xc3,0xff,0xc3,0xff,0xc3,0xff,0x0f,0xff,0x0f,0xff,0x3f,0xfc,0x3f,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc3,0xff,0xc3,0xff,0x0f,0xff,0x0f,0xff,0x3f,0xfc,0x3f,0xfc,0x3f,0xfc,0x3f,0xfc,0x3f,0xfc,0x3f,0xfc,0x0f,0xff,0x0f,0xff,0xc3,0xff,0xc3,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xc3,0xc3,0xc3,0xc3,0x0f,0xf0,0x0f,0xf0,0x00,0x00,0x00,0x00,0x0f,0xf0,0x0f,0xf0,0xc3,0xc3,0xc3,0xc3,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x00,0xf0,0x00,0xf0,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0xc3,0xff,0xc3,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xf0,0x00,0xf0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xc3,0xff,0xc3,0xff,0xf0,0xff,0xf0,0x3f,0xfc,0x3f,0xfc,0x0f,0xff,0x0f,0xff,0xc3,0xff,0xc3,0xff,0xf0,0xff,0xf0,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0xf0,0x03,0xf0,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0x30,0xc3,0x30,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0x03,0xf0,0x03,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0f,0xff,0x0f,0xff,0x03,0xff,0x03,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x00,0xf0,0x00,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0xfc,0x03,0xfc,0xf0,0xf0,0xf0,0xf0,0xff,0xf0,0xff,0xf0,0x0f,0xfc,0x0f,0xfc,0xc3,0xff,0xc3,0xff,0xf0,0xf0,0xf0,0xf0,0x00,0xf0,0x00,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0xfc,0x03,0xfc,0xf0,0xf0,0xf0,0xf0,0xff,0xf0,0xff,0xf0,0x0f,0xfc,0x0f,0xfc,0xff,0xf0,0xff,0xf0,0xf0,0xf0,0xf0,0xf0,0x03,0xfc,0x03,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3f,0xf0,0x3f,0xf0,0x0f,0xf0,0x0f,0xf0,0xc3,0xf0,0xc3,0xf0,0xf0,0xf0,0xf0,0xf0,0x00,0xc0,0x00,0xc0,0xff,0xf0,0xff,0xf0,0x3f,0xc0,0x3f,0xc0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0xf0,0xff,0xf0,0xff,0x00,0xfc,0x00,0xfc,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0x03,0xfc,0x03,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0f,0xfc,0x0f,0xfc,0xc3,0xff,0xc3,0xff,0xf0,0xff,0xf0,0xff,0x00,0xfc,0x00,0xfc,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x03,0xfc,0x03,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0xf0,0xf0,0xf0,0xf0,0xff,0xf0,0xff,0xf0,0x3f,0xfc,0x3f,0xfc,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0xfc,0x03,0xfc,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x03,0xfc,0x03,0xfc,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x03,0xfc,0x03,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0xfc,0x03,0xfc,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x03,0xf0,0x03,0xf0,0xff,0xf0,0xff,0xf0,0x3f,0xfc,0x3f,0xfc,0x03,0xff,0x03,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0xc3,0xff,0xc3,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3f,0xfc,0x3f,0xfc,0x0f,0xff,0x0f,0xff,0xc3,0xff,0xc3,0xff,0xf0,0xff,0xf0,0xff,0xc3,0xff,0xc3,0xff,0x0f,0xff,0x0f,0xff,0x3f,0xfc,0x3f,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xf0,0x00,0xf0,0xff,0xff,0xff,0xff,0x00,0xf0,0x00,0xf0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc3,0xff,0xc3,0xff,0x0f,0xff,0x0f,0xff,0x3f,0xfc,0x3f,0xfc,0xff,0xf0,0xff,0xf0,0x3f,0xfc,0x3f,0xfc,0x0f,0xff,0x0f,0xff,0xc3,0xff,0xc3,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0xfc,0x03,0xfc,0xf0,0xf0,0xf0,0xf0,0xff,0xf0,0xff,0xf0,0x3f,0xfc,0x3f,0xfc,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0xf0,0x03,0xf0,0xf0,0xc3,0xf0,0xc3,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xf0,0xff,0xf0,0xff,0x03,0xfc,0x03,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0f,0xff,0x0f,0xff,0x03,0xfc,0x03,0xfc,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x00,0xf0,0x00,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0x03,0xf0,0x03,0xf0,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0x00,0xf0,0x00,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0f,0xf0,0x0f,0xf0,0xc3,0xc3,0xc3,0xc3,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xc3,0xc3,0xc3,0xc3,0x0f,0xf0,0x0f,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0xfc,0xc3,0xf0,0xc3,0xf0,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xf0,0xc3,0xf0,0x00,0xfc,0x00,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0xc3,0xcf,0xc3,0xcf,0xc3,0xfc,0xc3,0xfc,0x03,0xfc,0x03,0xfc,0xc3,0xfc,0xc3,0xfc,0xc3,0xcf,0xc3,0xcf,0x00,0xc0,0x00,0xc0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0xc3,0xcf,0xc3,0xcf,0xc3,0xfc,0xc3,0xfc,0x03,0xfc,0x03,0xfc,0xc3,0xfc,0xc3,0xfc,0xc3,0xff,0xc3,0xff,0x00,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0f,0xf0,0x0f,0xf0,0xc3,0xc3,0xc3,0xc3,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xc0,0xf0,0xc0,0xc3,0xc3,0xc3,0xc3,0x0f,0xf0,0x0f,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x00,0xf0,0x00,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0xfc,0x03,0xfc,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x03,0xfc,0x03,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3f,0xc0,0x3f,0xc0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xff,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x03,0xfc,0x03,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0xc3,0xc0,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xf0,0xc3,0xf0,0x03,0xfc,0x03,0xfc,0xc3,0xf0,0xc3,0xf0,0xc3,0xc3,0xc3,0xc3,0xc0,0xc3,0xc0,0xc3,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xff,0x00,0xff,0xc3,0xff,0xc3,0xff,0xc3,0xff,0xc3,0xff,0xc3,0xff,0xc3,0xff,0xc3,0xcf,0xc3,0xcf,0xc3,0xc3,0xc3,0xc3,0x00,0xc0,0x00,0xc0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0xc3,0xf0,0xc3,0xc0,0xc0,0xc0,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x30,0xc3,0x30,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0xc3,0xf0,0xc3,0xc0,0xc3,0xc0,0xc3,0x00,0xc3,0x00,0xc3,0x30,0xc0,0x30,0xc0,0xf0,0xc0,0xf0,0xc0,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0xf0,0x03,0xf0,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0x03,0xf0,0x03,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0x03,0xf0,0x03,0xf0,0xc3,0xff,0xc3,0xff,0xc3,0xff,0xc3,0xff,0x00,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0xfc,0x03,0xfc,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x30,0xf0,0x30,0xf0,0x03,0xfc,0x03,0xfc,0x3f,0xf0,0x3f,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0x03,0xf0,0x03,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xc3,0xc3,0xc3,0xc0,0xc3,0xc0,0xc3,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0xfc,0x03,0xfc,0xf0,0xf0,0xf0,0xf0,0xc0,0xff,0xc0,0xff,0x03,0xff,0x03,0xff,0x3f,0xf0,0x3f,0xf0,0xf0,0xf0,0xf0,0xf0,0x03,0xfc,0x03,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x0c,0xf3,0x0c,0xf3,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x03,0xfc,0x03,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x00,0xf0,0x00,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x03,0xfc,0x03,0xfc,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0x30,0xc3,0x30,0xc3,0x00,0xc0,0x00,0xc0,0xc0,0xc0,0xc0,0xc0,0xf0,0xc3,0xf0,0xc3,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xf0,0xc3,0xc3,0xf0,0xc3,0xf0,0x0f,0xfc,0x0f,0xfc,0x0f,0xfc,0x0f,0xfc,0xc3,0xf0,0xc3,0xf0,0xf0,0xc3,0xf0,0xc3,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x03,0xfc,0x03,0xfc,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x0f,0xff,0x03,0xfc,0x03,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0xf0,0xc3,0xf0,0xc3,0xfc,0xf0,0xfc,0xf0,0x3f,0xfc,0x3f,0xfc,0x0f,0xcf,0x0f,0xcf,0xc3,0xc3,0xc3,0xc3,0x00,0xc0,0x00,0xc0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0f,0xf0,0x0f,0xf0,0xcf,0xff,0xcf,0xff,0xcf,0xff,0xcf,0xff,0xcf,0xff,0xcf,0xff,0xcf,0xff,0xcf,0xff,0xcf,0xff,0xcf,0xff,0x0f,0xf0,0x0f,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xc3,0xff,0xc3,0xff,0x0f,0xff,0x0f,0xff,0x3f,0xfc,0x3f,0xfc,0xff,0xf0,0xff,0xf0,0xff,0xc3,0xff,0xc3,0xff,0x0f,0xff,0x0f,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0f,0xf0,0x0f,0xf0,0xff,0xf3,0xff,0xf3,0xff,0xf3,0xff,0xf3,0xff,0xf3,0xff,0xf3,0xff,0xf3,0xff,0xf3,0xff,0xf3,0xff,0xf3,0x0f,0xf0,0x0f,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xfc,0xff,0xfc,0x3f,0xf0,0x3f,0xf0,0x0f,0xc3,0x0f,0xc3,0xc3,0x0f,0xc3,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x03,0xcc,0x0c,0xcc,0x0c,0xfc,0x0f,0xfc,0x0f,0x30,0x03,0x30,0x03,0xf0,0x03,0xf0,0x03,0x0f,0x3c,0x0f,0x3c,0xf0,0x03,0xf0,0x03,0x0f,0x3c,0x0f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
},

/* CG 10 - charset including the German special chars ("Umlauts").
 * Version of CG 3 modified by Jenz Guenther to add the national
 * characters used in the GENIE, a German TRS-80 clone.  Note: Jenz
 * says that later version of the GENIE series did not actually
 * support double width. */
{
0xf0,0x3f,0xf0,0x3f,0x0c,0xc0,0x0c,0xc0,0x00,0xc0,0x00,0xc0,0xf0,0xc0,0xf0,0xc0,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xf0,0xff,0xf0,0xff,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0x3f,0xc0,0x3f,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xf0,0xff,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0x0f,0xf0,0x0f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0xff,0xf0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xf0,0xff,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0x0f,0xf0,0x0f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0xff,0xc0,0xff,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xfc,0x30,0xfc,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0xff,0xc0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xf0,0xff,0xf0,0xff,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0xc0,0x30,0xc0,0x30,0x30,0x30,0x30,0x30,0x0c,0x30,0x0c,0xf0,0x03,0xf0,0x03,0x30,0x0c,0x30,0x0c,0x30,0x30,0x30,0x30,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0xff,0xf0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0xc0,0x0c,0xc0,0x3c,0xf0,0x3c,0xf0,0xcc,0xcc,0xcc,0xcc,0x0c,0xc3,0x0c,0xc3,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0xc0,0x30,0xc0,0xf0,0xc0,0xf0,0xc0,0x30,0xc3,0x30,0xc3,0x30,0xcc,0x30,0xcc,0x30,0xf0,0x30,0xf0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xf0,0x3f,0xf0,0x3f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xcc,0x30,0xcc,0x30,0x30,0x30,0x30,0xc0,0xcf,0xc0,0xcf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xf0,0x3f,0xf0,0x3f,0x30,0x0c,0x30,0x0c,0x30,0x30,0x30,0x30,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0x00,0x30,0x00,0xc0,0x3f,0xc0,0x3f,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0xff,0xfc,0xff,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x30,0x30,0x30,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc3,0x0c,0xc3,0xcc,0xcc,0xcc,0xcc,0x3c,0xf0,0x3c,0xf0,0x0c,0xc0,0x0c,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x30,0xc0,0x30,0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0xff,0xfc,0xff,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xfc,0xff,0xfc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x0c,0xc3,0x0c,0xc3,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x0c,0xc3,0x0c,0xc3,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xfc,0xff,0xfc,0xff,0x30,0x00,0x30,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0xfc,0xff,0xfc,0xff,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xfc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xf0,0xff,0xf0,0xff,0xc0,0x30,0xc0,0x30,0xf0,0xff,0xf0,0xff,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xf0,0xff,0xf0,0xff,0x0c,0x03,0x0c,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0xc3,0x00,0xc3,0xfc,0x3f,0xfc,0x3f,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0xc0,0xf0,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0xf0,0x30,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0xc0,0x0c,0xc0,0x0c,0xc0,0x03,0xc0,0x03,0x30,0xcc,0x30,0xcc,0x30,0x30,0x30,0x30,0xc0,0xcf,0xc0,0xcf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x30,0x33,0x30,0x33,0xc0,0x0f,0xc0,0x0f,0xfc,0xff,0xfc,0xff,0xc0,0x0f,0xc0,0x0f,0x30,0x33,0x30,0x33,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0xf0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xf0,0x30,0xf0,0x30,0xcc,0x30,0xcc,0x30,0xc3,0x30,0xc3,0xf0,0xc0,0xf0,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0xc0,0xc0,0x3f,0xc0,0x3f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0xff,0xf0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x3f,0x00,0x3f,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x30,0x00,0x30,0x00,0x3c,0x00,0x3c,0x00,0x33,0x00,0x33,0xc0,0x30,0xc0,0x30,0xf0,0xff,0xf0,0xff,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xf0,0xff,0x30,0x00,0x30,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x3f,0x00,0x3f,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xf0,0x3f,0xf0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xf0,0xff,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0xff,0xc0,0xff,0x00,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0xf0,0xff,0x00,0x00,0x00,0x00,0xf0,0xff,0xf0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x0f,0xf0,0x0f,0x0c,0x30,0x0c,0x30,0x00,0x30,0x00,0x30,0x00,0x0f,0x00,0x0f,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0x0c,0xc0,0x0c,0xc0,0x00,0xc0,0x00,0xc0,0xf0,0xc0,0xf0,0xc0,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xf0,0xff,0xf0,0xff,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0x3f,0xc0,0x3f,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xf0,0xff,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0x0f,0xf0,0x0f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0xff,0xf0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xf0,0xff,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0x0f,0xf0,0x0f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0xff,0xc0,0xff,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xfc,0x30,0xfc,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0xff,0xc0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xf0,0xff,0xf0,0xff,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0xc0,0x30,0xc0,0x30,0x30,0x30,0x30,0x30,0x0c,0x30,0x0c,0xf0,0x03,0xf0,0x03,0x30,0x0c,0x30,0x0c,0x30,0x30,0x30,0x30,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0xf0,0xff,0xf0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0xc0,0x0c,0xc0,0x3c,0xf0,0x3c,0xf0,0xcc,0xcc,0xcc,0xcc,0x0c,0xc3,0x0c,0xc3,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0xc0,0x30,0xc0,0xf0,0xc0,0xf0,0xc0,0x30,0xc3,0x30,0xc3,0x30,0xcc,0x30,0xcc,0x30,0xf0,0x30,0xf0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xf0,0x3f,0xf0,0x3f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xcc,0x30,0xcc,0x30,0x30,0x30,0x30,0xc0,0xcf,0xc0,0xcf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0x3f,0xf0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xf0,0x3f,0xf0,0x3f,0x30,0x0c,0x30,0x0c,0x30,0x30,0x30,0x30,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0x00,0x30,0x00,0xc0,0x3f,0xc0,0x3f,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0xff,0xfc,0xff,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x30,0x30,0x30,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc3,0x0c,0xc3,0xcc,0xcc,0xcc,0xcc,0x3c,0xf0,0x3c,0xf0,0x0c,0xc0,0x0c,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x30,0xc0,0x30,0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x30,0x30,0x30,0x30,0xc0,0x0f,0xc0,0x0f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xfc,0xff,0xfc,0xff,0x00,0x30,0x00,0x30,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0x30,0x00,0x30,0x00,0xfc,0xff,0xfc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0xc0,0x30,0xcf,0x00,0x0f,0xc0,0x30,0xc0,0x30,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xf0,0xff,0xf0,0xff,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0xc0,0x30,0xc0,0x00,0x00,0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0xc0,0x30,0xc0,0x00,0x00,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0xf0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xfc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x00,0xc0,0x00,0x00,0x03,0x00,0x03,0x00,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x3f,0xc0,0x3f,0x00,0xc0,0x00,0xc0,0xc0,0xff,0xc0,0xff,0x30,0xc0,0x30,0xc0,0xc0,0xff,0xc0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x3f,0x30,0x3f,0xf0,0xc0,0xf0,0xc0,0x30,0xc0,0x30,0xc0,0xf0,0xc0,0xf0,0xc0,0x30,0x3f,0x30,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0x00,0x30,0x00,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0xc0,0xcf,0xc0,0xcf,0x30,0xf0,0x30,0xf0,0x30,0xc0,0x30,0xc0,0x30,0xf0,0x30,0xf0,0xc0,0xcf,0xc0,0xcf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0xf0,0xff,0xf0,0xff,0x30,0x00,0x30,0x00,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x3f,0x00,0x3f,0xc0,0xc0,0xc0,0xc0,0xc0,0x00,0xc0,0x00,0xf0,0x03,0xf0,0x03,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0xff,0xc0,0xff,0x00,0xc0,0x00,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x3f,0x30,0x3f,0xf0,0xc0,0xf0,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0xc0,0x30,0xc0,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xc0,0x03,0xc0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xc0,0x0f,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3c,0xfc,0x3c,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc0,0x0c,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x3f,0x30,0x3f,0xf0,0xc0,0xf0,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x3f,0x30,0x3f,0xf0,0xc0,0xf0,0xc0,0xf0,0xc0,0xf0,0xc0,0x30,0x3f,0x30,0x3f,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xcf,0xc0,0xcf,0x30,0xf0,0x30,0xf0,0x30,0xf0,0x30,0xf0,0xc0,0xcf,0xc0,0xcf,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x3f,0x30,0x3f,0xf0,0xc0,0xf0,0xc0,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0xc0,0xff,0x30,0x00,0x30,0x00,0xc0,0x3f,0xc0,0x3f,0x00,0xc0,0x00,0xc0,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0xf0,0x3f,0xf0,0x3f,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xc3,0x00,0xc3,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0xcf,0xc0,0xcf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x0c,0xc0,0x30,0x30,0x30,0x30,0xc0,0x0c,0xc0,0x0c,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0xc0,0x0c,0xc0,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0x0c,0xc3,0xf0,0x3c,0xf0,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0xc0,0x30,0xc0,0xc0,0x30,0xc0,0x30,0x00,0x0f,0x00,0x0f,0xc0,0x30,0xc0,0x30,0x30,0xc0,0x30,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0xff,0xc0,0xff,0x00,0xc0,0x00,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x0c,0x00,0x0c,0x00,0x03,0x00,0x03,0xc0,0x00,0xc0,0x00,0xf0,0x3f,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xc0,0x30,0xc0,0x30,0x00,0x00,0xc0,0x3f,0xc0,0x3f,0x00,0xc0,0x00,0xc0,0xc0,0xff,0xc0,0xff,0x30,0xc0,0x30,0xc0,0xc0,0xff,0xc0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xc0,0x30,0xc0,0x30,0x00,0x00,0xc0,0x3f,0xc0,0x3f,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0x30,0xc0,0xc0,0x3f,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x30,0x30,0x30,0x30,0x00,0x00,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xc0,0xcf,0xc0,0xcf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xc0,0x0f,0xc0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x30,0x30,0x30,0x30,0x30,0xf0,0x0f,0xf0,0x0f,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xcc,0xcc,0xcc,0xcc,0x30,0x33,0x30,0x33,0xcc,0xcc,0xcc,0xcc,0x30,0x33,0x30,0x33,0xcc,0xcc,0xcc,0xcc,0x30,0x33,0x30,0x33,0xcc,0xcc,0xcc,0xcc,0x30,0x33,0x30,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
}

};
