
import java.sql.*;


/**
 *
 * Make sure the calling ResultSet.getXXX() will return a reasonable error 
 * if it's called before the ResultSet.next();
 *
 */
public class t0043
{

   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException 
   {
      boolean    passed = true;

      try
      {
         System.out.println("test ResultSet.getXXX() error message");
         
         // open the database
         Class.forName("com.internetcds.jdbc.tds.Driver");
         
         
         int           i;
         int           count    = 0;
         Connection    cx       = Common.getConnection();
         Statement     stmt     = cx.createStatement();
         
         
         ResultSet rs = stmt.executeQuery("select 1");
         
         passed = passed && rs != null;
         
         i = rs.getInt(1);
         
         passed = false;
      }
      catch (java.sql.SQLException e)
      {
         passed = e.getMessage().startsWith("No current row in the result set");
         if (!passed)
         {
            System.out.println("Caught an exception.  " + e.getMessage());
            e.printStackTrace();
         } 
      }
      catch (java.lang.Exception e)
      {
         passed = false;
         System.out.println("Caught an exception.  " + e.getMessage());
         e.printStackTrace();
      }
      
      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0043.\n");
      System.exit(passed ? 0 : 1);
   }
}

