
import java.sql.*;


/**
 * test fetching empty results sets
 *
 */
public class t0011
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException 
   {
      System.out.println("test fetching empty results sets");

      // open the database
      Class.forName("com.internetcds.jdbc.tds.Driver");

      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();
      boolean     passed   = true;

      try
      {
         stmt.executeUpdate("drop table t0011");
      }
      catch (SQLWarning e)
      {
         String okayError = "Cannot drop the table";

         if (! (e.getMessage().startsWith(okayError)))
         {
            throw e;
         }
      }
    
      count = stmt.executeUpdate("create table t0011              "
                                 + "  (mytime  datetime not null, "
                                 + "   mytime2 datetime null     )");
      System.out.println("Creating table affected " + count + " rows");
    
    
      ResultSet  rs1 = stmt.executeQuery("select mytime, mytime2"
                                         + " from t0011");
    
      passed = passed && (!rs1.next());
      if (!passed)
      {
         throw new SQLException("Already failed");
      }

      stmt.close();

      stmt = cx.createStatement();

      rs1 = stmt.executeQuery("select mytime, mytime2"
                              + " from t0011");
      passed = passed && (!rs1.next());
      rs1.close();


      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0011.\n");
      System.exit(passed ? 0 : 1);
   }
}

