package biss.jde;

import biss.CLPrintStream;
import biss.VectorLib;
import biss.VectorSorter;
import biss.awt.List;
import biss.awt.SelfDrawingObject;
import java.awt.Rectangle;
import java.io.*;
import java.util.*;

/**
 * model to describe Java class types
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
class ClassDecl
  extends TypeDecl
{
	String Super;

ClassDecl () {
	Mods = new BitSet( NMods);
	Id = "<noname>";
}

public ClassDecl ( BitSet mods, String id ) {
	Mods = mods;
	Id = id;
}

public void 	drawSelfIn ( Object pane ){
	List p = (List) pane;
	DrawSupport.drawTypeDecl( p, Id, Mods, false, p.DrawClrFore ); 
}

boolean merge ( TypeDecl other, boolean full ) {
	super.merge( other, full);

	ClassDecl cls = (ClassDecl) other;
	if ( cls != null ) 
		Super = cls.Super;

	return true;
}

public void printOn ( PrintStream s, boolean withFields, 
               boolean withCmt, boolean withMods ) {
	if ( s instanceof CLPrintStream )
		Line = ((CLPrintStream)s).Line;

	if ( withCmt ) printCommentOn( s);
	if ( withMods ) printModsOn( s);

	s.print( "class ");
	s.print( Id);

	if ( Super != null ){
		s.print( "\n  extends ");
		s.print( Super);
	}

	if ( Interfaces.size() > 0 ) {
		s.print( "\n  implements ");
		for ( Enumeration e = Interfaces.elements() ;;) {
			s.print( e.nextElement());
			if ( e.hasMoreElements() )
				s.print( ", ");
			else
				break;
		}
	}

	if ( withFields ) {
		s.println( "\n{");
		printDatasOn( s);
		s.println();
		printMethodsOn( s);
		s.println( "}");
	}
}

public void setSuper ( String clsName ) {
	Super = clsName;
}
}

/**
 * model to describe Java interface types
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
class InterfaceDecl
  extends TypeDecl
{

public InterfaceDecl ( BitSet mods, String id ) {
	Mods = mods;
	Id = id;
}

public void 	drawSelfIn ( Object pane ){
	List p = (List) pane;
	DrawSupport.drawTypeDecl( p, Id, Mods, true, p.DrawClrFore ); 
}

void printOn ( PrintStream s, boolean withFields, boolean withCmt, boolean withMods ) {
	if ( s instanceof CLPrintStream )
		Line = ((CLPrintStream)s).Line;

	if ( withCmt ) printCommentOn( s);
	if ( withMods ) printModsOn( s);

	s.print( "interface ");
	s.print( Id);

	if ( Interfaces.size() > 0 ) {
		s.print( "\n  extends ");
		for ( Enumeration e = Interfaces.elements() ;;) {
			s.print( e.nextElement());
			if ( e.hasMoreElements() )
				s.print( ", ");
			else
				break;
		}
	}

	if ( withFields ) {
		s.println( "\n{");

		printDatasOn( s);
		printMethodsOn( s);

		s.println( "\n}");
	}
}
}

/**
 * abstract model to describe Java types (classes or interfaces)
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
abstract class TypeDecl
  implements SelfDrawingObject, Mod
{
	static TypeDeclSorter Sorter = new TypeDeclSorter();
	public static BitSet PossibleMods;
	BitSet Mods;
	String Id;
	String Comment;
	Vector Interfaces = new Vector( 3);
	Vector Datas = new Vector( 10);
	Vector Methods = new Vector( 10);
	int Line;
	TypeDeclContainer CU;

static {
	PossibleMods = new BitSet( NMods);
	PossibleMods.set( PUBLIC);
	PossibleMods.set( ABSTRACT);
	PossibleMods.set( FINAL);
}

public boolean addData ( Data data ) {
	//    VectorLib.sortIn( Datas, data, Data.Sorter);
	Datas.addElement( data);  // because init might depend on order
	return true;
}

public boolean addMethod ( Method mth ) {
	VectorLib.sortIn( Methods, mth, Method.Sorter);
	return true;
}

static String allDefinitions ( Vector list, boolean withCmt, boolean withMods ) {
	ByteArrayOutputStream o = new ByteArrayOutputStream( 300);
	PrintStream s = new PrintStream( o);
	for ( Enumeration e=list.elements(); e.hasMoreElements(); ) {
		((TypeDecl) e.nextElement()).printOn( s, false, withCmt, withMods);
		s.println( "\n");
	}
	return o.toString();
}

String commentOrTemplate () {
	if ( Comment != null ) 
		return Comment;
	else
		return "/**\n * \n */";
}

public Data dataAt ( String name) {
	for ( Enumeration e=Datas.elements(); e.hasMoreElements(); ) {
		Data d = (Data)e.nextElement();
		if ( d.Id.equals( name) )
			return d;
	}
	return null;
}

String definition () {
	ByteArrayOutputStream o = new ByteArrayOutputStream( 100);
	PrintStream s = new PrintStream( o);
	printOn( s, false, false, true);
	return o.toString();
}

void delDatas ( Vector list ) {
	VectorLib.removeAllElements( Datas, list);
}

void delMethods ( Vector list ) {
	VectorLib.removeAllElements( Methods, list);
}

public int  	drawHeight(){
	return DrawSupport.Cy;
}

abstract public void 	drawSelfIn ( Object pane);

public boolean equals ( Object other ) {
	TypeDecl d = (TypeDecl) other;
	return ( (d != null) && Id.equals( d.Id));
}

FieldDecl fieldOfLine ( int line ) {
	FieldDecl f = null;
	int       dist = 100000;

	for ( Enumeration e=Datas.elements(); e.hasMoreElements(); ){
		FieldDecl ff = (FieldDecl) e.nextElement();
		int d = line - ff.Line;
		if ( d > 0 && d < dist ) {
			dist = d;
			f = ff;
		}
	}

	for ( Enumeration e=Methods.elements(); e.hasMoreElements(); ){
		FieldDecl ff = (FieldDecl) e.nextElement();
		int d = line - ff.Line;
		if ( d > 0 && d < dist ) {
			dist = d;
			f = ff;
		}
	}

	return f;
}

public void formatAllMethods ( MethodFormatter mf ) {
	if ( (Methods != null) && (Methods.size() > 0) ) {
		try {
			for ( Enumeration e = Methods.elements() ; e.hasMoreElements(); ) {
				((Method)e.nextElement()).format( mf );
			}
		}
		catch ( Exception x ) { x.printStackTrace(); }
	}
}

public String getComment () {
	return Comment;
}

public String getFileName () {
	if ( CU != null )
		return CU.getFileName();
	else
		return null;
}

public String getPackage () {
	if ( CU != null )
		return CU.getPackage();
	else
		return null;
}

public String getQualifiedId () {
	String pckg = getPackage();
	return (pckg==null) ? Id : pckg + '.' + Id;
}

public static String getTemplate () {
	return "class \n  extends \n  implements ";
}

public boolean hasData ( String name) {
	for ( Enumeration e=Datas.elements(); e.hasMoreElements(); ) {
		Data d = (Data)e.nextElement();
		if ( d.Id.equals( name) )
			return true;
	}
	return false;
}

public boolean hasMainMethod () {
	return hasMethod( "main");
}

public boolean hasMethod ( String name) {
	for ( Enumeration e=Methods.elements(); e.hasMoreElements(); ) {
		Method m = (Method)e.nextElement();
		if ( m.Name.equals( name) )
			return true;
	}
	return false;
}

public String	label(){
	return Id;
}

public int  	maxDrawWidth(){
	return DrawSupport.Cx * 50;
}

boolean merge ( TypeDecl other, boolean full ) {
	Mods = (BitSet) other.Mods;
	Interfaces = (Vector)other.Interfaces;

	if (Comment == null && other.Comment != null )
		Comment = other.Comment;

	if ( full ) {
		mergeDatas( other.Datas, null);
		mergeMethods( other.Methods, null);
	}
	return true;
}

void mergeDatas ( Vector newDatas, BitSet defaultMods ) {
	int i;
	for ( Enumeration e=newDatas.elements(); e.hasMoreElements(); ){
		Data dNew = (Data) e.nextElement();
		Data dOld = (Data) VectorLib.firstEqualElement( Datas, dNew);
		if ( dOld != null )
			dOld.mergeWith( dNew);
		else {
			if ( !dNew.hasMods() && defaultMods != null )
				dNew.Mods = (BitSet) defaultMods.clone();
			addData( dNew);
		}
	}
}

void mergeMethods ( Vector newMethods, BitSet defaultMods ) {
	int i;
	for ( Enumeration e=newMethods.elements(); e.hasMoreElements(); ){
		Method mNew = (Method) e.nextElement();
		Method mOld = (Method) VectorLib.firstEqualElement( Methods, mNew);
		if ( mOld != null )
			mOld.mergeWith( mNew);
		else {
			if ( !mNew.hasMods() && defaultMods != null )
				mNew.Mods = (BitSet) defaultMods.clone();
			addMethod( mNew);
		}
	}
}

public Method methodAt ( String name) {
	for ( Enumeration e=Methods.elements(); e.hasMoreElements(); ) {
		Method m = (Method)e.nextElement();
		if ( m.Name.equals( name) )
			return m;
	}
	return null;
}

void printCommentOn( PrintStream s) {
	if ( Comment != null )
		s.println( Comment);
}

public void printDatasOn ( PrintStream s ) {
	if ( Datas != null ) {
		for ( Enumeration e = Datas.elements() ; e.hasMoreElements() ;){
			((Data)e.nextElement()).printOn( s, true, true);
		}
	}
}

public void printMethodsOn ( PrintStream s ) {
	if ( (Methods != null) && (Methods.size() > 0) ) {
		for ( Enumeration e = Methods.elements() ;;) {
			((Method)e.nextElement()).printOn( s, true, true);
			if ( e.hasMoreElements() )
				s.println();
			else
				break;
		}
	}
}

void printModsOn ( PrintStream s ) {
	for ( int i=0; i<NMods; i++ ){
		if ( Mods.get( i) ){
			s.print( ModName[i]);
			s.print( ' ');
		}
	}
}

abstract void printOn ( PrintStream s,
               boolean withFields, boolean withCmt, boolean withMods );

public void setComment ( String s ) {
	if ( s == null || s.length() == 0 )
		Comment = null;
	else
		Comment = s;
}

void setDatas ( Vector newDatas ) {
	Datas = newDatas;
}

public void setInterfaces( Vector ifList ) {
	Interfaces = ifList;
}

void setMethods ( Vector newMethods ) {
	Methods = newMethods;
}

void shrink () {
	Datas = new Vector(10);
	Methods = new Vector(10);
}
}

interface TypeDeclContainer
{
public String getFileName();

public String getPackage();

}

class TypeDeclSorter
  implements VectorSorter
{
	boolean UseQualified = false;
	boolean UseIdFirst = false;

public TypeDeclSorter () {}

public TypeDeclSorter ( boolean useQualifiedId, boolean useIdFirst ) {
	UseQualified = useQualifiedId;
	UseIdFirst = useIdFirst;
}

public int compare ( Object a, Object b ) {
	TypeDecl ta = (TypeDecl) a;
	TypeDecl tb = (TypeDecl) b;
	int      cId = ta.Id.compareTo( tb.Id);

	if ( UseQualified ) {
		String taPackage = ta.getPackage();
		String tbPackage = tb.getPackage();

		if ( taPackage == null ) {
			if ( tbPackage == null )
				return cId;
			else {
				if ( UseIdFirst ) {
					if ( cId == 0 ) return -1;
					else            return cId;
				}
				else
					return ta.Id.compareTo( tbPackage);
			}
		}
		else {
			if ( tbPackage == null ) {
				if ( UseIdFirst ) {
					if ( cId == 0 ) return 1;
					else            return cId; 
				}
				else
					return taPackage.compareTo( tb.Id);
			}
			else {
				int cPckg = taPackage.compareTo( tbPackage);
				if ( cPckg == 0 ) return cId;
				else              return cPckg;
			}
		}
	}
	else
		return cId;
}
}
