package biss.jde;

import biss.PackageProperties;
import biss.XorSet;
import biss.awt.Awt;
import biss.awt.Border;
import biss.awt.Checkbox;
import biss.awt.Label;
import biss.awt.Layouter;
import biss.awt.List;
import biss.awt.Menu;
import biss.awt.TopWindow;
import java.awt.Rectangle;

/**
 * physical view to browse a set of CompileUnits (Java sources) organized
 * in directories and/or packages
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class LibViewer
  extends TopWindow
{
	Checkbox FileBtn = new Checkbox( "File");
	Checkbox TypeBtn = new Checkbox( "Type");
	List CntrPane = new List();
	List ItemPane = new List();
	Label Info = new Label("");
	Layouter Lo = new Layouter( this);

public LibViewer () {
	super( "Library Viewer");
	open();
}

public LibViewer ( Rectangle openRect ) {
	super( "Library Viewer");
	Bounds = Jde.LibBrowserRect;
	open();
}

public void init() {
	XorSet radios = new XorSet();
	FileBtn.setExclusive( radios);
	TypeBtn.setExclusive( radios);

	Info.setBorder( Border.BS_INSET);

	Menu m = new Menu();
	m.addItem( "~edit");
	m.addItem( "~design");
	m.addItem( "~image");
	m.addSeparator();
	m.addItem( "~add");
	m.addItem( "~remove");
	ItemPane.setMenu( m);

	m = new Menu();
	m.addItem( "clone");
	CntrPane.setMenu( m);
}

public static void main ( String[] args ) {
	new LibViewer();
}

public void open () {
	Lo.add( FileBtn,   200,    0,   450,    0, true,   0,     0,    0,  150,  0 );
	Lo.add( TypeBtn,   550,    0,   900,    0, true,   0,     0,    0,  150,  0 );
	Lo.add( CntrPane,    0,    0,  1000,  300, true,   50,  150,  -50,    0,  0 );
	Lo.add( ItemPane,    0,  300,  1000, 1000, true,   50,    0,  -50, -180,  2 );
	Lo.add( Info,        0,  1000, 1000, 1000, true,   50, -150,  -50,  -20,  0 );

	init();
	if ( Bounds != null)
		openIn( Bounds);
	else
		openIn( 500, 200, 280, 320);
}
}
