package biss.jde;

import biss.ObserverSocket;
import biss.VectorLib;
import biss.VectorSorter;
import biss.awt.Awt;
import biss.awt.Button;
import biss.awt.Checkbox;
import biss.awt.Layouter;
import biss.awt.TopWindow;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

class CBSorter
  implements VectorSorter
{

public int compare ( Object a, Object b ) {
	return ((Checkbox)a).getContents().compareTo( ((Checkbox)b).getContents());
}
}

/**
 * generic dialog to choose from a set of Checkboxs (used to
 * set type/field/method modifiers)
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class ItemCheckDlg
  extends TopWindow
{
	final static int H = 16;
	Object[] Items;
	BitSet Displayed;
	BitSet Checked;
	Vector CB;
	Hashtable Id;
	Button SetBtn = new Button( "~Set");
	Button ExitBtn = new Button( "E~xit");
	Layouter GM = new Layouter( this);
	ObserverSocket OsSet = new ObserverSocket( this);

public ItemCheckDlg () {
	super( "ItemCheckDlg");
	open();
}

public ItemCheckDlg ( String title,
               String[] labels, BitSet display, BitSet check,
               Observer obs ) {
	super( title);
	setButtons( labels, display);
	setChecked( check);

	Bounds = computeBounds();
	open();

	if ( obs != null ) {
		OsClose.addObserver( obs);
		OsSet.addObserver( obs);
	}
}

Rectangle computeBounds () {
	int w = 22 * Awt.SysFontWidth;
	int h = (CB.size() + 4) * Awt.SysFontHeight * 16 / 10;

	return new Rectangle( 0, 0, w, h);
}

public BitSet getChecked () {
	return Checked;
}

public void init() {
	SetBtn.OsAction.addObserver( this);
	ExitBtn.OsAction.addObserver( this);
}

public static void main ( String[] args ) {
	String[] mod1 = { "private", "protected", "public", "static", "blabla" };
	BitSet disp = new BitSet( mod1.length);
	for ( int i=0; i<mod1.length; i++ ) disp.set(i);
	BitSet chk = new BitSet( mod1.length);
	chk.set(2);

	ItemCheckDlg dlg = new ItemCheckDlg( "CheckDlg", mod1, disp, chk, null);

	try { Thread.sleep( 2000); } catch ( Exception x ) {}
	chk.clear(2); chk.set(1);
	dlg.setChecked( chk);

	try { Thread.sleep( 5000); } catch ( Exception x ) {}

	dlg.setContents( mod1, disp);
	/*
	  String[] mod2 = { "synchronized", "transient", "volatile" };
	  disp = new BitSet( 2); disp.set(0); disp.set(1);
	  dlg.setContents( mod2, disp);
	 */
}

public void open() {
	GM.add( SetBtn,    0, 1000,  500, 1000,  true, 0, -160, 0, 0,  0);
	GM.add( ExitBtn, 500, 1000, 1000, 1000,  true, 0, -160, 0, 0,  0);

	init();
	if ( Bounds != null)
		openIn( Bounds);
	else
		openIn( 0, 0, 200, 200);
}

void setButtons ( Object[] items, BitSet displayed ) {
	int i;
	int m = Math.min( displayed.size(), items.length);
	Checkbox c;

	if ( CB != null ) {
		for ( i=0; i<CB.size(); i++ )
			remove( (Checkbox)CB.elementAt(i) );
	}

	Items = items;
	Displayed = displayed;

	CB = new Vector( m);
	Id = new Hashtable( m);
	for ( i=0; i<m; i++ ) {
		if ( displayed.get(i) ) {
			c = new Checkbox( Items[i].toString());
			c.OsAction.addObserver( this);
			CB.addElement( c);
			Id.put( c, new Integer( i));
		}
	}

	VectorLib.quickSort( CB, new CBSorter());

	for ( i=0; i<CB.size(); i++ ){
		c = (Checkbox)CB.elementAt(i);
		GM.add( c, 500, 0, 500, 0, true, -300, 160*(i+1), 600, 160*(i+2),  0);
	}
}

void setCheckState ( Checkbox cb ) {
	int i = ((Integer)Id.get( cb)).intValue();
	if ( cb.isChecked() )
		Checked.set(i);
	else
		Checked.clear(i);
}

public void setChecked ( BitSet checked ) {
	Checked = new BitSet( Items.length);

	for ( Enumeration e=CB.elements(); e.hasMoreElements(); ) {
		Checkbox cb = (Checkbox) e.nextElement();
		int i = ((Integer)Id.get( cb)).intValue();
		cb.setChecked( (checked != null && checked.get(i)), true);
	}
}

public void setContents ( Object[] items, BitSet display ) {
	setButtons( items, display);
	Bounds = computeBounds();
	resize( Bounds.width, Bounds.height);
	GM.forceLayout();
}

public void update ( Observable slot, Object arg ) {
	if ( slot == ExitBtn.OsAction ) 
		dispose();
	else if ( slot == SetBtn.OsAction )
		OsSet.notifyObservers( this);
	else if ( arg instanceof Checkbox )
		setCheckState( (Checkbox) arg);
	else
		super.update( slot, arg);
}
}
