package biss.jde;

import biss.awt.BarMenu;
import biss.awt.Border;
import biss.awt.Button;
import biss.awt.DecoText;
import biss.awt.DefaultIndexModel;
import biss.awt.GraphPane;
import biss.awt.Label;
import biss.awt.Layouter;
import biss.awt.Menu;
import biss.awt.SpinButton;
import biss.awt.TopWindow;
import java.awt.Color;

/**
 * physical view of the ImageEditor
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class ImageViewer
  extends TopWindow
{
	Layouter Lo = new Layouter( this);
	GraphPane Color1 = new GraphPane();
	GraphPane Color2 = new GraphPane();
	GraphPane Color3 = new GraphPane();
	GraphPane Color4 = new GraphPane();
	GraphPane Color5 = new GraphPane();
	GraphPane Color6 = new GraphPane();
	GraphPane Color7 = new GraphPane();
	GraphPane Color8 = new GraphPane();
	GraphPane Color9 = new GraphPane();
	GraphPane Color10 = new GraphPane();
	GraphPane Color11 = new GraphPane();
	GraphPane Color12 = new GraphPane();
	GraphPane Color13 = new GraphPane();
	Label CurCol = new Label();
	GraphPane PelPane = new GraphPane();
	DecoText TWidth = new DecoText("Width");
	DecoText THeight = new DecoText("Height");
	DecoText TColor = new DecoText("Color");
	Button CPrev = new Button("Preview");
	GraphPane CPrevView = new GraphPane();
	Button CNew = new Button("New");
	Button CSave = new Button("Save");
	Button CClose = new Button("Exit");
	SpinButton CXDim = new SpinButton();
	SpinButton CYDim = new SpinButton();
	GraphPane ColorTrans = new GraphPane();
	SpinButton CPath = new SpinButton();
	DecoText TPath = new DecoText("P:");
	BarMenu BMenu = new BarMenu();

public ImageViewer(){
	super( "ImageViewer");
	open();
}

public void init() {
	Color1.setBackground( Color.white);
	Color2.setBackground( Color.lightGray);
	Color3.setBackground( Color.gray);
	Color4.setBackground( Color.darkGray);
	Color5.setBackground( Color.black);
	Color6.setBackground( Color.red);
	Color7.setBackground( Color.pink);
	Color8.setBackground( Color.orange);
	Color9.setBackground( Color.yellow);
	Color10.setBackground( Color.green);
	Color11.setBackground( Color.magenta);
	Color12.setBackground( Color.cyan);
	Color13.setBackground( Color.blue);

	ColorTrans.setBackground( DefaultIndexModel.getTransColor() );
	CurCol.setBackground( Color.black);

	PelPane.setBorder( Border.BS_NONE);
	CPrevView.setBorder( Border.BS_INSET);

	CXDim.setReadOnly( false);
	CYDim.setReadOnly( false);

	String[] pa = { "none", "line", "rect", "circle" };
	CPath.setContents( pa);

	BMenu.addItem( "File", new Menu( "Save,Load GIF"));
}

public static void main( String[] args) {
	new ImageViewer();
}

public void open() {
	Lo.add( PelPane, 0, 0, 1000, 1000, false, 0, 18, -81, -23, 0);
	Lo.add( CPrevView, 1000, 0, 1000, 0, false, -78, 18, 0, 78, 0);
	Lo.add( CPrev, 1000, 0, 1000, 0, false, -78, 81, 0, 105, 0);
	Lo.add( CNew, 1000, 0, 1000, 0, false, -78, 108, 0, 132, 0);
	Lo.add( CSave, 1000, 0, 1000, 0, false, -78, 135, 0, 159, 0);
	Lo.add( CClose, 1000, 0, 1000, 0, false, -78, 162, 0, 186, 0);
	Lo.add( CXDim, 1000, 0, 1000, 0, false, -42, 210, 0, 228, 0);
	Lo.add( CYDim, 1000, 0, 1000, 0, false, -42, 231, 0, 249, 0);
	Lo.add( Color1, 0, 1000, 0, 1000, false, 0, -18, 18, 0, 0);
	Lo.add( Color2, 0, 1000, 0, 1000, false, 21, -18, 39, 0, 0);
	Lo.add( Color3, 0, 1000, 0, 1000, false, 42, -18, 60, 0, 0);
	Lo.add( Color4, 0, 1000, 0, 1000, false, 63, -18, 81, 0, 0);
	Lo.add( Color5, 0, 1000, 0, 1000, false, 84, -18, 102, 0, 0);
	Lo.add( Color6, 0, 1000, 0, 1000, false, 105, -18, 123, 0, 0);
	Lo.add( Color7, 0, 1000, 0, 1000, false, 126, -18, 144, 0, 0);
	Lo.add( Color8, 0, 1000, 0, 1000, false, 147, -18, 165, 0, 0);
	Lo.add( Color9, 0, 1000, 0, 1000, false, 168, -18, 186, 0, 0);
	Lo.add( Color10, 0, 1000, 0, 1000, false, 189, -18, 207, 0, 0);
	Lo.add( Color11, 0, 1000, 0, 1000, false, 210, -18, 228, 0, 0);
	Lo.add( Color12, 0, 1000, 0, 1000, false, 231, -18, 249, 0, 0);
	Lo.add( Color13, 0, 1000, 0, 1000, false, 252, -18, 270, 0, 0);
	Lo.add( CurCol, 1000, 1000, 1000, 1000, false, -42, -18, 0, 0, 0);
	Lo.add( TWidth, 1000, 0, 1000, 0, false, -78, 210, -42, 228, 0);
	Lo.add( THeight, 1000, 0, 1000, 0, false, -78, 231, -42, 249, 0);
	Lo.add( TColor, 1000, 1000, 1000, 1000, false, -78, -18, -42, 0, 0);
	Lo.add( ColorTrans, 0, 1000, 0, 1000, false, 294, -18, 312, 0, 0);
	Lo.add( CPath, 1000, 0, 1000, 0, false, -60, 189, 0, 207, 0);
	Lo.add( TPath, 1000, 0, 1000, 0, false, -78, 189, -60, 207, 0);
	Lo.add( BMenu, 0, 0, 1000, 0, false, 0, 0, 0, 18, 0);

	init();
	if ( Bounds != null)
		openIn( Bounds);
	else
		openIn( 26, 75, 406, 302);
}
}
